/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.service.impl;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.JavaCodeFormatUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.XMLCodeParserUtil;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.code.HeCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.engine.result.HeCodeResult;
import com.jxdinfo.hussar.formdesign.engine.service.HeModelPublishService;
import com.jxdinfo.hussar.formdesign.engine.util.HeBackRenderUtil;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HeModelPublishServiceImpl
implements HeModelPublishService {
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private VersionManageService versionManageService;
    @Resource
    private PathStrategyService pathStrategy;
    private static final String CLIENT_TYPE = "publishIds";

    @Override
    public void mergeBack(List<HeCodeGenerateInfo> codeGenerateInfos, PublishCtx<HeCodeResult> publishCtx) throws LcdpException, IOException {
        if (ToolUtil.isNotEmpty(codeGenerateInfos)) {
            List<Object> publishIds = new ArrayList();
            if (null != Optional.ofNullable(publishCtx.getParams()).orElseGet(HashMap::new).get(CLIENT_TYPE)) {
                publishIds = Arrays.asList(publishCtx.getParams().get(CLIENT_TYPE).toString().split(","));
            }
            for (HeCodeGenerateInfo codeGenerateInfo : codeGenerateInfos) {
                if ("js".equals(codeGenerateInfo.getFileType()) && ToolUtil.isNotEmpty(publishIds)) {
                    for (String string : publishIds) {
                        publishCtx.addCodeResult((CodeResult)this.getEngineBackCode(codeGenerateInfo, publishCtx.getBaseFile(), string));
                    }
                    continue;
                }
                publishCtx.addCodeResult((CodeResult)this.getEngineBackCode(codeGenerateInfo, publishCtx.getBaseFile(), ""));
            }
        }
    }

    private HeCodeResult getEngineBackCode(HeCodeGenerateInfo codeGenerateInfo, BaseFile baseFile, String publishId) throws IOException, LcdpException {
        String absolutePath = this.pathStrategy.javaPathService().backProjectJava(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
        HeCodeResult codeResult = new HeCodeResult();
        codeResult.setResultType(ResultBeanEnum.LR_ENGINE_RESULT);
        this.formatCode(codeGenerateInfo);
        String cacheId = "";
        cacheId = HussarUtils.isNotEmpty((Object)baseFile) ? baseFile.getId() : codeGenerateInfo.getFileId();
        if (!codeGenerateInfo.isCodeFormatSucceed()) {
            codeResult.setId(cacheId);
            codeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
            codeResult.setNewCode(codeGenerateInfo.getFileContent());
            codeResult.setCodeFormatMessages(codeGenerateInfo.getCodeFormatMessages());
            codeResult.setMsg(codeGenerateInfo.getCodeFormatMsg());
            codeResult.setCodeFormatSucceed(codeGenerateInfo.isCodeFormatSucceed());
            return codeResult;
        }
        String dataId = this.getVersionFileKey(codeGenerateInfo);
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            String writeFile = codeGenerateInfo.getFileContent();
            if (!codeResult.isExistConflict()) {
                absolutePath = this.writeNoConflictCode(codeGenerateInfo, baseFile, dataId, writeFile);
            }
        }
        codeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
        return codeResult;
    }

    private void formatCode(HeCodeGenerateInfo codeGenerateInfo) {
        String fileType = codeGenerateInfo.getFileType();
        if (ToolUtil.isNotEmpty((Object)fileType) && ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            CodeFormatResult codeFormatResult;
            if (fileType.equals("controller") || fileType.equals("entity") || fileType.equals("mapper") || fileType.equals("service") || fileType.equals("serviceImpl") || fileType.equals("queryEntity")) {
                codeFormatResult = JavaCodeFormatUtil.format((String)codeGenerateInfo.getFileContent());
                codeGenerateInfo.setFileContent(codeFormatResult.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult.isSucceed());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult.getMessages());
            }
            if (fileType.equals("js")) {
                codeFormatResult = CodeFormatter.formatterHtml((String)codeGenerateInfo.getFileContent(), (String)"typescript");
                codeGenerateInfo.setFileContent(codeFormatResult.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult.isSucceed());
                codeGenerateInfo.setCodeFormatMsg(codeFormatResult.getMsg());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult.getMessages());
            }
            FormDesignProperties formDesignProperties = (FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class);
            if (fileType.equals("xml") && formDesignProperties.isCheckedCode()) {
                CodeFormatResult codeFormatResult2 = XMLCodeParserUtil.parser((String)codeGenerateInfo.getFileContent());
                codeGenerateInfo.setFileContent(codeFormatResult2.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult2.isSucceed());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult2.getMessages());
            }
        }
    }

    public String writeNoConflictCode(HeCodeGenerateInfo codeGenerateInfo, BaseFile baseFile, String dataId, String writeFile) throws IOException {
        String cacheId = "";
        cacheId = HussarUtils.isNotEmpty((Object)baseFile) ? baseFile.getId() : codeGenerateInfo.getFileId();
        String absolutePath = this.filePublishService.writeApiCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), cacheId);
        this.versionManageService.saveCacheLastPublishCode(dataId, codeGenerateInfo.getFileContent(), cacheId);
        this.versionManageService.saveCacheLastFileCode(dataId, writeFile, cacheId);
        return absolutePath;
    }

    private String getVersionFileKey(HeCodeGenerateInfo codeGenerateInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(codeGenerateInfo.getFileId());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getPageType())) {
            stringBuilder.append(codeGenerateInfo.getPageType());
        }
        stringBuilder.append(codeGenerateInfo.getFileType());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileName())) {
            stringBuilder.append(codeGenerateInfo.getFileName());
        }
        return stringBuilder.toString();
    }

    @Override
    public List<HeCodeGenerateInfo> renderCode(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx, PublishCtx<HeCodeResult> publishCtx) throws LcdpException {
        ArrayList<HeCodeGenerateInfo> codeGenerateInfos = new ArrayList<HeCodeGenerateInfo>();
        HeDataModelBaseDTO dataModelDto = backCtx.getUseDataModelDtoMap().get(backCtx.getUseDataModelBase().getId());
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String pageType = "WebPage";
        if (ToolUtil.isNotEmpty((Object)publishCtx.getBaseFile()) && ToolUtil.isNotEmpty((Object)publishCtx.getBaseFile().getType())) {
            pageType = publishCtx.getBaseFile().getType();
        } else if (ToolUtil.isNotEmpty((Object)publishCtx.getParams()) && ToolUtil.isNotEmpty(publishCtx.getParams().get(CLIENT_TYPE))) {
            pageType = publishCtx.getParams().get(CLIENT_TYPE).toString();
        }
        String filePath = "template/backcode/api/api-${pageType}-file.ftl".replace("${pageType}", pageType);
        String newCode = HeBackRenderUtil.renderTemplate(filePath, dataModelDto);
        HeCodeGenerateInfo codeGenerateInfo = new HeCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileId(backCtx.getUseDataModelBase().getId());
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)backCtx.getBaseFile()) && ToolUtil.isNotEmpty((Object)backCtx.getBaseFile().getType())) {
            codeGenerateInfo.setPageType(backCtx.getBaseFile().getType());
        }
        codeGenerateInfos.add(codeGenerateInfo);
        return codeGenerateInfos;
    }

    @Override
    public HeDataModelBaseDTO enclosure(HeDataModelBase dataModelBase) {
        HeDataModelBaseDTO dataModelBaseDTO = new HeDataModelBaseDTO();
        dataModelBaseDTO.setName(dataModelBase.getName());
        dataModelBaseDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        dataModelBaseDTO.setTablePath(dataModelBase.getModelPath() + File.separator + dataModelBaseDTO.getName());
        List<HeDataModelField> dataModelFieldBases = dataModelBase.getFields();
        ArrayList<HeDataModelFieldDto> tableFields = new ArrayList<HeDataModelFieldDto>();
        if (HussarUtils.isEmpty(dataModelFieldBases)) {
            dataModelBaseDTO.setFields(new ArrayList<HeDataModelFieldDto>());
            return dataModelBaseDTO;
        }
        for (HeDataModelField dataModelFieldBase : dataModelFieldBases) {
            HeDataModelFieldDto tableField = new HeDataModelFieldDto();
            tableField.setKeyFlag("primary".equals(dataModelFieldBase.getUsage()));
            tableField.setDelFlag("delDefFlag".equals(dataModelFieldBase.getUsage()));
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setId(dataModelFieldBase.getId());
            tableField.setTableName(dataModelBase.getSourceDataModelName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableFields.add(tableField);
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
        }
        dataModelBaseDTO.setFields(tableFields);
        return dataModelBaseDTO;
    }
}

