/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.visitor.flow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.engine.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.HeOperationVisitor;
import com.jxdinfo.hussar.formdesign.engine.function.element.flow.HeFlowDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.util.HeBackRenderUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.enums.EngineMethodEnum;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HUSSAR_ENGINEFLOWEndProcess")
public class HeEndProcessVisitor
implements HeOperationVisitor<HeFlowDataModel, HeDataModelBaseDTO> {
    private static final Logger logger = LoggerFactory.getLogger(HeEndProcessVisitor.class);
    public static final String OPERATION_NAME = "HUSSAR_ENGINEFLOWEndProcess";

    @Override
    public void visit(HeBackCtx<HeFlowDataModel, HeDataModelBaseDTO> backCtx, HeDataModelOperation dataModelOperation, PushBackCtx engineCtx) throws LcdpException, IOException {
        logger.debug("{}\u65b9\u6cd5\u5f00\u59cb", (Object)OPERATION_NAME);
        String currentModelId = backCtx.getUseDataModelBase().getId();
        HeDataModelBaseDTO dataModelDto = backCtx.getUseDataModelDtoMap().get(currentModelId);
        logger.debug("\u63a8\u9001\u89e3\u6790\u5f15\u64ce");
        EngineMethodEnum engineMethodEnum = engineCtx.isMs ? EngineMethodEnum.MULTI_BPM_END_PROCESS : EngineMethodEnum.SINGLE_BPM_END_PROCESS;
        HeEnginePushUtil.pushFlowNoBusiness(dataModelOperation.getName(), engineCtx, dataModelDto, engineMethodEnum.value.getName(), engineMethodEnum.value.getDesc(), Arrays.asList("taskId", "comment"));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelDto.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6d41\u7a0b\u7ec8\u6b62");
        backCtx.addApi(currentModelId, HeBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

