/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.util;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.element.flow.HeFlowDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.flow.HeFlowMSDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.HeMSDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryConditionField;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortConditionField;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.enums.EngineMethodEnum;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.dto.MsTableDto;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.enums.OrderByType;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeEnginePushUtil {
    private static EngineBussnessdataConfigService configService = (EngineBussnessdataConfigService)SpringContextUtil.getBean(EngineBussnessdataConfigService.class);
    private static ModelRelateService modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class);
    private static Logger logger = LoggerFactory.getLogger(HeEnginePushUtil.class);

    private HeEnginePushUtil() {
    }

    private static SingleTableDto getPushDto(List<HeDataModelFieldDto> fieldDtoList, PushBackCtx ctx, String businessId, String methodName, String methodDesc, int type) {
        SingleTableDto dto = HeEnginePushUtil.getSingleTableDto(ctx, businessId, methodName, methodDesc);
        if (type != 3 && type != 4) {
            dto.setPmList(new ArrayList());
            for (HeDataModelFieldDto field : fieldDtoList) {
                MetadataColumn column;
                if (field.getName() == null || (column = HeEnginePushUtil.getRelationShipField(ctx, field)) == null) continue;
                HeEnginePushUtil.getPm(dto.getPmList(), field, column, type);
            }
        }
        if (type != 1 && type != 6) {
            ArrayList<NodeBusinessPm> whereList = new ArrayList<NodeBusinessPm>();
            for (HeDataModelFieldDto field : fieldDtoList) {
                MetadataColumn column;
                if (!field.isKeyFlag() || (column = HeEnginePushUtil.getRelationShipField(ctx, field)) == null) continue;
                String parameterAlias = type == 4 ? "ids" : "id";
                parameterAlias = type == 2 ? field.getPropertyName() : parameterAlias;
                NodeBusinessPm id = HeEnginePushUtil.getNodeBusinessPm(parameterAlias, column);
                id.setOperatorType(type == 4 ? OperatorType.IN : OperatorType.EQ);
                id.setMatchType(MatchTypeEnum.AND);
                whereList.add(id);
                if (type == 2) continue;
                break;
            }
            dto.setWhere(whereList);
        }
        return dto;
    }

    private static MetadataColumn getRelationShipField(PushBackCtx ctx, HeDataModelFieldDto field) {
        String fieldName;
        MetadataColumn column;
        Map columnMap = ctx.getColumnMap();
        if (ctx.isMs && (column = (MetadataColumn)columnMap.get(fieldName = field.getTableName() + "-" + field.getName())) != null) {
            return column;
        }
        return HeEnginePushUtil.getMetadataColumn(columnMap, field.getName());
    }

    private static SingleTableDto getSingleTableDto(PushBackCtx ctx, String businessId, String methodName, String methodDesc) {
        HussarException.throwByNull((Object)methodName, (String)"\u65b9\u6cd5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        MsTableDto dto = ctx.getRelationship() != null ? new MsTableDto() : new SingleTableDto();
        dto.setBusinessId(businessId);
        dto.setMethodName(methodName);
        dto.setMethodDesc(methodDesc);
        return dto;
    }

    private static MetadataColumn getMetadataColumn(Map<String, MetadataColumn> columnMap, String name) {
        MetadataColumn column = columnMap.get(name);
        if (column == null) {
            logger.error("\u5217{}\u672a\u627e\u5230\u5f15\u64ce\u5143\u6570\u636e\u5bf9\u5e94\u5217", (Object)name);
            return null;
        }
        return column;
    }

    private static void getPm(List<NodeBusinessPm> pmList, HeDataModelFieldDto field, MetadataColumn column, int type) {
        NodeBusinessPm pm = HeEnginePushUtil.getNodeBusinessPm(field.getPropertyName(), column);
        switch (type) {
            case 1: {
                pm.setParameterType(ParameterType.values);
                break;
            }
            case 2: {
                pm.setParameterType(ParameterType.set);
                pm.setOperatorType(OperatorType.EQ);
                break;
            }
            case 5: 
            case 6: {
                pm.setParameterType(ParameterType.column);
                break;
            }
        }
        pmList.add(pm);
    }

    private static NodeBusinessPm getNodeBusinessPm(String parameterAlias, MetadataColumn column) {
        NodeBusinessPm pm = new NodeBusinessPm();
        pm.setColumnId(column.getColumnId());
        pm.setParameterAlias(parameterAlias);
        return pm;
    }

    public static <T extends SingleTableDto> void push(PushBackCtx ctx, List<String> flowColumns, T dto, int type) {
        switch (type) {
            case 1: {
                configService.saveSingleTableService(dto, ctx);
                break;
            }
            case 2: {
                configService.saveMasterSlaveService((MsTableDto)dto, ctx);
                break;
            }
            case 3: {
                configService.saveFlowSingleTableService(flowColumns, dto, ctx);
                break;
            }
            case 4: {
                configService.saveFlowMasterSlaveService(flowColumns, (MsTableDto)dto, ctx);
                break;
            }
        }
    }

    public static void pushFlowVisitSelect(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        boolean isMs = engineCtx.isMs;
        EngineMethodEnum engineMethodEnum = engineCtx.isMs ? EngineMethodEnum.MS_TABLE_BPM_SELECT : EngineMethodEnum.SINGLE_TABLE_SELECT_ONE;
        SingleTableDto dto = HeEnginePushUtil.getPushDto(dataModelBaseDTO.getFields(), engineCtx, name, engineMethodEnum.value.getName(), engineMethodEnum.value.getDesc(), 5);
        HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    public static void pushFormQuery(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        boolean isMs = engineCtx.isMs;
        EngineMethodEnum engineMethod = isMs ? EngineMethodEnum.MS_TABLE_SELECT_ONE : EngineMethodEnum.SINGLE_TABLE_SELECT_ONE;
        SingleTableDto dto = HeEnginePushUtil.getPushDto(dataModelBaseDTO.getFields(), engineCtx, HeEnginePushUtil.getUrl("GET", name, dataModelBaseDTO), engineMethod.value.getName(), engineMethod.value.getDesc(), 5);
        HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    private static void getWhere(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> heBackCtx, Map<String, String> tableNameFiledName2ColumnName, List<NodeBusinessPm> whereList, Map<String, MetadataColumn> columnMap, List<HeQueryConditionField> fields, Long pId) {
        for (HeQueryConditionField field : fields) {
            NodeBusinessPm nodeBusinessPm;
            if ("row".equals(field.getType())) {
                if (ToolUtil.isEmpty(heBackCtx.getUseDataModelDtoMap())) {
                    logger.error("\u672a\u521d\u59cb\u5316\u53d1\u5e03\u4e0a\u4e0b\u6587\uff0c\u6a21\u578bmap\u4e3a\u7a7a");
                    continue;
                }
                HeDataModelBaseDTO heDataModelBaseDTO = heBackCtx.getUseDataModelDtoMap().get(field.getFromModelId());
                if (heDataModelBaseDTO == null) {
                    logger.error("\u6a21\u578bid\u672a\u627e\u5230");
                    continue;
                }
                List<HeDataModelFieldDto> heDataModelBaseFields = heDataModelBaseDTO.getFields();
                if (ToolUtil.isEmpty(heDataModelBaseFields)) {
                    logger.error("\u6a21\u578b\u672a\u627e\u5230\u5217");
                    continue;
                }
                String fromModelFieldName = field.getFromModelField();
                for (HeDataModelFieldDto heDataModelBaseField : heDataModelBaseFields) {
                    if (!heDataModelBaseField.getId().equals(field.getFromModelField()) && !heDataModelBaseField.getPropertyName().equals(field.getFromModelField())) continue;
                    fromModelFieldName = heDataModelBaseField.getPropertyName();
                }
                MetadataColumn column = HeEnginePushUtil.getMetadataColumn(columnMap, tableNameFiledName2ColumnName.get(heDataModelBaseDTO.getSourceDataModelName() + "." + fromModelFieldName));
                if (column == null) continue;
                nodeBusinessPm = HeEnginePushUtil.getNodeBusinessPm(field.getQueryAttrName(), column);
                nodeBusinessPm.setMatchType("and".equals(field.getConnect()) ? MatchTypeEnum.AND : MatchTypeEnum.OR);
                nodeBusinessPm.setOperatorType(HeExternalApiUtil.getOperatorType(field.getSymbol()));
                nodeBusinessPm.setParameterType(ParameterType.where);
                nodeBusinessPm.setParentId(pId);
                whereList.add(nodeBusinessPm);
                continue;
            }
            if (!"child".equals(field.getType()) || !HussarUtils.isNotEmpty(field.getChildren())) continue;
            nodeBusinessPm = new NodeBusinessPm();
            nodeBusinessPm.setMatchType("and".equals(field.getConnect()) ? MatchTypeEnum.AND : MatchTypeEnum.OR);
            Long id = LrEngineUtil.nextId();
            nodeBusinessPm.setParameterId(id);
            nodeBusinessPm.setParameterType(ParameterType.where);
            nodeBusinessPm.setParentId(pId);
            whereList.add(nodeBusinessPm);
            HeEnginePushUtil.getWhere(heBackCtx, tableNameFiledName2ColumnName, whereList, columnMap, field.getChildren(), id);
        }
    }

    public static void pushTableQuery(HeBackCtx heBackCtx, HeDataModelOperation operation, HeDataModelBase dataModelBase, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = HeEnginePushUtil.getTableQueryDto(heBackCtx, operation, dataModelBase, engineCtx, dataModelBaseDTO, isMs);
        HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    public static void pushTotalCalculate(HeBackCtx heBackCtx, HeDataModelOperation operation, HeDataModelBase dataModelBase, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = HeEnginePushUtil.getTotalCalculate(heBackCtx, operation, dataModelBase, engineCtx, dataModelBaseDTO, isMs);
        HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    public static SingleTableDto getTableQueryDto(HeBackCtx heBackCtx, HeDataModelOperation operation, HeDataModelBase dataModelBase, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, boolean isMs) {
        String selectConditionStr = Optional.ofNullable(operation.getParams()).map(o -> o.get("selectCondition")).orElse(null);
        HeQueryCondition selectCondition = HussarUtils.isNotBlank((CharSequence)selectConditionStr) ? (HeQueryCondition)Optional.ofNullable(dataModelBase.getQuConBaseByName(selectConditionStr)).orElse(null) : null;
        String sortConditionStr = Optional.ofNullable(operation.getParams()).map(o -> o.get("sortCondition")).orElse(null);
        HeSortCondition sortCondition = HussarUtils.isNotBlank((CharSequence)sortConditionStr) ? (HeSortCondition)Optional.ofNullable(dataModelBase.getSortConBaseByName(sortConditionStr)).orElse(null) : null;
        boolean pagination = Optional.ofNullable((Boolean)operation.getParams().get("isPagination")).orElse(false);
        EngineMethodEnum engineMethod = isMs ? (pagination ? EngineMethodEnum.MS_TABLE_SELECT_PAGE : EngineMethodEnum.MS_TABLE_SELECT_LIST) : (pagination ? EngineMethodEnum.SINGLE_TABLE_SELECT_PAGE : EngineMethodEnum.SINGLE_TABLE_SELECT_LIST);
        SingleTableDto dto = HeEnginePushUtil.getPushDto(dataModelBaseDTO.getFields(), engineCtx, HeEnginePushUtil.getUrl("POST", operation.getName(), dataModelBaseDTO), engineMethod.value.getName(), engineMethod.value.getDesc(), 6);
        dto.setPagination(pagination);
        dto.setResultTypeList(true);
        Map columnMap = engineCtx.getColumnMap();
        dto.setWhere(new ArrayList());
        if (Optional.ofNullable(selectCondition).map(HeQueryCondition::getFields).isPresent()) {
            Map<String, String> tableNameFiledName2ColumnName = dataModelBaseDTO.getFields().stream().collect(Collectors.toMap(x -> x.getTableName() + "." + x.getPropertyName(), HeDataModelFieldDto::getName));
            HeEnginePushUtil.getWhere(heBackCtx, tableNameFiledName2ColumnName, dto.getWhereList(), columnMap, selectCondition.getFields(), null);
        }
        if (Optional.ofNullable(sortCondition).map(HeSortCondition::getFields).isPresent()) {
            for (HeSortConditionField sortField : sortCondition.getFields()) {
                MetadataColumn column = HeEnginePushUtil.getMetadataColumn(columnMap, sortField.getFromModelFieldSort());
                if (column == null) continue;
                dto.addSort(column.getColumnId(), sortField.getSortCondition().equals("asc") ? OrderByType.ASC : OrderByType.DESC);
            }
        }
        return dto;
    }

    private static SingleTableDto getTotalCalculate(HeBackCtx heBackCtx, HeDataModelOperation operation, HeDataModelBase dataModelBase, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, boolean isMs) {
        String selectConditionStr = Optional.ofNullable(operation.getParams()).map(o -> o.get("selectCondition")).orElse(null);
        HeQueryCondition selectCondition = HussarUtils.isNotBlank((CharSequence)selectConditionStr) ? (HeQueryCondition)Optional.ofNullable(dataModelBase.getQuConBaseByName(selectConditionStr)).orElse(null) : null;
        EngineMethodEnum engineMethod = isMs ? EngineMethodEnum.MS_TABLE_SELECT_OBJ : EngineMethodEnum.SINGLE_TABLE_SELECT_OBJ;
        SingleTableDto dto = HeEnginePushUtil.getPushDto(dataModelBaseDTO.getFields(), engineCtx, HeEnginePushUtil.getUrl("POST", operation.getName(), dataModelBaseDTO), engineMethod.value.getName(), engineMethod.value.getDesc(), 6);
        Map columnMap = engineCtx.getColumnMap();
        dto.setWhere(new ArrayList());
        if (Optional.ofNullable(selectCondition).map(HeQueryCondition::getFields).isPresent()) {
            Map<String, String> tableNameFiledName2ColumnName = dataModelBaseDTO.getFields().stream().collect(Collectors.toMap(x -> x.getTableName() + "." + x.getPropertyName(), HeDataModelFieldDto::getName));
            HeEnginePushUtil.getWhere(heBackCtx, tableNameFiledName2ColumnName, dto.getWhereList(), columnMap, selectCondition.getFields(), null);
        }
        return dto;
    }

    public static void pushFormSave(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        EngineMethodEnum engineMethod = engineCtx.isMs ? EngineMethodEnum.MS_TABLE_SAVE_OR_UPDATE : EngineMethodEnum.SINGLE_TABLE_SAVE_OR_UPDATE;
        HeEnginePushUtil.pushFormSave(name, engineCtx, dataModelBaseDTO, engineMethod.value.getName(), engineMethod.value.getDesc(), null);
    }

    public static void pushFormSave(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushPostMethod(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, 2);
    }

    public static void pushDeleteIds(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        EngineMethodEnum engineMethod = engineCtx.isMs ? EngineMethodEnum.MS_TABLE_REMOVE : EngineMethodEnum.SINGLE_TABLE_REMOVE;
        HeEnginePushUtil.pushDeleteIds(name, engineCtx, dataModelBaseDTO, engineMethod.value.getName(), engineMethod.value.getDesc(), null);
    }

    public static void pushDeleteIds(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushPostMethod(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, 4);
    }

    private static void pushPostMethod(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns, int type) {
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = HeEnginePushUtil.getPushDto(dataModelBaseDTO.getFields(), engineCtx, HeEnginePushUtil.getUrl("POST", name, dataModelBaseDTO), methodName, methodDesc, type);
        if (flowColumns == null) {
            HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
        } else {
            HeEnginePushUtil.push(engineCtx, flowColumns, dto, !isMs ? 3 : 4);
        }
    }

    public static void pushDeleteId(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushPostMethod(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, 3);
    }

    public static void pushFlagDeleteIds(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        EngineMethodEnum engineMethod = engineCtx.isMs ? EngineMethodEnum.MS_TABLE_FLAG_REMOVE : EngineMethodEnum.SINGLE_TABLE_FLAG_REMOVE;
        HeEnginePushUtil.pushFlagDeleteIds(name, engineCtx, dataModelBaseDTO, engineMethod.value.getName(), engineMethod.value.getDesc(), null);
    }

    public static void pushFlagDeleteIds(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushFlagDel(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, "ids", OperatorType.IN);
    }

    public static void pushFlagDeleteId(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushFlagDel(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, "id", OperatorType.EQ);
    }

    private static void pushFlagDel(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns, String id, OperatorType eq) {
        boolean isMs = engineCtx.isMs;
        HeDataModelFieldDto keyField = null;
        HeDataModelFieldDto flgField = null;
        for (HeDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.isKeyFlag()) {
                keyField = field;
            }
            if (!field.isDelFlag()) continue;
            flgField = field;
        }
        HussarException.throwByNull(keyField, (String)"\u4e3b\u952e\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<HeDataModelFieldDto> fieldDtoList = new ArrayList<HeDataModelFieldDto>();
        fieldDtoList.add(keyField);
        if (HussarUtils.isNotEmpty((Object)flgField)) {
            fieldDtoList.add(flgField);
        }
        SingleTableDto dto = HeEnginePushUtil.getPushDto(fieldDtoList, engineCtx, HeEnginePushUtil.getUrl("POST", name, dataModelBaseDTO), methodName, methodDesc, 2);
        dto.getPmList().remove(0);
        NodeBusinessPm where = (NodeBusinessPm)dto.getWhereList().get(0);
        where.setParameterAlias(id);
        where.setOperatorType(eq);
        if (flowColumns == null) {
            HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
        } else {
            HeEnginePushUtil.push(engineCtx, flowColumns, dto, !isMs ? 3 : 4);
        }
    }

    public static void pushDataDisplay(HeBackCtx heBackCtx, HeDataModelOperation operation, HeDataModelBase dataModelBase, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        MetadataColumn column;
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = HeEnginePushUtil.getTableQueryDto(heBackCtx, operation, dataModelBase, engineCtx, dataModelBaseDTO, isMs);
        dto.setMethodDesc(!isMs ? "\u5355\u8868\u6570\u636e\u5c55\u793a" : "\u4e3b\u5b50\u6a21\u578b\u6570\u636e\u5c55\u793a");
        String relateField = (String)operation.getParams().get("relateField");
        for (HeDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (!field.getPropertyName().equals(relateField)) continue;
            relateField = field.getName();
            break;
        }
        if ((column = HeEnginePushUtil.getMetadataColumn(engineCtx.getColumnMap(), relateField)) != null) {
            NodeBusinessPm nodeBusinessPm = HeEnginePushUtil.getNodeBusinessPm("inValues", column);
            nodeBusinessPm.setMatchType(MatchTypeEnum.AND);
            nodeBusinessPm.setOperatorType(OperatorType.IN);
            nodeBusinessPm.setParameterType(ParameterType.where);
            dto.getWhereList().add(nodeBusinessPm);
        }
        HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    public static void pushFlowNoBusiness(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelDto, String methodName, String methodDesc, List<String> flowColumns) {
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = HeEnginePushUtil.getSingleTableDto(engineCtx, HeEnginePushUtil.getUrl("POST", name, dataModelDto), methodName, methodDesc);
        HeEnginePushUtil.push(engineCtx, flowColumns, dto, !isMs ? 3 : 4);
    }

    private static String getUrl(String getOrPost, String name, HeDataModelBaseDTO dataModelBaseDTO) {
        return String.format("%s %s", getOrPost, FileUtil.posixPath((String[])new String[]{dataModelBaseDTO.getTablePath(), name}));
    }

    public static void pushApi(PushBackCtx ctx) {
        configService.pushApi(ctx);
    }

    public static PushBackCtx getEngineCtx(HeDataModelBase dataModelBase) {
        Map<Object, Object> columnMap;
        String modelName = dataModelBase.getName();
        boolean isMs = false;
        ArrayList<String> tableName = new ArrayList<String>();
        String functionType = dataModelBase.getFunctionType();
        if ("FLOW".equals(functionType) && "MASTER_SLAVE".equals(((HeFlowDataModel)dataModelBase).getBusinessTable().getFunctionType())) {
            functionType = "FLOW_MASTER_SLAVE";
        }
        PushBackCtx ctx = new PushBackCtx();
        switch (functionType) {
            case "FLOW": 
            case "BASE": 
            case "VIEW": 
            case "AGGREGATE": {
                tableName.add(dataModelBase.getSourceDataModelName());
                ctx.setTableInfo(HeEnginePushUtil.getTableById(dataModelBase.getId()));
                break;
            }
            case "FLOW_MASTER_SLAVE": {
                HeMSDataModel businessTable = (HeMSDataModel)((HeFlowMSDataModel)dataModelBase).getBusinessTable();
                ctx.setRelationship(HeEnginePushUtil.getRelationById(businessTable.getMasterTable().getId()));
                tableName.add(businessTable.getMasterTable().getSourceDataModelName());
                for (HeDataModelBase table : businessTable.getSlaveTables()) {
                    tableName.add(table.getSourceDataModelName());
                }
                isMs = true;
                break;
            }
            case "MASTER_SLAVE": {
                ctx.setRelationship(HeEnginePushUtil.getRelationById(((HeMSDataModel)dataModelBase).getMasterTable().getId()));
                tableName.add(((HeMSDataModel)dataModelBase).getMasterTable().getSourceDataModelName());
                for (HeDataModelBase table : ((HeMSDataModel)dataModelBase).getSlaveTables()) {
                    tableName.add(table.getSourceDataModelName());
                }
                isMs = true;
                break;
            }
            default: {
                return ctx;
            }
        }
        ctx.setModelName(modelName);
        ctx.build();
        if (!isMs) {
            ModelTableMappingDTO tableInfo = HeEnginePushUtil.getTableById(dataModelBase.getId());
            ctx.setTableInfo(tableInfo);
            columnMap = tableInfo.getColumns().stream().collect(Collectors.toMap(MetadataColumn::getColumnName, Function.identity()));
            ctx.setColumnMap(columnMap);
        } else {
            ModelTableMappingDTO relationship = null;
            if (dataModelBase instanceof HeMSDataModel) {
                relationship = HeEnginePushUtil.getRelationById(((HeMSDataModel)dataModelBase).getMasterTable().getId());
            } else if (dataModelBase instanceof HeFlowMSDataModel) {
                HeDataModelBase flowMSTable = ((HeFlowMSDataModel)dataModelBase).getBusinessTable();
                relationship = HeEnginePushUtil.getRelationById(((HeMSDataModel)flowMSTable).getMasterTable().getId());
            }
            ctx.setRelationship(relationship);
            columnMap = new HashMap();
            for (String name : tableName) {
                TableInfoDto tableInfo = HeEnginePushUtil.getTableByName(name);
                if (!HussarUtils.isNotEmpty((Object)tableInfo)) continue;
                for (MetadataColumn column : tableInfo.getColumnList()) {
                    columnMap.putIfAbsent(column.getColumnName(), column);
                    columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
                }
            }
            ctx.setColumnMap(columnMap);
        }
        return ctx;
    }

    private static TableInfoDto getTableByName(String tableName) {
        return HeExternalApiUtil.getTableByName(tableName, true);
    }

    private static ModelTableMappingDTO getTableById(String id) {
        return modelRelateService.getModelTableMapping(id);
    }

    private static ModelTableMappingDTO getRelationById(String id) {
        return modelRelateService.getModelTableMapping(id);
    }
}

