/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.util;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.TypeConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.dto.ModelSyncDto;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HEOperationUtil {
    private static final Logger logger = LoggerFactory.getLogger(HEOperationUtil.class);

    private HEOperationUtil() {
    }

    public static MetadataColumn getEngineTableColumnByName(List<MetadataColumn> tableColumnList, String realTableColumnName) {
        MetadataColumn metadataDetailDto = tableColumnList.stream().filter(column -> column.getColumnName().equalsIgnoreCase(realTableColumnName)).findAny().orElse(null);
        if (HussarUtils.isEmpty((Object)metadataDetailDto)) {
            logger.error("\u901a\u8fc7\u5217\u540d\u83b7\u53d6\u89e3\u6790\u5f15\u64ce\u5217\u4fe1\u606f\u5f02\u5e38\uff0c\u5217\u540d\uff1a{}", (Object)realTableColumnName);
        }
        return metadataDetailDto;
    }

    public static String getRealTableColumnName(HeDataModelBase currentDataModel, String propertyName) {
        if (ToolUtil.isNotEmpty((Object)currentDataModel)) {
            HeDataModelField dataModelField = currentDataModel.getFields().stream().filter(dataModelFieldDto -> dataModelFieldDto.getName().equals(propertyName)).findAny().orElse(null);
            if (HussarUtils.isEmpty((Object)((Object)dataModelField))) {
                logger.error("\u901a\u8fc7\u5c5e\u6027\u83b7\u53d6\u5217\u5f02\u5e38\u5f02\u5e38\uff0c\u5c5e\u6027\u540d\uff1a{}", (Object)propertyName);
                return "";
            }
            return dataModelField.getSourceFieldName();
        }
        logger.error("\u83b7\u53d6\u6a21\u578b\u5931\u8d25");
        return "";
    }

    public static String getPropertyColumnName(HeDataModelBase currentDataMode, String realTableName) {
        if (ToolUtil.isNotEmpty((Object)currentDataMode)) {
            return currentDataMode.getFields().stream().filter(dataModelFieldDto -> dataModelFieldDto.getSourceFieldName().equals(realTableName)).findAny().orElseGet(HeDataModelField::new).getName();
        }
        logger.error("\u83b7\u53d6\u6a21\u578b\u4fe1\u606f\u5931\u8d25");
        return "";
    }

    public static String getOneToOnePropertyColumnName(HeDataModelBase dataModelBase, String realTableName, String dateModelId) {
        if (ToolUtil.isNotEmpty((Object)dataModelBase)) {
            return dataModelBase.getFields().stream().filter(dataModelFieldDto -> realTableName.equals(dataModelFieldDto.getSourceFieldName()) && dateModelId.equals(dataModelFieldDto.getSourceDataModelId())).findAny().orElseGet(HeDataModelField::new).getName();
        }
        logger.error("\u83b7\u53d6\u6a21\u578b\u4fe1\u606f\u5931\u8d25");
        return "";
    }

    public static void publishToEngine(PushBackCtx pushBackCtx, SingleTableDto singleTableDto) {
        EngineBussnessdataConfigService configService = (EngineBussnessdataConfigService)SpringUtil.getBean(EngineBussnessdataConfigService.class);
        configService.saveSingleTableService(singleTableDto, pushBackCtx);
        configService.pushApi(pushBackCtx);
    }

    public static ModelPublishDTO ModelToEngine(HeDataModelBase dataModelBase) {
        TableInfoDto tableInfo = HeExternalApiUtil.getTableByName(dataModelBase.getSourceDataModelName(), false);
        ModelPublishDTO mpdto = new ModelPublishDTO();
        mpdto.setRelatedId(Long.valueOf(LrEngineUtil.nextId()));
        mpdto.setTfmodelId(dataModelBase.getId());
        mpdto.setTfmodelName(dataModelBase.getName());
        mpdto.setParamName(dataModelBase.getName());
        mpdto.setTableId(tableInfo.getTableId());
        mpdto.setParentPath("0");
        ArrayList modelColumnsList = new ArrayList();
        List metaColumnList = tableInfo.getColumnList();
        Map<String, Long> columnName2Id = metaColumnList.stream().collect(Collectors.toMap(MetadataColumn::getColumnName, MetadataColumn::getColumnId));
        List<HeDataModelField> fields = dataModelBase.getFields();
        fields.forEach(field -> {
            ModelColumns modelColumns = new ModelColumns();
            modelColumnsList.add(modelColumns);
            modelColumns.setColumnId((Long)columnName2Id.get(field.getSourceFieldName()));
            modelColumns.setColumnName(field.getSourceFieldName());
            modelColumns.setColumnAlias(field.getName());
            modelColumns.setTfmodelColumnId(field.getId());
            modelColumns.setTfmodelId(dataModelBase.getId());
        });
        mpdto.setModelColumns(modelColumnsList);
        return mpdto;
    }

    public static ModelSyncDto conversionFunction(HeDataModelBase dataModel, String path, String type) {
        ModelSyncDto modelSyncDto = new ModelSyncDto();
        modelSyncDto.setModelPath(path);
        modelSyncDto.setTfModelId(dataModel.getId());
        modelSyncDto.setNodeType(TypeConversionEnum.getValueByKey(type));
        modelSyncDto.setTableName(dataModel.getSourceDataModelName());
        modelSyncDto.setParamName(dataModel.getName());
        ArrayList<ModelSyncDto.ModelSyncColumn> columnList = new ArrayList<ModelSyncDto.ModelSyncColumn>();
        List<HeDataModelField> fields = dataModel.getFields();
        for (HeDataModelField field : fields) {
            ModelSyncDto.ModelSyncColumn modelSyncColumn = new ModelSyncDto.ModelSyncColumn();
            modelSyncColumn.setTfColumnId(field.getId());
            modelSyncColumn.setColumnAlias(field.getName());
            columnList.add(modelSyncColumn);
        }
        modelSyncDto.setColumns(columnList);
        return modelSyncDto;
    }

    public static String getRealPath(String path) {
        StringBuffer pathBuffer = new StringBuffer(path);
        pathBuffer.insert(0, '/');
        pathBuffer.append(".dbd");
        int index = pathBuffer.indexOf(".");
        pathBuffer.setCharAt(index, '/');
        return pathBuffer.toString();
    }
}

