/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.common.constant.StrategyType;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.HeModelFunction;
import com.jxdinfo.hussar.formdesign.engine.function.HeOperationVisitor;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.function.visitor.masterslave.util.MSOperationUtil;
import com.jxdinfo.hussar.formdesign.engine.result.HeCodeResult;
import com.jxdinfo.hussar.formdesign.engine.service.HeModelPublishService;
import com.jxdinfo.hussar.formdesign.engine.util.HEModelBeanUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HEDataModelUtil {
    private static Logger logger = LoggerFactory.getLogger(HEDataModelUtil.class);
    private static final HeModelPublishService LR_MODEL_PUBLISH_SERVICE = (HeModelPublishService)SpringUtil.getBean(HeModelPublishService.class);

    private HEDataModelUtil() {
    }

    public static void init(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws LcdpException {
        String modelId = dataModelBase.getId();
        HeModelFunction currentFunction = HEModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        HeDataModelBase currentModelBase = currentFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        HashMap<String, HeDataModelBaseDTO> useDtoMap = new HashMap<String, HeDataModelBaseDTO>();
        useDtoMap.put(modelId, LR_MODEL_PUBLISH_SERVICE.enclosure(currentModelBase));
        backCtx.setUseDataModelBase(currentModelBase);
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx, PublishCtx<HeCodeResult> publishCtx) throws LcdpException, IOException {
        HEDataModelUtil.visit(backCtx);
        LR_MODEL_PUBLISH_SERVICE.mergeBack(LR_MODEL_PUBLISH_SERVICE.renderCode(backCtx), publishCtx);
    }

    public static void visit(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx) throws LcdpException, IOException {
        HeDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        HeDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PushBackCtx engineCtx = HeEnginePushUtil.getEngineCtx(useDataModelBase);
        if (engineCtx.getRelationship() != null) {
            MSOperationUtil.initMasterSlave(backCtx);
        }
        for (HeDataModelOperation operation : useDataModelBase.getOperations()) {
            HeOperationVisitor<HeDataModelBase, HeDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().visitor(StrategyType.analyse(), backCtx.getModelFunctionTye(), ToolUtil.isNotEmpty((Object)operation.getFlowBusiness()) ? "" : operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            backCtx.getModelFunction().accept(visitor, backCtx, operation, engineCtx);
            if (!backCtx.getUseDataModelBase().getIsPublishResource()) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((String)useDataModelBase.getId(), (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
        HeEnginePushUtil.pushApi(engineCtx);
    }

    public static HeDataModelBase transfer(DataModelBase dataModelBase) throws LcdpException {
        HeModelFunction modelFunction = HEModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        return modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)dataModelBase.getId()));
    }

    public static HeDataModelBase transfer(String jsonData) throws LcdpException {
        DataModelBase dataModel = (DataModelBase)JSONObject.parseObject((String)jsonData, DataModelBase.class);
        HeModelFunction modelFunction = HEModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        return modelFunction.parseDataModel(JSONObject.parseObject((String)jsonData));
    }

    public static ContrastVO<HeDataModelField> hcontrastWith(List<TableField> tableFields, List<HeDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<HeDataModelField> addFields = new ArrayList<HeDataModelField>();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        List<Object> delFields = new ArrayList();
        ArrayList<HeDataModelField> modifyFields = new ArrayList<HeDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)modelFields.get(i).getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(modelFields.get(i));
            }
            if (flag) continue;
            addFields.add(modelFields.get(i));
        }
        delFields = HEDataModelUtil.htabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static List<HeDataModelField> htabTransmodel(List<TableField> tableFields) {
        ArrayList<HeDataModelField> modelFields = new ArrayList<HeDataModelField>();
        tableFields.forEach(tab -> {
            HeDataModelField field = new HeDataModelField();
            field.setSourceFieldName(tab.getName());
            field.setId(UUID.randomUUID().toString());
            field.setDataIsEmpty(tab.getDataIsEmpty());
            field.setDataLength(tab.getDataLength());
            field.setDataDot(tab.getDataDot());
            field.setComment(tab.getComment());
            field.setSourceDataType(tab.getType().toUpperCase());
            if ("PRI".equals(tab.getPrimarys())) {
                field.setUsage("primary");
            }
            modelFields.add(field);
        });
        return modelFields;
    }

    public static HeDataModelField tabTransmodelOne(TableField tableFields, String id) {
        HeDataModelField field = new HeDataModelField();
        field.setId(id);
        field.setSourceFieldName(tableFields.getName());
        field.setDataIsEmpty(tableFields.getDataIsEmpty());
        field.setDataLength(tableFields.getDataLength());
        field.setDataDot(tableFields.getDataDot());
        field.setComment(tableFields.getComment());
        if ("PRI".equals(tableFields.getPrimarys())) {
            field.setUsage("primary");
        }
        field.setSourceDataType(tableFields.getType().toUpperCase());
        return field;
    }

    public static ContrastVO<HeDataModelField> contrastWith(List<TableField> tableFields, List<HeDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<HeDataModelField> delFields = new ArrayList<HeDataModelField>();
        ArrayList<HeDataModelField> modifyFields = new ArrayList<HeDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)modelFields.get(i).getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(HEDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<HeDataModelField> addFields = HEDataModelUtil.htabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<HeDataModelField> pushContrastWith(List<TableField> tableFields, List<HeDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<HeDataModelField> delFields = new ArrayList<HeDataModelField>();
        ArrayList<HeDataModelField> modifyFields = new ArrayList<HeDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(HEDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<HeDataModelField> addFields = HEDataModelUtil.htabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<HeDataModelField> contrastWithIgnoreCase(List<TableField> tableFields, List<HeDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<HeDataModelField> delFields = new ArrayList<HeDataModelField>();
        ArrayList<HeDataModelField> modifyFields = new ArrayList<HeDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && HussarUtils.equals((Object)modelFields.get(i).getDataDot(), (Object)tableFields.get(j).getDataDot())) break;
                modifyFields.add(HEDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<HeDataModelField> addFields = HEDataModelUtil.htabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }
}

