/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.service.WorkFlowVisitorService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.element.flow.HeFlowDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.visitor.masterslave.util.MSOperationUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEModelBeanUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.entity.BpmPm;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.service.BpmPmService;
import com.jxdinfo.hussar.workflow.engine.flowmodel.CallActivityTable;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeWorkFlowVisitorServiceImpl
implements WorkFlowVisitorService {
    private static final Logger logger = LoggerFactory.getLogger(HeWorkFlowVisitorServiceImpl.class);

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId) throws LcdpException {
        FlowModel flowModel = this.readWfd(modelName, workFlowName);
        if (flowModel == null) {
            return new ArrayList<Map<String, String>>();
        }
        List flowObjects = flowModel.getSlots().getElement();
        for (FlowObject flowObject : flowObjects) {
            if ("com.jxdinfo.workflow.SubProcess".equals(flowObject.getName())) {
                List subFlowObjects = flowObject.getSlots().getElement();
                for (FlowObject subFlowObject : subFlowObjects) {
                    if (!"com.jxdinfo.workflow.User".equals(subFlowObject.getName())) continue;
                    CallActivityTable callActivityTable = subFlowObject.getProps().getCallActivityTable();
                    String instanceKey = ToolUtil.isEmpty((Object)subFlowObject.getProps().getNodeId()) ? subFlowObject.getInstanceKey() : subFlowObject.getProps().getNodeId();
                    String[] ids = identityKey.split(":");
                    String businessKey = ids[0] + ":" + ids[1] + instanceKey;
                    this.visit(modelId, businessKey, callActivityTable);
                }
            } else if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) continue;
            CallActivityTable callActivityTable = flowObject.getProps().getCallActivityTable();
            String instanceKey = ToolUtil.isEmpty((Object)flowObject.getProps().getNodeId()) ? flowObject.getInstanceKey() : flowObject.getProps().getNodeId();
            String[] ids = identityKey.split(":");
            String businessKey = ids[0] + ":" + ids[1] + instanceKey;
            this.visit(modelId, businessKey, callActivityTable);
        }
        return new ArrayList<Map<String, String>>();
    }

    private FlowModel readWfd(String moduleName, String workflowName) {
        if (((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).getScenes().isSharedStorage()) {
            return this.readRemoteWfd(moduleName, workflowName);
        }
        return this.readLocalWfd(moduleName, workflowName);
    }

    private FlowModel readLocalWfd(String moduleName, String workflowName) {
        String path = ((ResourcePathService)SpringContextUtil.getBean(ResourcePathService.class)).projectStoreCode(new String[]{moduleName, workflowName}).getLocalPath();
        File bpmFile = new File(path);
        try {
            String xml = FileUtils.readFileToString((File)bpmFile, (Charset)StandardCharsets.UTF_8);
            return (FlowModel)JSON.parseObject((String)String.valueOf(xml), FlowModel.class);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u672c\u5730\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private FlowModel readRemoteWfd(String moduleName, String workflowName) {
        String path = ((ResourcePathService)SpringContextUtil.getBean(ResourcePathService.class)).projectStoreCode(new String[]{moduleName, workflowName}).getRemotePath();
        StorageResult result = ((StorageService)SpringContextUtil.getBean(StorageService.class)).downloadByPath(path);
        if (result.isSuccess()) {
            String json = new String((byte[])result.getData(), StandardCharsets.UTF_8);
            return (FlowModel)JSON.parseObject((String)json, FlowModel.class);
        }
        return null;
    }

    public void visit(String modelId, String businessKey, CallActivityTable callActivityTable) throws LcdpException {
        JSONObject json = DataModelUtil.getDataModelJson((String)modelId);
        String functionType = String.valueOf(json.get((Object)"functionType"));
        HeDataModelBase dataModelBase = HEModelBeanUtil.getFunctionModelVisitorBean(functionType).parseDataModel(json);
        if (dataModelBase instanceof HeFlowDataModel) {
            dataModelBase = ((HeFlowDataModel)dataModelBase).getBusinessTable();
        }
        HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx = new HeBackCtx<HeDataModelBase, HeDataModelBaseDTO>();
        backCtx.setStrategy("HUSSAR_ENGINE");
        HEDataModelUtil.init(backCtx, dataModelBase);
        if ("MASTER_SLAVE".equals(dataModelBase.getFunctionType())) {
            MSOperationUtil.initMasterSlave(backCtx);
        }
        PushBackCtx engineCtx = HeEnginePushUtil.getEngineCtx(dataModelBase);
        HeEnginePushUtil.pushFlowVisitSelect(businessKey, engineCtx, backCtx.getUseDataModelDtoMap().get(dataModelBase.getId()));
        HeEnginePushUtil.pushApi(engineCtx);
        if (Optional.ofNullable(callActivityTable).map(CallActivityTable::getTableId).isPresent()) {
            for (HeDataModelBase modelBaseEntry : backCtx.getDataModelBaseMap().values()) {
                if (!modelBaseEntry.getName().equals(callActivityTable.getTableId())) continue;
                TableInfoDto tableByName = HeExternalApiUtil.getTableByName(modelBaseEntry.getSourceDataModelName(), true);
                this.saveBpmPm(engineCtx.getFirstNodeBusinessDto(), tableByName);
                return;
            }
        }
    }

    private void saveBpmPm(NodeBusiness firstNodeBusinessDto, TableInfoDto tableByName) {
        BpmPm bpmPm = new BpmPm();
        bpmPm.setNodeId(firstNodeBusinessDto.getNodeId());
        bpmPm.setNodeName(firstNodeBusinessDto.getNodeName());
        bpmPm.setBpmPmKey("slaveTableId");
        bpmPm.setBpmPmValue(HussarUtils.toStr((Object)tableByName.getTableId()));
        BpmPmService pmService = (BpmPmService)SpringContextUtil.getBean(BpmPmService.class);
        pmService.saveBpmPm(bpmPm);
    }
}

