/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.result.HeCodeResult;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import java.io.IOException;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="LR_ENGINE_RESULT")
public class HeCodeMergeServiceImpl
implements CodeMergeService {
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private VersionManageService versionManageService;

    public void writeMergeCode(CodeResult result) throws IOException {
        if (result instanceof HeCodeResult) {
            HeCodeResult codeResult = (HeCodeResult)result;
            String dataId = codeResult.getDataId();
            String lastPublish = ToolUtil.textFomatterByOS((String)codeResult.getLastPublish());
            String newContent = codeResult.getNewCode();
            String filePath = codeResult.getFilePath();
            this.filePublishService.writeStringToFile(lastPublish, filePath);
            this.versionManageService.saveLastPublishCode(dataId, newContent);
            this.versionManageService.saveLastFileCode(dataId, lastPublish);
        }
    }

    public CodeResult parseData(String jsonData) {
        return (CodeResult)JSON.parseObject((String)jsonData, HeCodeResult.class);
    }
}

