/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.processor.provider;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.function.HeModelFunction;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.service.impl.HeWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HeModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(HeModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"HUSSAR_ENGINE", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            String tenantCodePrefix = Optional.ofNullable(AppContextUtil.getAppInfo()).map(e -> "/" + e.getTenantId()).orElse("");
            return FileUtil.posixPath((String[])new String[]{tenantCodePrefix, apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        HeModelFunction modelFunction = HEModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        HeDataModelBase hEDataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return hEDataModelBase.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElseGet(HeDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        HeModelFunction modelFunction = HEModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        HeDataModelBase hEDataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(hEDataModelBase.getOperations())) {
            for (HeDataModelOperation operation : hEDataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId) throws LcdpException, IOException {
        return new HeWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
        Optional<DataModelBase> data = Optional.ofNullable(DataModelUtil.getDataModelBase((String)modelId));
        if (data.isPresent()) {
            HeDataModelBase transfer = HEDataModelUtil.transfer(data.get());
            transfer.sync();
        }
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        HeModelFunction modelFunction = HEModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        HeDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return new ArrayList<DataModelFieldBase>(dataModelBase.getFields());
    }

    public void delete(String modelId) throws LcdpException {
        Optional<DataModelBase> data = Optional.ofNullable(DataModelUtil.getDataModelBase((String)modelId));
        if (data.isPresent()) {
            HeDataModelBase transfer = HEDataModelUtil.transfer(data.get());
            transfer.delete(modelId);
        }
    }
}

