/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.element.masterslave;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.HeMSDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.support.engine.api.enums.JoinTypeEnum;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipDto;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipJoinDto;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class HeMasterSlaveConnector {
    private HeMasterSlaveConnector() {
    }

    static void dealMasterSlaveModel(RelationshipDto relationshipDto, HeMSDataModel dataModel) {
        HeDataModelBase masterTable = dataModel.getMasterTable();
        TableInfoDto masterTableInfo = HeMasterSlaveConnector.getTableInfoDto(masterTable);
        HashMap<String, Long> tableIdMap = new HashMap<String, Long>();
        HashMap<String, Long> columnIdMap = new HashMap<String, Long>();
        HeMasterSlaveConnector.initSlaveTable(tableIdMap, columnIdMap, masterTable, masterTableInfo, dataModel.getSlaveTables());
        HeMasterSlaveConnector.initRelationShip(relationshipDto, dataModel, masterTable, masterTableInfo);
        ArrayList<RelationshipJoinDto> joinDtoList = new ArrayList<RelationshipJoinDto>();
        HeMasterSlaveConnector.initJoin(joinDtoList, masterTableInfo, dataModel.getRelationships(), tableIdMap, columnIdMap);
        relationshipDto.setJoinDtoList(joinDtoList);
    }

    private static TableInfoDto getTableInfoDto(HeDataModelBase table) {
        String tableName = table.getSourceDataModelName();
        TableInfoDto tableInfo = HeExternalApiUtil.getTableByName(tableName, true);
        HussarException.throwByNull((Object)tableInfo, (String)String.format("\u8868:%s\u672a\u627e\u5230\u5143\u6570\u636e", tableName));
        return tableInfo;
    }

    private static void initSlaveTable(Map<String, Long> tableIdMap, Map<String, Long> columnIdMap, HeDataModelBase masterTable, TableInfoDto masterTableInfo, List<HeDataModelBase> slaveTables) {
        tableIdMap.put(masterTable.getId(), masterTableInfo.getTableId());
        HeMasterSlaveConnector.getColumnIdByName(columnIdMap, masterTable.getFields(), masterTableInfo.getColumnList());
        for (HeDataModelBase slaveTable : slaveTables) {
            TableInfoDto slaveTableInfo = HeMasterSlaveConnector.getTableInfoDto(slaveTable);
            tableIdMap.put(slaveTable.getId(), slaveTableInfo.getTableId());
            HeMasterSlaveConnector.getColumnIdByName(columnIdMap, slaveTable.getFields(), slaveTableInfo.getColumnList());
        }
    }

    private static void getColumnIdByName(Map<String, Long> idMap, List<HeDataModelField> fields, List<MetadataColumn> columnList) {
        Map<String, Long> map = columnList.stream().collect(Collectors.toMap(MetadataColumn::getColumnName, MetadataColumn::getColumnId));
        for (HeDataModelField field : fields) {
            Long id = map.get(field.getSourceFieldName());
            HussarException.throwByNull((Object)id, (String)String.format("\u5143\u6570\u636e\u672a\u627e\u5230\u5217:%s", field.getSourceFieldName()));
            idMap.put(field.getId(), id);
        }
    }

    private static void initJoin(List<RelationshipJoinDto> joinDtoList, TableInfoDto masterTableInfo, List<HeRelationshipBase> relationships, Map<String, Long> tableIdMap, Map<String, Long> columnIdMap) {
        for (HeRelationshipBase relationship : relationships) {
            boolean association = "collection".equals(relationship.getRelateModelType());
            RelationshipJoinDto joinDto = new RelationshipJoinDto();
            joinDto.setLeftTableId(masterTableInfo.getTableId());
            joinDto.setJoinType(JoinTypeEnum.LEFT_JOIN);
            joinDto.setRightTableId(tableIdMap.get(relationship.getSlaveTableId()));
            if (association) {
                joinDto.setParamName(relationship.getSlaveTableName());
            }
            ArrayList<RelationshipOnDto> onDtoList = new ArrayList<RelationshipOnDto>();
            for (HeRelationshipFieldBase relationshipFieldBase : relationship.getRelationships()) {
                RelationshipOnDto onDto = new RelationshipOnDto();
                onDto.setLeftColumnId(columnIdMap.get(relationshipFieldBase.getMasterTableFieldId()));
                onDto.setRightColumnId(columnIdMap.get(relationshipFieldBase.getSlaveTableFieldId()));
                onDto.setOperatorType(HeExternalApiUtil.getOperatorType(relationshipFieldBase.getSymbol()));
                onDtoList.add(onDto);
                joinDto.setOnDtoList(onDtoList);
            }
            joinDtoList.add(joinDto);
        }
    }

    private static void initRelationShip(RelationshipDto relationshipDto, HeMSDataModel dataModel, HeDataModelBase masterTable, TableInfoDto masterTableInfo) {
        relationshipDto.setModelName(dataModel.getName());
        relationshipDto.setModelDec(dataModel.getTableDesc());
        relationshipDto.setMasterTableId(masterTableInfo.getTableId());
    }
}

