/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.element.flow;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.FormDesignEngineExceptionEnum;
import com.jxdinfo.hussar.formdesign.engine.function.element.flow.HeFlowDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.HeMSDataModel;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HeFlowMSDataModel
extends HeFlowDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(HeFlowMSDataModel.class);
    public static final String FUNCTION_TYPE = "FLOW_MASTER_SLAVE";

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HE.FLOW_MASTER_SLAVE", HeFlowMSDataModel.class);
    }

    @Override
    public HeFlowMSDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HeFlowMSDataModel dataModel;
        try {
            dataModel = (HeFlowMSDataModel)JSONObject.parseObject((String)jsonObject.toString(), HeFlowMSDataModel.class);
            jsonObject.put("functionType", (Object)"MASTER_SLAVE");
            HeMSDataModel businessModel = new HeMSDataModel().parseDataModel(jsonObject);
            dataModel.setFields(businessModel.getFields());
            businessModel.setModelPath(dataModel.getModelPath());
            dataModel.setBusinessTable(businessModel);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, FormDesignEngineExceptionEnum.PARSING_OBJECT_FAILED.getMessage());
        }
        return dataModel;
    }

    @Override
    public String getFunctionType() {
        return "FLOW";
    }

    public String getRealFunctionType() {
        return FUNCTION_TYPE;
    }

    @Override
    public void syncModel(String functionType) throws IOException, LcdpException {
        functionType = FUNCTION_TYPE;
        super.syncModel(functionType);
    }

    @Override
    public void delete(String modelId) throws LcdpException {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        JSONObject modelJson = DataModelUtil.getDataModelJson((String)modelId);
        HeFlowMSDataModel heFlowMSDataModel = this.parseDataModel(modelJson);
        modelId = ((HeMSDataModel)heFlowMSDataModel.getBusinessTable()).getMasterTable().getId();
        super.delete(modelId);
    }
}

