/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.element.flow;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.FormDesignEngineExceptionEnum;
import com.jxdinfo.hussar.formdesign.engine.function.element.base.HeBaseDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortCondition;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HeFlowDataModel
extends HeDataModelBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeFlowDataModel.class);
    public static final String FUNCTION_TYPE = "FLOW";
    public static final String FUNCTION_TYPE_KEY = "functionType";
    private HeDataModelBase businessTable;
    private List<HeQueryCondition> queryConditions;
    private List<HeSortCondition> sortCondition;
    private String sourceDataModelName;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HE.FLOW", HeFlowDataModel.class);
    }

    public HeDataModelBase getBusinessTable() {
        return this.businessTable;
    }

    public void setBusinessTable(HeDataModelBase businessTable) {
        this.businessTable = businessTable;
    }

    @Override
    public HeFlowDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HeFlowDataModel dataModel;
        try {
            dataModel = (HeFlowDataModel)JSONObject.parseObject((String)jsonObject.toString(), HeFlowDataModel.class);
            jsonObject.put(FUNCTION_TYPE_KEY, (Object)"BASE");
            HeBaseDataModel businessModel = new HeBaseDataModel().parseDataModel(jsonObject);
            businessModel.setModelPath(dataModel.getModelPath());
            dataModel.setBusinessTable(businessModel);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, FormDesignEngineExceptionEnum.PARSING_OBJECT_FAILED.getMessage());
        }
        return dataModel;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    @Override
    public HeQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (HeQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public HeSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (HeSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new HeSortCondition();
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<HeQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<HeQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<HeSortCondition> getSortCondition() {
        return this.sortCondition;
    }

    public void setSortCondition(List<HeSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public List<ContrastVO<HeDataModelField>> tableContrastModel(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        return this.businessTable.tableContrastModel(fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<HeDataModelField>> modelContrastTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        return this.businessTable.modelContrastTable(fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<HeDataModelField>> findTableContrast() throws IOException, LcdpException {
        return this.businessTable.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        return this.businessTable.checkTableContrast(modelId);
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        this.businessTable.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public void sync() throws IOException, LcdpException {
        this.metaDataSync();
        this.syncModel(this.getFunctionType());
    }

    @Override
    public void syncModel(String functionType) throws IOException, LcdpException {
        this.businessTable.syncModel(functionType);
    }

    @Override
    public void metaDataSync() throws IOException, LcdpException {
        this.businessTable.metaDataSync();
    }

    @Override
    public void delete(String modelId) throws LcdpException {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        modelRelateService.delete(modelId);
    }

    @Override
    public String copyTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        return this.businessTable.copyTable(fieldsContrastParam);
    }
}

