/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.element.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.CheckTable;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.TypeConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.function.element.base.HeBaseConnector;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeEditDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryObject;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortCondition;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEOperationUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HeBaseDataModel
extends HeDataModelBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeBaseDataModel.class);
    public static final String FUNCTION_TYPE = "BASE";
    private String sourceDataModelName;
    private List<HeQueryCondition> queryConditions;
    private List<HeQueryObject> queryObject;
    private List<HeSortCondition> sortCondition;
    private List<HeDataModelField> addFields;
    private List<HeDataModelField> delFields;
    private List<HeEditDataModelField> editFields;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HE.BASE", HeBaseDataModel.class);
    }

    @Override
    public HeBaseDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HeBaseDataModel dataModel;
        try {
            dataModel = (HeBaseDataModel)JSONObject.parseObject((String)jsonObject.toString(), HeBaseDataModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return dataModel;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<HeQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<HeQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<HeQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<HeQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    public List<HeSortCondition> getSortCondition() {
        return this.sortCondition;
    }

    public void setSortCondition(List<HeSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    public List<HeDataModelField> getAddFields() {
        return this.addFields;
    }

    public void setAddFields(List<HeDataModelField> addFields) {
        this.addFields = addFields;
    }

    public List<HeDataModelField> getDelFields() {
        return this.delFields;
    }

    public void setDelFields(List<HeDataModelField> delFields) {
        this.delFields = delFields;
    }

    public List<HeEditDataModelField> getEditFields() {
        return this.editFields;
    }

    public void setEditFields(List<HeEditDataModelField> editFields) {
        this.editFields = editFields;
    }

    @Override
    public HeQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (HeQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public HeSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (HeSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        if (HussarUtils.isEmpty((Object)this.getDataSourceName())) {
            return false;
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasource = sysDataSourceService.getByConnName(this.getDataSourceName());
        TableCorrespond info = new TableCorrespond();
        boolean findTable = false;
        if (HussarUtils.isNotEmpty((Object)fieldsContrastParam.getTableCorresponds())) {
            for (TableCorrespond tableCorrespond : fieldsContrastParam.getTableCorresponds()) {
                if (!HussarUtils.equals((Object)this.getId(), (Object)tableCorrespond.getModelId())) continue;
                info = tableCorrespond;
                findTable = true;
                break;
            }
        }
        if (!findTable) {
            return true;
        }
        Optional tableInfo = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)(HussarUtils.isNotEmpty((Object)info.getTableName()) ? info.getTableName() : this.sourceDataModelName.toUpperCase()));
        if (!tableInfo.isPresent()) {
            this.creatTabs(datasource);
        } else {
            this.editTabs(datasource, (TableCorrespond<HeDataModelField>)info, (TableInfo)tableInfo.get());
        }
        return true;
    }

    public void creatTabs(SysDataSource datasource) {
        MetadataParam metadataParam = new MetadataParam();
        TableInfoDto tableInfoDto = HeBaseConnector.tableInfoInCreate(datasource, this);
        metadataParam.setTableInfo(tableInfoDto);
        metadataParam.setColumnInfo(HeBaseConnector.transferColumn(this.getFields(), ""));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.createTable(metadataParam);
    }

    public void editTabs(SysDataSource datasource, TableCorrespond<HeDataModelField> info, TableInfo tableInfo) throws Exception {
        MetadataParam paramData = new MetadataParam();
        TableInfoDto tableInfoDto = HeBaseConnector.tableInfoInEdit(datasource, this);
        paramData.setTableInfo(tableInfoDto);
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        this.delFields = JSONArray.parseArray((String)info.getDelFields(), HeDataModelField.class);
        for (int y = 0; y < this.delFields.size(); ++y) {
            ColumnInfoDto del = new ColumnInfoDto();
            del.setColumnName(this.delFields.get(y).getSourceFieldName());
            deletedCols.add(del);
        }
        paramData.setDeletedCols(deletedCols);
        this.addFields = JSONArray.parseArray((String)info.getAddFields(), HeDataModelField.class);
        this.editFields = JSONArray.parseArray((String)info.getModifyFields(), HeEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(this.addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(this.editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        List<ColumnInfoDto> oldColumn = this.transform(HEDataModelUtil.htabTransmodel(tableInfo.getFields()));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.editTable(paramData, oldColumn, info.getOldTableName());
    }

    public List<ColumnInfoDto> transformDto(List<HeDataModelField> getFields, String state) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (int i = 0; i < getFields.size(); ++i) {
            Optional engineColumnType;
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
            columnInfo.setColumnComment(getFields.get(i).getComment());
            columnInfo.setColumnAlias(getFields.get(i).getName());
            columnInfo.setRequired("0");
            if ("primary".equals(getFields.get(i).getUsage())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
                columnInfo.setPrimarys("1");
            } else {
                columnInfo.setPk("0");
            }
            if (getFields.get(i).getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataType(getFields.get(i).getSourceDataType());
            columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
            columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getDataDot()));
            columnInfo.setDataIsEmpty(Integer.valueOf(getFields.get(i).getDataIsEmpty() ? 1 : 0));
            if (!"all".equals(state)) {
                columnInfo.setOperation(state);
            }
            if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)getFields.get(i).getDataType())).isPresent()) {
                columnInfo.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                columnInfo.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
            }
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transformEdit(List<HeEditDataModelField> getFields, String state) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (int i = 0; i < getFields.size(); ++i) {
            Optional engineColumnType;
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(getFields.get(i).getNewField().getSourceFieldName());
            columnInfo.setColumnAlias(getFields.get(i).getNewField().getName());
            columnInfo.setColumnComment(getFields.get(i).getNewField().getComment());
            columnInfo.setRequired("0");
            if ("primary".equals(getFields.get(i).getNewField().getUsage())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
                columnInfo.setPrimarys("1");
            } else {
                columnInfo.setPk("0");
            }
            columnInfo.setPurpose(getFields.get(i).getNewField().getUsage());
            if (getFields.get(i).getNewField().getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataLength(Long.valueOf(getFields.get(i).getNewField().getDataLength()));
            columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getNewField().getDataDot()));
            columnInfo.setDataType(getFields.get(i).getNewField().getSourceDataType());
            columnInfo.setOldColumnName(getFields.get(i).getOldField().getSourceFieldName());
            columnInfo.setDataIsEmpty(Integer.valueOf(getFields.get(i).getNewField().getDataIsEmpty() ? 1 : 0));
            if (!"all".equals(state)) {
                columnInfo.setOperation(state);
            }
            if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)getFields.get(i).getNewField().getDataType())).isPresent()) {
                columnInfo.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                columnInfo.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
            }
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transform(List<HeDataModelField> getFields) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (int i = 0; i < getFields.size(); ++i) {
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
            columnInfo.setColumnComment(getFields.get(i).getComment());
            columnInfo.setRequired("0");
            if ("primary".equals(getFields.get(i).getUsage())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
            } else {
                columnInfo.setPk("0");
            }
            if (getFields.get(i).getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
            columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getDataDot()));
            columnInfo.setDataType(getFields.get(i).getSourceDataType());
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    public Optional<TableInfo> findTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional infoOptional;
        TableInfo table = null;
        boolean findCurrentTable = false;
        List tableCorresponds = fieldsContrastParam.getTableCorresponds();
        if (tableCorresponds != null) {
            for (TableCorrespond tableCorrespond : tableCorresponds) {
                if (!this.getId().equals(tableCorrespond.getModelId())) continue;
                String changeName = tableCorrespond.getTableName().toUpperCase();
                Optional infoOptional2 = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)changeName);
                findCurrentTable = infoOptional2.isPresent();
                if (!findCurrentTable) break;
                table = (TableInfo)infoOptional2.get();
                break;
            }
        }
        if (!findCurrentTable && (findCurrentTable = (infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase())).isPresent())) {
            table = (TableInfo)infoOptional.get();
        }
        return Optional.ofNullable(table);
    }

    @Override
    public List<ContrastVO<HeDataModelField>> tableContrastModel(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable(fieldsContrastParam);
        ContrastVO<HeDataModelField> contrast = new ContrastVO<HeDataModelField>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = HEDataModelUtil.contrastWith(table.getFields(), this.getFields());
            contrast.setTableFields(HEDataModelUtil.htabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        ArrayList<ContrastVO<HeDataModelField>> contrastVOS = new ArrayList<ContrastVO<HeDataModelField>>();
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<HeDataModelField>> modelContrastTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable(fieldsContrastParam);
        ContrastVO<HeDataModelField> contrast = new ContrastVO<HeDataModelField>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = HEDataModelUtil.hcontrastWith(table.getFields(), this.getFields());
            contrast.setTableFields(HEDataModelUtil.htabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        ArrayList<ContrastVO<HeDataModelField>> contrastVOS = new ArrayList<ContrastVO<HeDataModelField>>();
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<HeDataModelField>> findTableContrast() throws IOException, LcdpException {
        ArrayList<ContrastVO<HeDataModelField>> contrastVOS = new ArrayList<ContrastVO<HeDataModelField>>();
        ContrastVO contrast = new ContrastVO();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        contrast.setModelId(this.getId());
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO contrastVOS = new PublishCheckVO();
        contrastVOS.setModelId(modelId);
        ArrayList<CheckTable> contrast = new ArrayList<CheckTable>();
        CheckTable info = new CheckTable();
        long start = System.currentTimeMillis();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase());
        if (!infoOptional.isPresent()) {
            info.setModelId(modelId);
            info.setState(Integer.valueOf(0));
            contrast.add(info);
            contrastVOS.setDetails(contrast);
            return contrastVOS;
        }
        TableInfo table = (TableInfo)infoOptional.get();
        LOGGER.error("\u53d1\u5e03\u65f6\u6821\u9a8c\u67e5\u8be2\u5355\u8868{}\u8017\u65f6\uff1a{}", (Object)this.sourceDataModelName.toUpperCase(), (Object)ToolUtil.logTime((long)start));
        if (ToolUtil.isNotEmpty((Object)table)) {
            ContrastVO<HeDataModelField> model = HEDataModelUtil.pushContrastWith(table.getFields(), this.getFields());
            if (model.getAddFields().size() == 0 && model.getDelFields().size() == 0 && model.getModifyFields().size() == 0) {
                info.setState(Integer.valueOf(2));
            } else {
                info.setState(Integer.valueOf(1));
            }
        } else {
            info.setState(Integer.valueOf(0));
        }
        info.setModelId(this.getId());
        contrast.add(info);
        contrastVOS.setDetails(contrast);
        return contrastVOS;
    }

    @Override
    public void sync() throws IOException, LcdpException {
        this.metaDataSync();
        this.syncModel(this.getFunctionType());
    }

    @Override
    public void syncModel(String functionType) throws IOException, LcdpException {
        ModelRelateService modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class);
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        ModelPublishDTO mpdto = HEOperationUtil.ModelToEngine(this);
        mpdto.setType(TypeConversionEnum.getValueByKey(functionType).getValue());
        resultList.add(mpdto);
        modelRelateService.save(resultList);
    }

    @Override
    public void metaDataSync() {
        MetadataParam param = HeBaseConnector.dealInfo(this);
        TableInfoDto tableInfoByTableName = HeExternalApiUtil.getTableByName(this.sourceDataModelName, false);
        if (tableInfoByTableName == null) {
            HeExternalApiUtil.insertTableInfo(param);
        } else {
            Long tableId = tableInfoByTableName.getTableId();
            param.getTableInfo().setTableId(tableId);
            HeExternalApiUtil.updateTableInfo(param);
        }
    }

    @Override
    public void delete(String modelId) {
        ModelRelateService modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class);
        modelRelateService.delete(modelId);
    }

    @Override
    public String copyTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        String dataSourceName = this.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return "";
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource dataSource = sysDataSourceService.getByConnName(dataSourceName);
        dataSource.setDbName(dataSourceName);
        TableCorrespond info = new TableCorrespond();
        if (fieldsContrastParam.getTableCorresponds() != null) {
            for (int x = 0; x < fieldsContrastParam.getTableCorresponds().size(); ++x) {
                if (!this.getId().equals(((TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x)).getModelId())) continue;
                info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x);
                break;
            }
        }
        boolean isCopy = true;
        if (info.getOldTableName() == null || info.getOldTableName() != null && !ToolUtil.isNotEmpty((Object)info.getOldTableName())) {
            isCopy = false;
        } else if (info.getTableName() == null || "".equals(info.getTableName())) {
            if (!("[]".equals(info.getAddFields()) && "[]".equals(info.getDelFields()) && "[]".equals(info.getModifyFields()))) {
                isCopy = true;
            } else {
                boolean findCurrentTable = info.getTableName() != null && ToolUtil.isNotEmpty((Object)info.getTableName()) ? DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)info.getTableName()).isPresent() : DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase()).isPresent();
                isCopy = !findCurrentTable;
            }
        }
        String sql = "";
        if (isCopy) {
            sql = this.doCopy(dataSource, (TableCorrespond<HeDataModelField>)info);
        }
        return sql;
    }

    private String doCopy(SysDataSource datasourceLr, TableCorrespond<HeDataModelField> info) throws Exception {
        MetadataParam paramData = new MetadataParam();
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        List delFields = JSON.parseArray((String)info.getDelFields(), HeDataModelField.class);
        for (int y = 0; y < delFields.size(); ++y) {
            ColumnInfoDto del = new ColumnInfoDto();
            del.setColumnName(((HeDataModelField)((Object)delFields.get(y))).getSourceFieldName());
            deletedCols.add(del);
        }
        paramData.setDeletedCols(deletedCols);
        List addFields = JSON.parseArray((String)info.getAddFields(), HeDataModelField.class);
        List editFields = JSON.parseArray((String)info.getModifyFields(), HeEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)info.getOldTableName().toUpperCase());
        TableInfo table = infoOptional.orElseGet(TableInfo::new);
        List<Object> oldColumn = new ArrayList();
        TableInfoDto tableInfoDto = HeBaseConnector.tableInfoInCreate(datasourceLr, this);
        paramData.setTableInfo(tableInfoDto);
        if (table.getFields() != null) {
            oldColumn = this.transform(HEDataModelUtil.htabTransmodel(table.getFields()));
            if (StringUtil.isNotEmpty((Object)tableInfoDto.getTableDec()) && tableInfoDto.getTableDec().equals(table.getComment())) {
                tableInfoDto.setTableDec(null);
            }
        } else {
            paramData.setColumnInfo(this.transformDto(this.getFields(), "all"));
        }
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        return ddlService.getDdlSql(paramData, oldColumn, info.getOldTableName());
    }
}

