/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.eai.service;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkInvokeParams;
import com.jxdinfo.hussar.eai.client.sdk.api.service.EaiClientTokenApiSdkService;
import com.jxdinfo.hussar.eai.client.sdk.properties.EaiClientSdkProperties;
import com.jxdinfo.hussar.eai.client.sdk.utils.EaiSyncApiSdkUtil;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiInfoSdkDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppApiSyncSdkDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppInfoSdkDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppSyncSdkDto;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.eai.model.ClientInfoDto;
import com.jxdinfo.hussar.formdesign.eai.service.PlatFormService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="EaiPlatFormService")
public class EaiPlatFormServiceImpl
implements PlatFormService {
    @Autowired
    private EaiClientTokenApiSdkService eaiClientTokenApiSdkService;
    @Autowired
    private EaiClientSdkProperties eaiClientSdkProperties;

    @Override
    public ApiResponse<List<ClientInfoDto>> getPlatFormClients() {
        if (!this.checkProperties().booleanValue()) {
            return ApiResponse.fail((String)"\u96c6\u6210\u5e73\u53f0\u8fde\u63a5\u4fe1\u606f\u672a\u914d\u7f6e");
        }
        EaiApiSdkInvokeParams eaiApiSdkInvokeParams = this.initParams();
        String token = this.eaiClientTokenApiSdkService.getClientToken(eaiApiSdkInvokeParams);
        if (StringUtil.isBlank((CharSequence)token)) {
            return ApiResponse.fail((String)"\u96c6\u6210\u5e73\u53f0\u914d\u7f6e\u4fe1\u606f\u6821\u9a8c\u5931\u8d25");
        }
        return ApiResponse.success(Arrays.asList(this.enclosureClientInfo(eaiApiSdkInvokeParams)));
    }

    @Override
    public ApiResponse<List<AppInfoSdkDto>> getAppDetailListNoParams() {
        if (!this.checkProperties().booleanValue()) {
            return ApiResponse.fail((String)"\u96c6\u6210\u5e73\u53f0\u8fde\u63a5\u4fe1\u606f\u672a\u914d\u7f6e");
        }
        ApiResponse appDetailListNoParams = EaiSyncApiSdkUtil.getAppDetailListNoParams((AppSyncSdkDto)this.initAppSdkDto());
        if (appDetailListNoParams.isSuccess()) {
            return appDetailListNoParams;
        }
        return ApiResponse.fail((String)appDetailListNoParams.getMsg());
    }

    @Override
    public ApiResponse<List<ApiInfoSdkDto>> getAppDetailApiList(String ids) {
        if (!this.checkProperties().booleanValue()) {
            return ApiResponse.fail((String)"\u96c6\u6210\u5e73\u53f0\u8fde\u63a5\u4fe1\u606f\u672a\u914d\u7f6e");
        }
        List<Object> list = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)ids)) {
            list = Arrays.stream(ids.split(",")).map(Long::valueOf).collect(Collectors.toList());
        }
        ArrayList appInfoSdkDtos = new ArrayList();
        List partition = Lists.partition(list, (int)100);
        for (List apiBatchVos : partition) {
            AppApiSyncSdkDto appApiSyncSdkDto = new AppApiSyncSdkDto();
            BeanUtils.copyProperties((Object)this.initAppSdkDto(), (Object)appApiSyncSdkDto);
            appApiSyncSdkDto.setApiIds(apiBatchVos);
            ApiResponse apiDetailApiList = EaiSyncApiSdkUtil.getAppDetailApiList((AppApiSyncSdkDto)appApiSyncSdkDto);
            if (apiDetailApiList.getCode() == 10000) {
                List data = (List)apiDetailApiList.getData();
                appInfoSdkDtos.addAll(data);
                continue;
            }
            return ApiResponse.fail((String)apiDetailApiList.getMsg());
        }
        return ApiResponse.success(appInfoSdkDtos);
    }

    private AppSyncSdkDto initAppSdkDto() {
        AppSyncSdkDto appSyncSdkDto = new AppSyncSdkDto();
        appSyncSdkDto.setClientId(this.eaiClientSdkProperties.getClientId());
        appSyncSdkDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
        appSyncSdkDto.setUrl(this.eaiClientSdkProperties.getEaiUrl());
        appSyncSdkDto.setClientToken(this.eaiClientTokenApiSdkService.getClientToken(this.initParams()));
        return appSyncSdkDto;
    }

    private EaiApiSdkInvokeParams initParams() {
        EaiApiSdkInvokeParams eaiApiSdkInvokeParams = new EaiApiSdkInvokeParams();
        eaiApiSdkInvokeParams.setClientId(this.eaiClientSdkProperties.getClientId());
        eaiApiSdkInvokeParams.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
        eaiApiSdkInvokeParams.setServerUrl(this.eaiClientSdkProperties.getEaiUrl());
        return eaiApiSdkInvokeParams;
    }

    public Boolean checkProperties() {
        return !StringUtil.isBlank((CharSequence)this.eaiClientSdkProperties.getClientId()) && !StringUtil.isBlank((CharSequence)this.eaiClientSdkProperties.getClientSecret()) && !StringUtil.isBlank((CharSequence)this.eaiClientSdkProperties.getEaiUrl());
    }

    private ClientInfoDto enclosureClientInfo(EaiApiSdkInvokeParams eaiApiSdkInvokeParams) {
        ClientInfoDto clientInfoDto = new ClientInfoDto();
        clientInfoDto.setBaseUrl(eaiApiSdkInvokeParams.getServerUrl());
        clientInfoDto.setClientId(eaiApiSdkInvokeParams.getClientId());
        return clientInfoDto;
    }
}

