/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.eai.processor;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.eai.code.AppConnectCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.eai.function.element.AppConnectDataModel;
import com.jxdinfo.hussar.formdesign.eai.function.model.AppConnectDataModelDto;
import com.jxdinfo.hussar.formdesign.eai.function.model.AppConnectDataModelOperation;
import com.jxdinfo.hussar.formdesign.eai.function.model.AppConnectInterfaceDto;
import com.jxdinfo.hussar.formdesign.eai.function.model.AppConnectParam;
import com.jxdinfo.hussar.formdesign.eai.function.render.AppConnectRender;
import com.jxdinfo.hussar.formdesign.eai.model.InvokeDto;
import com.jxdinfo.hussar.formdesign.eai.result.AppConnectCodeResult;
import com.jxdinfo.hussar.formdesign.eai.util.AppConnectCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.eai.util.AppConnectPublicEnclosure;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class AppConnectProcessor
implements DataModelProcessor<AppConnectCodeResult> {
    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"APP", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<AppConnectCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException {
        AppConnectDataModel appConnectDataModel = (AppConnectDataModel)DataModelUtil.getDataModelObject((String)dataModelBase.getId(), AppConnectDataModel.class);
        if (HussarUtils.isEmpty(appConnectDataModel.getOperations())) {
            return;
        }
        AppConnectDataModelDto dataModelDto = this.enclosure(dataModelBase);
        this.visit(publishCtx, appConnectDataModel, dataModelDto);
        List<AppConnectCodeGenerateInfo> generateInfos = AppConnectRender.render(dataModelDto, publishCtx.getBaseFile());
        List<AppConnectCodeResult> mergeResult = this.merge(generateInfos, publishCtx.getBaseFile(), publishCtx.getParams());
        publishCtx.addCodeResults(mergeResult);
    }

    public void visit(PublishCtx<AppConnectCodeResult> publishCtx, AppConnectDataModel appConnectDataModel, AppConnectDataModelDto dataModelDto) throws IOException, LcdpException {
        if (HussarUtils.isEmpty(appConnectDataModel.getOperations())) {
            return;
        }
        PageInfoNode pageInfoNode = DataModelUtil.getDataModelNode((String)appConnectDataModel.getId());
        for (AppConnectDataModelOperation operation : appConnectDataModel.getOperations()) {
            publishCtx.addApiResources(ApiResourceAcceptor.of((PageInfoNode)pageInfoNode, (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{dataModelDto.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
    }

    public AppConnectDataModelDto enclosure(DataModelBase dataModelBase) throws LcdpException {
        AppConnectDataModel appConnectDataModel = (AppConnectDataModel)DataModelUtil.getDataModelObject((String)dataModelBase.getId(), AppConnectDataModel.class);
        AppConnectDataModelDto dataModelDto = new AppConnectDataModelDto();
        AppConnectPublicEnclosure.enclosure(appConnectDataModel, dataModelDto);
        dataModelDto.setInterfaces(this.enclosureInterface(appConnectDataModel.getOperations(), appConnectDataModel.getId(), dataModelDto.getTablePath()));
        return dataModelDto;
    }

    public List<AppConnectInterfaceDto> enclosureInterface(List<AppConnectDataModelOperation> operations, String modelId, String tablePath) {
        ArrayList<AppConnectInterfaceDto> interfaceDtos = new ArrayList<AppConnectInterfaceDto>();
        for (AppConnectDataModelOperation operation : operations) {
            List<AppConnectParam> body;
            InvokeDto invokeDto = new InvokeDto();
            invokeDto.setModelId(modelId);
            invokeDto.setOptionId(operation.getId());
            AppConnectInterfaceDto interfaceDto = new AppConnectInterfaceDto(operation.getId(), operation.getFunctionName(), operation.getComment(), operation.getApiPath(), operation.getRemark(), invokeDto);
            interfaceDto.setUrl("${PREFIX.name}" + tablePath + "/" + interfaceDto.getName());
            interfaceDto.setPermissions(FileUtil.posixPath((String[])new String[]{tablePath, operation.getName()}).replace("/", ":"));
            interfaceDtos.add(interfaceDto);
            if (HussarUtils.isEmpty((Object)operation.getInParams()) || (body = operation.getInParams().getBody()) == null || body.isEmpty()) continue;
            interfaceDto.setInParam();
        }
        return interfaceDtos;
    }

    private List<AppConnectCodeResult> merge(List<AppConnectCodeGenerateInfo> generateInfos, BaseFile baseFile, Map<String, Object> map) throws IOException, LcdpException {
        return AppConnectCodeMergeUtil.mergeBack(generateInfos, baseFile, map);
    }
}

