/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.eai.function.render;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.eai.code.AppConnectCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.eai.code.info.BaseGenerateInfo;
import com.jxdinfo.hussar.formdesign.eai.function.model.AppConnectDataModelDto;
import com.jxdinfo.hussar.formdesign.eai.util.AppConnectRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AppConnectRender {
    public static List<AppConnectCodeGenerateInfo> render(AppConnectDataModelDto dataModelDto, BaseFile baseFile) throws LcdpException {
        ArrayList<AppConnectCodeGenerateInfo> generateInfos = new ArrayList<AppConnectCodeGenerateInfo>();
        generateInfos.add(AppConnectRender.renderApi(dataModelDto, baseFile));
        generateInfos.add(AppConnectRender.renderController(dataModelDto));
        generateInfos.add(AppConnectRender.renderService(dataModelDto));
        generateInfos.add(AppConnectRender.renderServiceImpl(dataModelDto));
        return generateInfos;
    }

    public static AppConnectCodeGenerateInfo renderApi(AppConnectDataModelDto dataModelDto, BaseFile baseFile) throws LcdpException {
        String filePath = "template/appconnect/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String code = AppConnectRenderUtil.renderTemplate(filePath, dataModelDto);
        return AppConnectRender.buildCodeGenerateInfo(dataModelDto.getId(), dataModelDto.getJsFilePath(), dataModelDto.getJsFileName(), code, "js");
    }

    public static AppConnectCodeGenerateInfo renderController(AppConnectDataModelDto dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        BaseGenerateInfo controllerGenerateInfo = dataModelDto.getControllerGenerateInfo();
        if (HussarUtils.isEmpty((Object)controllerGenerateInfo)) {
            controllerGenerateInfo = new BaseGenerateInfo();
        }
        controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
        controllerGenerateInfo.addImport(dataModelDto.getImportInfo().get("Service"));
        controllerGenerateInfo.addInversion(dataModelDto.getServiceName());
        dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        String code = AppConnectRenderUtil.renderTemplate("template/appconnect/controller.ftl", dataModelDto);
        return AppConnectRender.buildCodeGenerateInfo(dataModelDto.getId(), writePath, dataModelDto.getControllerName() + ".java", PrefixUtil.replacePrefix((String)code), "controller");
    }

    public static AppConnectCodeGenerateInfo renderService(AppConnectDataModelDto dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String code = AppConnectRenderUtil.renderTemplate("template/appconnect/service.ftl", dataModelDto);
        return AppConnectRender.buildCodeGenerateInfo(dataModelDto.getId(), writePath, dataModelDto.getServiceName() + ".java", PrefixUtil.replacePrefix((String)code), "service");
    }

    public static AppConnectCodeGenerateInfo renderServiceImpl(AppConnectDataModelDto dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl".toLowerCase() + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        BaseGenerateInfo serviceImplGenerateInfo = dataModelDto.getServiceImplGenerateInfo();
        if (HussarUtils.isEmpty((Object)serviceImplGenerateInfo)) {
            serviceImplGenerateInfo = new BaseGenerateInfo();
        }
        serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
        serviceImplGenerateInfo.addImport(dataModelDto.getImportInfo().get("Service"));
        dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        String code = AppConnectRenderUtil.renderTemplate("template/appconnect/serviceImpl.ftl", dataModelDto);
        return AppConnectRender.buildCodeGenerateInfo(dataModelDto.getId(), writePath, dataModelDto.getServiceImplName() + ".java", PrefixUtil.replacePrefix((String)code), "serviceImpl");
    }

    private static AppConnectCodeGenerateInfo buildCodeGenerateInfo(String modelId, String writePath, String fileName, String requestCode, String type) {
        AppConnectCodeGenerateInfo codeGenerateInfo = new AppConnectCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(requestCode);
        codeGenerateInfo.setFileType(type);
        codeGenerateInfo.setFileId(modelId);
        codeGenerateInfo.setFileName(fileName);
        return codeGenerateInfo;
    }
}

