package ${table.packageInfo.Controller!};

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
<#assign controller = table.controllerGenerateInfo!>
<#list controller.imports! as import>
    import ${import};
</#list>

/**
 * ${table.comment!}控制器
 */
@RestController(value = "${controller.qualifyBeanName!}")
@AuditLog(moduleName = "${table.comment!}")
@RequestMapping(value = "${table.controllerPrefix!}")
public class ${table.controllerName!} {

    private static final Logger logger = LoggerFactory.getLogger(${table.controllerName!}.class);

<#list controller.inversions! as inversion>
    @Autowired
    private ${inversion} ${inversion?uncap_first};
</#list>

    <#list table.interfaces! as interface>
    /**
     * ${interface.comment!}
     *
     * @param data 入参
     * @return 出参
     */
    @PostMapping(value = "/${interface.name!}")
    @AuditLog(moduleName = "${table.comment!}", eventDesc = "${interface.comment!}", eventGrade = AuditEventGrade.SERVICE_LOG_TYPE, evnetType = AuditEventType.QUERY)
    public ApiResponse<Object> ${interface.name!}(@RequestBody Object data) {
        return ${table.serviceName?uncap_first}.${interface.name!}(data);
    }
    </#list>

}
