/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.eai.provider;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.eai.function.AppConnectModelFunction;
import com.jxdinfo.hussar.formdesign.eai.function.model.AppConnectDataModelOperation;
import com.jxdinfo.hussar.formdesign.eai.function.model.AppConnectParam;
import com.jxdinfo.hussar.formdesign.eai.util.AppConnectModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AppConnectModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(AppConnectModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"APP", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            return FileUtil.posixPath((String[])new String[]{apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        return null;
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        AppConnectModelFunction modelFunction = AppConnectModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        if (ToolUtil.isNotEmpty(modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId)).getOperations())) {
            for (AppConnectDataModelOperation operation : modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId)).getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                List<AppConnectParam> body = operation.getOutParams().getBody();
                if (HussarUtils.isEmpty(body)) {
                    return "";
                }
                for (AppConnectParam appConnectParam : body) {
                    if (!"data".equals(appConnectParam.getName())) continue;
                    return appConnectParam.getQuoteStructureId();
                }
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId, String oldVersion, String organId, String newOrganId) throws LcdpException, IOException, CloneNotSupportedException {
        return null;
    }

    public void sync(String modelId) {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        return null;
    }

    public void delete(String modelId) throws LcdpException {
    }

    public Map<String, Map<String, Object>> getSlaveModelInfos(String modelId) throws LcdpException {
        return null;
    }
}

