package ${table.packageInfo.ServiceImpl!};

import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkInvokeParams;
import com.jxdinfo.hussar.eai.client.sdk.api.service.EaiApiSdkInvokService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.support.exception.HussarException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
<#assign serviceImpl = table.serviceImplGenerateInfo!>
<#list serviceImpl.imports! as import>
    import ${import};
</#list>

import java.util.HashMap;

/**
 * ${table.comment!}服务实现类
 */
@Service("${serviceImpl.qualifyBeanName!}")
public class ${table.serviceImplName!} implements ${table.serviceName!} {

    private static final Logger logger = LoggerFactory.getLogger(${table.serviceImplName!}.class);

    @Autowired
    private EaiApiSdkInvokService eaiApiSdkInvokService;


    <#list table.interfaces! as interface>
    @Override
    public ApiResponse<Object> ${interface.name!}(Object data) {
        try {
            return invoke(data, "${interface.apiPath!}");
        } catch (Exception e) {
            throw new HussarException("调用${interface.comment!}失败", e);
        }
    }
    </#list>

    /**
     * 调用集成平台方法
     * @param data 入参
     * @param url url
     * @return 出参
     */
    private ApiResponse<Object> invoke(Object data, String url) {
        EaiApiSdkInvokeParams eaiApiSdkInvokeParams = new EaiApiSdkInvokeParams();
        eaiApiSdkInvokeParams.setBody(data);
        eaiApiSdkInvokeParams.setUri(url);
        eaiApiSdkInvokeParams.setHeader(new HashMap<>());
        eaiApiSdkInvokeParams.setQuery(new HashMap<>());
        ApiResponse<Object> response = eaiApiSdkInvokService.getResponse(eaiApiSdkInvokeParams);
        if (!response.isSuccess()) {
            response.setCode(ResultCode.FAILURE.getCode());
        }
        return response;
    }
}
