<#escape x as x!"">
package ${modelName};

import com.jxdinfo.hussar.formdesign.formdesign.visitor.HussarBpmVariablesVisitor;
<#if params??>
<#list params.imports! as import>
import ${import!};
</#list>
</#if>
<#if slaveTable??>
import ${slaveTable.importInfo.Entity!};
import com.jxdinfo.hussar.workflow.manage.bpm.constant.CallActivityInfo;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
</#if>
import org.springframework.stereotype.Component;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
<#--遍历引入包，添加对应包到生成代码中-->
    <#if importClassNames?? && (importClassNames?size >0)>
        <#list importClassNames as importClassName>
import ${importClassName};
        </#list>

import javax.annotation.Resource;
    </#if>
import java.util.HashMap;
import java.util.Map;

<#if instanceKey != "" >
    @Component(value = "${componentId}${instanceKey}")
    public class ${identityKey?replace("_","")?cap_first?replace("-","")?replace(":","")}${instanceKey?cap_first}Visitor implements HussarBpmVariablesVisitor {
<#else >
    @Component(value = "${componentId}")
    public class ${identityKey?replace("_","")?cap_first?replace("-","")?replace(":","")}Visitor implements HussarBpmVariablesVisitor {
</#if>

<#--遍历表名，表名+Service组成方法名，引入对应方法依赖-->
<#if tableNames != ''>
    @Resource
<#if dataType == "TASK" || dataType == "TASK_MASTER_SLAVE">
    private ${tableNames?cap_first}Service ${tableNames?uncap_first}Service;
<#else>
    private ${tableNames?cap_first}Service ${tableNames?uncap_first}Service;
</#if>
</#if>

    @Override
    public Map${r'<String,'} Object> visit(String businessId) {
<#--遍历表名，表名作为对象类名，查询方法默认均使用了businessId  select不能放下面的那个循环，因为会增加查询次数-->
<#if tableNames != ''>
        //查询所需对象
    <#if params.isPlusQuery?? && params.isPlusQuery>
         ${params.PageDTO!} pageDTO = new ${params.PageDTO!}();
         pageDTO.setId(${params.primaryType!}.valueOf(businessId));
         ${params.returnValue!} ${tableNames?uncap_first} = ${tableNames?uncap_first}Service.formQueryPlus(pageDTO).getData();
         ${tableNames?uncap_first} = ${tableNames?uncap_first} != null ? ${tableNames?uncap_first} : new ${params.returnValue!}();
    <#else>
        ${tableNames?cap_first} ${tableNames?uncap_first} = ${tableNames?uncap_first}Service.formQuery(businessId).getData();
        ${tableNames?uncap_first} = ${tableNames?uncap_first} != null ? ${tableNames?uncap_first} : new ${tableNames?cap_first}();
    </#if>
</#if>
        //将所找属性放到map中传递
        Map${r'<String,'} Object> map = new HashMap<>();
<#--遍历属性名、字段名、表名组 属性名作为key表名作为对象，。get字段名（驼峰）作为方法获取对应值-->
<#if tableServerModels?? && (tableServerModels?size >0)>
    <#if securityLevelField??>
        map.put(BpmConstant.ANNOTATION_SECURITY_LEVEL_ATTRIBUTE,"${securityLevelField}");
    </#if>
<#list tableServerModels as tableServerModel>
    <#if tableServerModel.tableName != "" && tableNames?? && tableNames != ''>
        <#if tableServerModel.varType == "ArrayPrimary">
        if(HussarUtils.isNotEmpty(${tableNames?uncap_first}.${tableServerModel.getName})) {
            map.put("${tableServerModel.selectName}",Arrays.asList(${tableNames?uncap_first}.${tableServerModel.getName}.split(",")));
        }else {
            map.put("${tableServerModel.selectName}",${tableNames?uncap_first}.${tableServerModel.getName});
        }
        <#else>
        map.put("${tableServerModel.selectName}",${tableNames?uncap_first}.${tableServerModel.getName});
        </#if>
    <#else >
        map.put("${tableServerModel.selectName}",null);
    </#if>
</#list>
</#if>
    <#if slaveTable??>
        List<CallActivityInfo> list = new ArrayList<>();
        <#if tableType == "one-to-one">
        //处理一对一子表数据
        if(${tableNames?uncap_first}.gain${slaveTableAlias?cap_first}() != null) {
            ${slaveTable.entityName} ${slaveTableAlias!} = ${tableNames?uncap_first}.gain${slaveTableAlias?cap_first}();
            Map<String, Object> variables = new HashMap<>();
            CallActivityInfo callActivityInfo = new CallActivityInfo();
            callActivityInfo.setBusinessId(String.valueOf(${slaveTableAlias!}.get${slaveTable.keyField.capitalName!}()));
            <#list slaveTable.fields! as field>
                <#assign getprefix="get">
                <#if field.propertyType == "Boolean">
                    <#assign getprefix="is">
                </#if>
            variables.put("${field.propertyName}", ${slaveTableAlias!}.${getprefix}${field.capitalName}());
            </#list>
    <#if slaveSecurityLevel??>
        <#list slaveSecurityLevel as key, value>
            <#if key == slaveTableAlias>
                Integer securityLevel = HussarUtils.isEmpty(${slaveTableAlias!}.get${value?cap_first}()) ? null : Integer.valueOf(${slaveTableAlias!}.get${value?cap_first}());
                callActivityInfo.setSecurityLevel(securityLevel);
            </#if>
        </#list>
    </#if>
            callActivityInfo.setVariable(variables);
            list.add(callActivityInfo);
        }
        <#else >
        //处理所有子表数据
        <#if params.isPlusQuery?? && params.isPlusQuery>
            if(${tableNames?uncap_first}.gain${slaveTableAlias?cap_first}Array() != null && !${tableNames?uncap_first}.gain${slaveTableAlias?cap_first}Array().isEmpty()) {
                for (${slaveTable.entityName}VO ${slaveTableAlias!} : ${tableNames?uncap_first}.gain${slaveTableAlias?cap_first}Array()) {
        <#else>
            if(${tableNames?uncap_first}.gain${slaveTableAlias?cap_first}Array() != null && !${tableNames?uncap_first}.gain${slaveTableAlias?cap_first}Array().isEmpty()) {
                for (${slaveTable.entityName} ${slaveTableAlias!} : ${tableNames?uncap_first}.gain${slaveTableAlias?cap_first}Array()) {
        </#if>
                Map<String, Object> variables = new HashMap<>();
                CallActivityInfo callActivityInfo = new CallActivityInfo();
                callActivityInfo.setBusinessId(String.valueOf(${slaveTableAlias!}.get${slaveTable.keyField.capitalName!}()));
            <#list slaveTable.fields! as field>
                <#assign getprefix="get">
                <#if field.propertyType == "Boolean">
                    <#assign getprefix="is">
                </#if>
                variables.put("${field.propertyName}", ${slaveTableAlias!}.${getprefix}${field.capitalName}());
            </#list>
    <#if slaveSecurityLevel??>
        <#list slaveSecurityLevel as key, value>
            <#if key == slaveTableAlias>
                Integer securityLevel = HussarUtils.isEmpty(${slaveTableAlias!}.get${value?cap_first}()) ? null : Integer.valueOf(${slaveTableAlias!}.get${value?cap_first}());
                callActivityInfo.setSecurityLevel(securityLevel);
            </#if>
        </#list>
    </#if>
                callActivityInfo.setVariable(variables);
                list.add(callActivityInfo);
            }
        }
        </#if>
        map.put(BpmConstant.CALL_ACTIVITY_INFO, list);
    </#if>
        return map;
    }
}
</#escape>
