/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.back.common.util.ExtensionOperationJudge;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.constant.DmConstUtil;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.masterslave.util.DmMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.formdesign.dm.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMMASTER_SLAVEFormQuery")
public class DmMsFormQueryVisitor
implements DmOperationVisitor<DmMsDataModel, DmMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsFormQueryVisitor.class);
    public static final String OPERATION_NAME = "DMMASTER_SLAVEFormQuery";

    @Override
    public void visit(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        DmDataModelBase masterTable = dataModelBase.getMasterTable();
        DmMsDataModelDTO DMMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = DMMsDataModelDTO.getApiPrefix(new String[0]) + "/" + operation.getName();
        Map<String, DmDataModelBase> dataModelBaseMap = DMMsDataModelDTO.getDataModelBaseMap();
        Map<String, DmDataModelBaseDTO> dataModelDtoMap = DMMsDataModelDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = operation.getParams();
        Map slaveTablePlusSave = (Map)controllerParams.get("slaveTablePlusSave");
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        controllerParams.put("table", DMMsDataModelDTO);
        controllerParams.put("returnValue", DMMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        controllerParams.put("isPlusQuery", false);
        controllerParams.put("operationName", controllerParams.get("name"));
        String type = ExtensionOperationJudge.type(operation.getParams());
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            Map<String, String> slaveQueryNames;
            for (DmDataModelBase slaveTable : dataModelBase.getSlaveTables()) {
                capitalNameList.put(slaveTable.getName(), DmMasterSlaveUtil.getCapitalName(slaveTable.getName()));
            }
            controllerParams.put("boolFields", DMMsDataModelDTO.getFields().stream().filter(o -> "boolean".equals(o.getType())).collect(Collectors.toList()));
            controllerParams.put("capitalNameList", capitalNameList);
            controllerParams.put("returnIncrementValue", DMMsDataModelDTO.getEntityName() + "FormVO");
            controllerParams.put("slaveTable", DmMsFormQueryVisitor.getSlaveArrayTables(DMMsDataModelDTO, dataModelBase));
            controllerParams.put("primaryField", DMMsDataModelDTO.getKeyPropertyName());
            controllerParams.put("pageDTO", DMMsDataModelDTO.getEntityName() + "PageDTO");
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                controllerParams.put("isPlusQuery", true);
                break;
            }
            if (ToolUtil.isNotEmpty(slaveQueryNames = DmMsFormQueryVisitor.getSlaveQueryName(dataModelBase))) {
                controllerParams.put("slaveQueryNames", slaveQueryNames);
            }
            if (!HussarUtils.equals((Object)ExtensionOperationJudge.REUSED, (Object)type)) {
                DmDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
                backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Service"));
                backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
                backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Entity"));
                DmMsFormQueryVisitor.addFormVO(DMMsDataModelDTO, dataModelBase, slaveTablePlusSave, backCtx);
                DmMsFormQueryVisitor.addFormQueryDto(DMMsDataModelDTO, dataModelBase, slaveTablePlusSave, backCtx);
            }
        }
        if (HussarUtils.equals((Object)ExtensionOperationJudge.REUSED, (Object)type)) {
            this.addApi(backCtx, operation, DMMsDataModelDTO, "${PREFIX.standardName}", (Boolean)controllerParams.get("isPlusQuery"));
            return;
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(DMMsDataModelDTO.getComment() + "\u8868\u5355\u67e5\u8be2");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/dm/masterslavebackcode/get/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, DMMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, DMMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, DMMsDataModelDTO.getServiceName());
        String servicePath = "template/dm/masterslavebackcode/get/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        String serviceImplPath = "template/dm/masterslavebackcode/get/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        }
        if (ToolUtil.isNotEmpty((Object)DMMsDataModelDTO.isHasTranslate()) && DMMsDataModelDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addServiceImplInversion(modelId, DMMsDataModelDTO.getMapperName());
        if (AppContextUtil.isHTSZMode()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.formDesign.extension.method.ExtensionAnchorpointService");
            backCtx.addServiceImplResourceInversion(modelId, backCtx.getResourceInversion(DMMsDataModelDTO, null, false));
        }
        String mapperPath = "template/dm/masterslavebackcode/get/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        String finalReturn = SqlReturnUtil.renderReturn(dataModelBase, aliasMap);
        controllerParams.put("return", finalReturn);
        String finalRelation = SqlReturnUtil.renderRelation(dataModelBase, dataModelBaseMap);
        controllerParams.put("relation", finalRelation);
        controllerParams.put("quoteModel", DmConstUtil.TRUE);
        String whereTemplate = "where ${T}.${primary} = #{id}";
        String masterTableId = masterTable.getId();
        DmDataModelBaseDTO DMDataModelBaseDTO = dataModelDtoMap.get(masterTableId);
        if (ToolUtil.isNotEmpty((Object)DMDataModelBaseDTO)) {
            controllerParams.put("whereSql", whereTemplate.replace("${T}", aliasMap.get(masterTableId)).replace("${primary}", DMDataModelBaseDTO.getKeyField().getName()));
        }
        if (ToolUtil.isNotEmpty((Object)controllerParams.get("customizeSql"))) {
            backCtx.addXmlCode(modelId, (String)controllerParams.get("customizeSql"));
        } else {
            String xmlPath = "template/dm/masterslavebackcode/get/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        this.addApi(backCtx, operation, DMMsDataModelDTO, "${PREFIX.name}", (Boolean)controllerParams.get("isPlusQuery"));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private String addApi(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation operation, DmMsDataModelDTO dmMsDataModelDTO, String prefix, boolean isPlusQuery) throws LcdpException {
        String url = dmMsDataModelDTO.getApiPrefix(prefix) + "/" + operation.getName();
        String modelId = backCtx.getUseDataModelBase().getId();
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "get", url, "\u8868\u5355\u67e5\u8be2");
        backCtx.addApi(modelId, DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        if (isPlusQuery) {
            ApiGenerateInfo apiGenerateInfoPlus = new ApiGenerateInfo(operation.getName() + "Plus", "data", "postJson", url + "Plus", "\u589e\u91cf\u8868\u5355\u67e5\u8be2");
            backCtx.addApi(modelId, DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfoPlus));
        }
        return url;
    }

    private static void addFormVO(DmMsDataModelDTO dataModelBaseDTO, DmMsDataModel dataModelBase, Map<String, Boolean> slaveTablePlusSave, DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx) {
        DmQueryDTO queryDTO = new DmQueryDTO();
        String modelId = dataModelBase.getId();
        queryDTO.setFtlPath("template/dm/backcode/code/formVo.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        params.put("voImport", dataModelBaseDTO.getPackageInfo().get("VO"));
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("Entity"));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("masterTable", dataModelBaseDTO.getFields());
        params.put("slaveTable", DmMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + "FormVO");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "FormVO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("VO"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importVOPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + queryDTO.getEntityName();
        dataModelBaseDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importVOPath);
        backCtx.addServiceImport(modelId, importVOPath);
        backCtx.addServiceImplImport(modelId, importVOPath);
    }

    private static void addFormQueryDto(DmMsDataModelDTO dataModelBaseDTO, DmMsDataModel dataModelBase, Map<String, Boolean> slaveTablePlusSave, DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx) {
        DmQueryDTO queryDTO = new DmQueryDTO();
        String modelId = dataModelBase.getId();
        queryDTO.setFtlPath("template/dm/backcode/code/formDto.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("slaveTable", DmMsFormQueryVisitor.getSlaveArrayTables(dataModelBaseDTO, dataModelBase));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("dto"));
        params.put("queryDto", queryDTO);
        params.put("priType", dataModelBaseDTO.getKeyField().getPropertyType());
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + "PageDTO");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "PageDTO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
        String importDTOPath = dataModelBaseDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }

    private static List<DmDataModelBase> getSlaveArrayTables(DmMsDataModelDTO dataModelBaseDTO, DmMsDataModel dataModelBase) {
        CopyOnWriteArrayList<DmDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<DmDataModelBase>(dataModelBase.getSlaveTables());
        for (DmDataModelBase slaveArrayTable : slaveArrayTables) {
            for (SourcePackageInfo sourcePackageInfo : dataModelBaseDTO.getSourcePackageInfos()) {
                if (!"object".equals(sourcePackageInfo.getDataType()) || !slaveArrayTable.getName().equals(sourcePackageInfo.getObjectEnName())) continue;
                slaveArrayTables.remove(slaveArrayTable);
            }
        }
        return slaveArrayTables;
    }

    private static Map<String, String> getSlaveQueryName(DmMsDataModel dataModelBase) {
        List<DmDataModelOperation> operations = dataModelBase.getOperations();
        HashMap<String, String> slaveQueryNameMap = new HashMap<String, String>();
        List<DmDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        if (ToolUtil.isNotEmpty(slaveTables)) {
            block0: for (DmDataModelOperation operation : operations) {
                if (!ToolUtil.isNotEmpty((Object)operation) || !"SlaveQuery".equals(operation.getType()) || !ToolUtil.isNotEmpty((Object)operation.getName()) || !ToolUtil.isNotEmpty(operation.getParams()) || !ToolUtil.isNotEmpty((Object)operation.getParams().get("slaveModelId"))) continue;
                String slaveModelId = operation.getParams().get("slaveModelId").toString();
                for (DmDataModelBase slaveTable : slaveTables) {
                    if (!ToolUtil.isNotEmpty((Object)slaveTable) || !ToolUtil.isNotEmpty((Object)slaveModelId) || !slaveModelId.equals(slaveTable.getId())) continue;
                    slaveQueryNameMap.put(operation.getParams().get("slaveModelId").toString(), operation.getName());
                    continue block0;
                }
            }
        }
        return slaveQueryNameMap;
    }
}

