/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.masterslave;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.constant.DmConstUtil;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.masterslave.util.DmMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.formdesign.dm.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMMASTER_SLAVEDataImport")
public class DmMsDataImportVisitor
implements DmOperationVisitor<DmMsDataModel, DmMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsDataImportVisitor.class);
    public static final String OPERATION_NAME = "DMMASTER_SLAVEDataImport";

    @Override
    public void visit(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        DmMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        for (DmDataModelBase dmDataModelBase : dataModelBase.getSlaveTables()) {
            DmDataModelBaseDTO dmDataModelBaseDTO = dataModelBaseDTO.getDataModelDtoMap().get(dmDataModelBase.getId());
            String slaveModelName = dmDataModelBase.getName();
            for (DmDataModelFieldDto dmDataModelFieldDto : dmDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(dmDataModelFieldDto.getFill())) continue;
                relationTagKeys.put(slaveModelName, dmDataModelFieldDto.getCapitalName());
            }
        }
        if (HussarUtils.isNotEmpty(relationTagKeys)) {
            controllerParams.put("relationTagKeys", relationTagKeys);
        }
        HashMap<String, Boolean> slaveTablePlusSave = new HashMap<String, Boolean>();
        for (DmRelationshipDTO relationshipDTO : dataModelBaseDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        for (DmDataModelBase modelBase : dataModelBase.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((DmBaseDataModel)modelBase).getLogicallyDelete());
            DmDataModelBaseDTO dmDataModelBaseDTO = dataModelBaseDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, DmMasterSlaveUtil.getCapitalName(slaveModelName));
            for (DmDataModelField dmDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(dmDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, dmDataModelField.getName());
            }
            for (DmDataModelFieldDto dmDataModelFieldDto : dmDataModelBaseDTO.getFields()) {
                if ("primary".equals(dmDataModelFieldDto.getFill())) {
                    primaryKeys.put(slaveModelName, dmDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(dmDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, dmDataModelFieldDto.getCapitalName());
            }
        }
        this.addFormPlusSaveDto(dataModelBase, dataModelBaseDTO, backCtx, slaveTablePlusSave);
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        DmDataModelBaseDTO dmDataModelBaseDTO = dataModelBaseDTO.getDataModelDtoMap().get(dataModelBase.getMasterTable().getId());
        controllerParams.put("masterTable", dmDataModelBaseDTO);
        String controllerPath = "template/dm/masterslavebackcode/templateImport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/dm/masterslavebackcode/templateImport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        this.masterSlaveCode(backCtx, controllerParams);
        DmDataModelFieldDto keyField = dataModelBaseDTO.getKeyField();
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        String string = "template/dm/masterslavebackcode/templateImport/service_impl.ftl";
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        controllerParams.put("primaryKeys", primaryKeys);
        controllerParams.put("foreignKeys", foreignKeys);
        controllerParams.put("slaveTable", DmMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        controllerParams.put("isLogicallyDelete", isLogicallyDelete);
        controllerParams.put("logicallyDelField", logicallyDelField);
        controllerParams.put("capitalNameList", capitalNameList);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)string, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName(), "\u6a21\u677f\u6253\u5370");
        backCtx.addApi(modelId, DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, String modelId, DmMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.template.print.utils.VerifyExcelUtil");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.model.SysExcelTask");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.constants.TaskConstants");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.service.ISysExcelTaskService");
        backCtx.addServiceImplImport(modelId, "java.time.LocalDateTime");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplInversion(modelId, "ISysExcelTaskService");
        backCtx.addServiceImplInversion(modelId, "HussarThreadPoolConfiguration");
        backCtx.addServiceImplImport(modelId, "java.io.IOException");
        backCtx.addServiceImplImport(modelId, "java.io.InputStream");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.SecurityUser");
        backCtx.addServiceImplImport(modelId, "java.util.concurrent.Executor");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration");
    }

    private Map<String, Object> initParams(DmDataModelOperation dataModelOperation, DmMsDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6a21\u677f\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void masterSlaveCode(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        DmMsDataModelDTO dmMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<DmRelationshipDTO> relationshipDtoList = dmMsDataModelDTO.getRelationshipDtoList();
        DmDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, DmDataModelBaseDTO> dataModelDtoMap = dmMsDataModelDTO.getDataModelDtoMap();
        DmDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(backCtx, mainDataModelDto, dmMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (DmRelationshipDTO dmRelationshipDTO : relationshipDtoList) {
                List<DmRelationshipFieldDTO> dmRelationshipFieldDTOS;
                String slaveTableId = dmRelationshipDTO.getSlaveTableId();
                String relateModelType = dmRelationshipDTO.getRelateModelType();
                DmDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(backCtx, slaveModelDto, dmMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    dmRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(dmRelationshipFieldDTOS = dmRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private String renderFillCode(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelBaseDTO dataModelBaseDTO, DmMsDataModelDTO msDataModelDTO, boolean isMs, DmDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (DmDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", DmConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", DmConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", DmConstUtil.TRUE);
                    break;
                }
                case "primary": {
                    insertFill = true;
                    params.put("insertFill", DmConstUtil.TRUE);
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.support.engine.core.util.EngineUtil");
                    params.put("primaryFill", DmConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/dm/masterslavebackcode/templateImport/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private void addFormPlusSaveDto(DmMsDataModel dataModelBase, DmMsDataModelDTO dataModelDTO, DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, Map<String, Boolean> slaveTablePlusSave) {
        DmQueryDTO queryDTO = new DmQueryDTO();
        String modelId = dataModelBase.getId();
        String masterId = dataModelBase.getMasterTable().getId();
        queryDTO.setFtlPath("template/dm/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", DmMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("queryDto", queryDTO);
        params.put("table", dataModelDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelDTO.getName() + "IncrementDTO");
        queryDTO.setEntityName(dataModelDTO.getEntityName() + "IncrementDTO");
        queryDTO.setPackageInfo(dataModelDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importDTOPath = dataModelDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        dataModelDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }
}

