/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.masterslaveflow.extension;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMFLOW_MASTER_SLAVEextensionQuery")
public class DmMsFlowExtensionQueryVisitor
implements DmOperationVisitor<DmFlowMsDataModel, DmFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsFlowExtensionQueryVisitor.class);
    public static final String OPERATION_NAME = "DMFLOW_MASTER_SLAVEextensionQuery";

    @Override
    public void visit(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, DmDataModelOperation operation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        DmFlowMsDataModelDTO dmFlowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", dmFlowMsDataModelDTO);
        controllerParams.put("operationName", controllerParams.get("name"));
        List<DmDataModelBase> extendSlaveTables = DmMsFlowExtensionQueryVisitor.getSlaveArrayTables(dmFlowMsDataModelDTO, dataModelBase);
        controllerParams.put("extendSlaveTable", extendSlaveTables);
        HashMap<String, String> slaveTableValueNames = new HashMap<String, String>();
        for (DmDataModelBase dmDataModelBase : extendSlaveTables) {
            String slaveTableValueName = NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dmDataModelBase.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
            slaveTableValueNames.put(dmDataModelBase.getId(), slaveTableValueName);
        }
        controllerParams.put("slaveTableValueNames", slaveTableValueNames);
        HashMap<String, String> slaveTableForeign = new HashMap<String, String>();
        for (DmDataModelBase slaveTable : extendSlaveTables) {
            for (DmDataModelField field : slaveTable.getFields()) {
                if (!"foreign".equals(field.getUsage())) continue;
                slaveTableForeign.put(slaveTable.getId(), field.getName());
            }
        }
        controllerParams.put("slaveTableForeign", slaveTableForeign);
        String string = "template/dm/masterslavebackcode/extension/slaveQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)string, controllerParams));
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static List<DmDataModelBase> getSlaveArrayTables(DmMsDataModelDTO dataModelBaseDTO, DmMsDataModel dataModelBase) {
        CopyOnWriteArrayList<DmDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<DmDataModelBase>(dataModelBase.getSlaveTables());
        block0: for (DmDataModelBase slaveArrayTable : slaveArrayTables) {
            if (!slaveArrayTable.isExtension()) {
                slaveArrayTables.remove(slaveArrayTable);
                continue;
            }
            for (DmRelationshipDTO relationshipDTO : dataModelBaseDTO.getRelationshipDtoList()) {
                if (!"association".equals(relationshipDTO.getRelateModelType()) || !slaveArrayTable.getId().equals(relationshipDTO.getSlaveTableId())) continue;
                slaveArrayTables.remove(slaveArrayTable);
                continue block0;
            }
        }
        return slaveArrayTables;
    }
}

