/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.enclosure;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.function.DmEnclosure;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.translate.DmTranslate;
import com.jxdinfo.hussar.formdesign.dm.util.DmPublicEnclosure;
import com.jxdinfo.hussar.formdesign.dm.util.DmTemplateUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMFLOWENCLOSURE")
public class DmFlowEnclosure
implements DmEnclosure<DmFlowDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(DmFlowEnclosure.class);
    public static final String ENCLOSURE = "DMFLOWENCLOSURE";

    @Override
    public DmDataModelBaseDTO enclosure(DmFlowDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        List<DmDataModelField> dataModelFieldBases;
        DmFlowDataModelDTO dataModelBaseDTO = new DmFlowDataModelDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        DmPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        if (dataModelBase.getSourceDataModelName() != null) {
            dataModelBaseDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        }
        if (ToolUtil.isEmpty(dataModelFieldBases = dataModelBase.getFlowFields())) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new DmFlowDataModelDTO();
        }
        ArrayList<DmDataModelFieldDto> tableFields = new ArrayList<DmDataModelFieldDto>();
        for (DmDataModelField dataModelFieldBase : dataModelFieldBases) {
            DmDataModelFieldDto tableField = new DmDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        List<DmTranslate> translates = dataModelBase.getTranslate();
        if (ToolUtil.isNotEmpty(translates)) {
            List rightFields = ModelProvideAdapter.adaptor((String)dataModelBase.getId()).getFields(dataModelBase.getId());
            List<Map<String, Object>> translateAnnotations = DmTranslateUtil.translate(translates, rightFields);
            if (ToolUtil.isNotEmpty(translateAnnotations)) {
                List<DmDataModelFieldDto> fields = dataModelBaseDTO.getFields();
                block1: for (Map map : translateAnnotations) {
                    if (!ToolUtil.isNotEmpty((Object)map) || !ToolUtil.isNotEmpty(map.get("fieldId"))) continue;
                    for (DmDataModelFieldDto field : fields) {
                        if (!field.getId().equals(map.get("fieldId").toString())) continue;
                        field.setFieldAnnotation(map.get("fieldAnnotation").toString());
                        continue block1;
                    }
                }
                dataModelBaseDTO.setFields(fields);
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<DmDataModelFieldDto> translateShowFields = DmTranslateUtil.getTranslateShowFields(translates);
            for (DmDataModelFieldDto dmDataModelFieldDto : translateShowFields) {
                if (null == dmDataModelFieldDto.getColumnType() || null == dmDataModelFieldDto.getColumnType().getImportT()) continue;
                dataModelBaseDTO.addEntityImport(dmDataModelFieldDto.getColumnType().getImportT());
            }
            dataModelBaseDTO.setTranslateShowFields(translateShowFields);
        }
        PublishTemplateDto publishTemplateDto = DmTemplateUtil.processTemplate(dataModelBase.getId(), null);
        dataModelBaseDTO.setPublishTemplateDto(publishTemplateDto);
        return dataModelBaseDTO;
    }
}

