<#assign index = 1>
@Override
@HussarTransactional
public ApiResponse<?> ${operationName!}(MultipartFile file, String uniqueIdentification, String slaveTable,String slaveUniqueIdentification, String slaveForeignIdentification) {
    //适配单表不判断子表相关信息
    if (HussarUtils.isEmpty(uniqueIdentification)) {
        return ApiResponse.fail("缺少业务唯一标识信息");
    }
    //主表业务唯一标识名
    List<String> slaveTables = Arrays.asList(slaveTable.split(","));
    List<String> slaveUniqueIdentifications = Arrays.asList(slaveUniqueIdentification.split(","));
    List<String> slaveForeignIdentifications = Arrays.asList(slaveForeignIdentification.split(","));
    Map<String, String> param = new HashMap<>();
    Map<String, String> foreignParam = new HashMap<>();
    for (int i = 0; i < slaveTables.size(); i++) {
        param.put(slaveTables.get(i), slaveUniqueIdentifications.get(i));
        foreignParam.put(slaveTables.get(i), slaveForeignIdentifications.get(i));
    }
    <#if modelTranslate?? && modelTranslate!>
        String mapString = "${sourceMap!}";
        String sqlMapString = "${sqlMap!}";
        Map<String, String> sourceMap = new HashMap<>();
        Map<String, String> sqlMap = new HashMap<>();
        Map<String, String> sourceIdMap = new HashMap<>();

        String[] sqlPairs = sqlMapString.split("; ");
        for (String pair : sqlPairs) {
            String[] keyValue = pair.split(": ");
            if (keyValue.length == 2) {
                String key = keyValue[0].trim();
                String value = String.valueOf(keyValue[1].trim());
                sqlMap.put(key, value);
            }
        }

        String[] pairs = mapString.split(", ");
        for (String pair : pairs) {
            String[] keyValue = pair.split(": ");
            if (keyValue.length == 2) {
                String key = keyValue[0].trim();
                String value = String.valueOf(keyValue[1].trim());
                sourceMap.put(key, value);
            }
        }

        String useName2 = "${useName!}";
        String[] pairs2 = useName2.split(", ");
        for (String pair : pairs2) {
            String[] keyValue = pair.split(": ");
            if (keyValue.length == 2) {
                String key = keyValue[0].trim();
                String value = String.valueOf(keyValue[1].trim());
                sourceIdMap.put(key, value);
            }
        }
    Map<String,Map<String, Object>> temp = new HashMap<>();
    </#if>
    //表名和service对应关系
    Map<String, Class<?>> classMap = new HashMap<>();
    classMap.put("${table.comment}", ${masterTableName!}.class);
    <#list slaveTable as slave>
        classMap.put("${slave.comment}", ${slave.name?cap_first}.class);
    </#list>
    //主表物理主键与业务唯一标识对应关系
    Map<String, String> masterKeyCorrespondence = new HashMap<>();
    Map<String, Map<String, String>> dict = new HashMap<>();
    <#if table.hasTranslate?? && table.hasTranslate!>
        Map<String, String> map = new HashMap<>();
        <#list table.fields as field>
            <#if field.dictTyeName?? && field.dictTyeName != ''>
                map.put("${field.tableDesc}${field.comment}", "${field.dictTyeName}");
            </#if>
        </#list>
        <#list table.dataModelDtoMap as key, value>
            <#list value.fields as field>
                <#if field.dictTyeName?? && field.dictTyeName != ''>
                    map.put("${value.comment}${field.comment}","${field.dictTyeName}");
                </#if>
            </#list>
        </#list>
        List<DictVo> dictVosByTypeNames = iSysDicRefService.getDictVosByTypeNames(new ArrayList<>(map.values()));
        Map<String, List<DictVo>> group = dictVosByTypeNames.stream().collect(Collectors.groupingBy(DictVo::getTypeName));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            List<DictVo> dictVos = group.get(entry.getValue());
            if (HussarUtils.isNotEmpty(dictVos)){
                Map<String, String> collect = dictVos.get(0).getSingleList().stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
                dict.put(entry.getKey(), collect);
            }
        }
    </#if>
    try {
        //表名及对应实体类数据
        Map<String, List<?>> data = ExcelUtils.readFileManySheetToObj(file, classMap, dict);
        importData:
        for (Map.Entry<String, List<?>> entry : data.entrySet()) {
            if ("${table.comment}".equals(entry.getKey())) {
                //获取业务唯一标识对应属性
                Field declaredField = classMap.get(entry.getKey()).getDeclaredField(uniqueIdentification);
                //允许访问私有字段
                declaredField.setAccessible(true);
                List<${masterTableName!}> ${table.name?uncap_first}List = (List<${masterTableName!}>) entry.getValue();
                //主表业务唯一标识值
                List<String> values = new ArrayList<>();
                //获取库里的对应信息
                List<${masterTableName!}> masterList = ${masterServiceName?uncap_first}.list();
                if (!masterList.isEmpty()) {
                    for (${masterTableName!} ${table.name?uncap_first} : masterList) {
                        masterKeyCorrespondence.put(String.valueOf(${table.name?uncap_first}.get${primaryField?cap_first}()), String.valueOf(declaredField.get(${table.name?uncap_first})));
                    }
                }
                //循环获取值
                for (${masterTableName!} ${table.name?uncap_first} : ${table.name?uncap_first}List) {
                    if (HussarUtils.isEmpty(declaredField.get(${table.name?uncap_first}))) {
                        return ApiResponse.fail("");
                    }
                    String s = String.valueOf(declaredField.get(${table.name?uncap_first}));
                    values.add(s);
                    masterKeyCorrespondence.put(String.valueOf(${table.name?uncap_first}.get${primaryField?cap_first}()), s);
                    <#if isMasterslaveTask?? && isMasterslaveTask!>
                    if(HussarUtils.isEmpty(${table.name?uncap_first}.getCreator())){
                        ${table.name?uncap_first}.setCreator(BaseSecurityUtil.getUser().getId());
                    }
                    if (HussarUtils.isEmpty(${table.name?uncap_first}.getCreateTime())){
                        ${table.name?uncap_first}.setCreateTime(LocalDateTime.now());
                    }
                    </#if>
                }
                <#if modelTranslate?? && modelTranslate!>
                List<Map<String, Object>> clumsMap;
                for (int i = 0; i < ${table.name?uncap_first}List.size(); i++) {
                    Class<?> clazz = ${table.name?uncap_first}List.get(i).getClass();
                    Field[] fields = clazz.getDeclaredFields();
                    for (Field field : fields) {
                        if (sqlMap.containsKey("${table.comment}" + field.getName())){
                            clumsMap = ${table.mapperEnName?uncap_first}.getModelInfo(new StringBuilder(sqlMap.get("${table.comment}" + field.getName())));
                            String s = sourceIdMap.get("${table.comment}" + field.getName());
                            Map<String, Object> map6 = new HashMap<>();
                            for (int o = 0; o < clumsMap.size(); o++) {
                                if (HussarUtils.isNotEmpty(clumsMap.get(o).get(s))){
                                    map6.put(clumsMap.get(o).get(s).toString(), clumsMap.get(o).get(sourceMap.get("${table.comment}" + field.getName())));
                                }
                                temp.put("${table.comment}" + field.getName(),map6);
                            }
                        }
                    }
                    for (Field field : fields) {
                        if (field.isAnnotationPresent(TableField.class)) {
                            TableField tableField = field.getAnnotation(TableField.class);
                            // 检查此表是否有附加字段
                            if (sourceMap.containsKey("${table.comment}" + field.getName())) {
                                Map<String, Object> stringStringMap = temp.get("${table.comment}" + field.getName());
                                ${masterTableName!} obj = ${table.name?uncap_first}List.get(i);
                                // 使用反射获取getter和setter方法
                                Method getter = obj.getClass().getMethod("get" + capitalize(field.getName()));
                                if(field.getType().equals(Boolean.class)){
                                    getter = obj.getClass().getMethod("is" + capitalize(field.getName()));
                                }
                                Method setter = obj.getClass().getMethod("set" + capitalize(field.getName()), String.class);
                                Object o = getter.invoke(obj);
                                setter.invoke(obj, "");
                                if(HussarUtils.isNotEmpty(stringStringMap)){
                                    for (Map.Entry<String, Object> entry2 : stringStringMap.entrySet()) {
                                        if (entry2.getValue().toString().equals(o)) {
                                            setter.invoke(obj, entry2.getKey());
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                </#if>

                //主表只区分新增还是修改
                List<${masterTableName!}> addList = new ArrayList<>();
                List<${masterTableName!}> updateList = new ArrayList<>();
                Function<Object, String> f = (Object::toString);
                List<String> masterColumn = ExcelUtils.camelToSnake(Collections.singletonList(uniqueIdentification));
                List<String> strings = HussarUtils.isNotEmpty(values) ? ${masterServiceName?uncap_first}.listObjs(new QueryWrapper<${masterTableName!}>().in(masterColumn.get(0), values), f) : new ArrayList<>();
                if (!strings.isEmpty()) {
                    for (${masterTableName!} ${table.name?uncap_first} : ${table.name?uncap_first}List) {
                        if (strings.contains(String.valueOf(declaredField.get(${table.name?uncap_first})))) {
                            updateList.add(${table.name?uncap_first});
                        } else {
                           addList.add(${table.name?uncap_first});
                        }
                    }
                } else {
                    addList.addAll(${table.name?uncap_first}List);
                }
                if (!addList.isEmpty()) {
                    ${masterServiceName?uncap_first}.saveBatch(addList);
                }
                StringBuilder sb = new StringBuilder();
                String mainIdName = "";//数据库中主键字段名
                if (!updateList.isEmpty()) {
                    ${masterServiceName?uncap_first}.updateBatchById(updateList);
                }
            }
        <#list slaveTable as slave>
            if ("${slave.comment}".equals(entry.getKey())) {
                //获取业务唯一标识对应属性
                String slaveNatural${index!} = String.valueOf(param.get(entry.getKey()));
                Field declaredField${index!} = classMap.get(entry.getKey()).getDeclaredField(slaveNatural${index!});
                //获取外键对应属性（对应主表业务唯一标识）
                Field foreignKeyAttributes${index!} = classMap.get(entry.getKey()).getDeclaredField(foreignParam.get(entry.getKey()));
                //允许访问私有字段
                declaredField${index!}.setAccessible(true);
                foreignKeyAttributes${index!}.setAccessible(true);
                //业务唯一标识
                List<String> subValues${index!} = new ArrayList<>();
                //子表物理外键与外键对应关系
                //外键（对应主表业务唯一标识）
                Map<String, String> subKeyCorrespondence${index!} = new HashMap<>();

                List<${slave.name?cap_first}> ${slave.name}List = (List<${slave.name?cap_first}>) entry.getValue();
                //循环获取值
                for (${slave.name?cap_first} ${slave.name?uncap_first} : ${slave.name}List) {
                    if (HussarUtils.isEmpty(declaredField${index!}.get(${slave.name?uncap_first}))) {
                        declaredField${index!}.set(${slave.name?uncap_first},IdWorker.getId(${slave.name?uncap_first}));
                    }
                    subValues${index!}.add(String.valueOf(declaredField${index!}.get(${slave.name?uncap_first})));
                    // key 为外键字段名
                    subKeyCorrespondence${index!}.put(String.valueOf(${slave.name?uncap_first}.get${slave.foreignField?cap_first}()), String.valueOf(foreignKeyAttributes${index!}.get(${slave.name?uncap_first})));
                }
                if (!ExcelUtils.isMapContained(masterKeyCorrespondence, subKeyCorrespondence${index!})) {
                    throw new RuntimeException("外键关联有误");
                }
                <#if modelTranslate?? && modelTranslate!>
                List<Map<String, Object>> clumsMap2;
                for (int i = 0; i < ${slave.name}List.size(); i++) {
                    Class<?> clazz = ${slave.name}List.get(i).getClass();
                    Field[] fields = clazz.getDeclaredFields();
                    for (Field field : fields) {
                        if (sqlMap.containsKey("${slave.comment}" + field.getName())){
                            clumsMap2 = ${table.name?uncap_first}Mapper.getModelInfo(new StringBuilder(sqlMap.get("${slave.comment}" + field.getName())));
                            String s = sourceIdMap.get("${slave.comment}" + field.getName());
                            Map<String, Object> map6 = new HashMap<>();
                            for (int o = 0; o < clumsMap2.size(); o++) {
                                if (HussarUtils.isNotEmpty(clumsMap2.get(o).get(s))){
                                    map6.put(clumsMap2.get(o).get(s).toString(), clumsMap2.get(o).get(sourceMap.get("${slave.comment}" + field.getName())));
                                }
                                temp.put("${slave.comment}" + field.getName(),map6);
                            }
                        }
                    }
                    for (Field field : fields) {
                        if (field.isAnnotationPresent(TableField.class)) {
                            TableField tableField = field.getAnnotation(TableField.class);
                            // 检查此表是否有附加字段
                            if (sourceMap.containsKey("${slave.comment}" + field.getName())) {
                                Map<String, Object> stringStringMap = temp.get("${slave.comment}" + field.getName());
                                ${slave.name?cap_first} obj = ${slave.name}List.get(i);
                                // 使用反射获取getter和setter方法
                                Method getter = obj.getClass().getMethod("get" + capitalize(field.getName()));
                                if(field.getType().equals(Boolean.class)){
                                    getter = obj.getClass().getMethod("is" + capitalize(field.getName()));
                                }
                                Method setter = obj.getClass().getMethod("set" + capitalize(field.getName()), String.class);
                                Object o = getter.invoke(obj);
                                setter.invoke(obj, "");
                                if(HussarUtils.isNotEmpty(stringStringMap)){
                                    for (Map.Entry<String, Object> entry2 : stringStringMap.entrySet()) {
                                        if (entry2.getValue().toString().equals(o)) {
                                            setter.invoke(obj, entry2.getKey());
                                            break;
                                        }
                                    }
                                }

                            }
                        }
                    }
                }
                </#if>
                List<${slave.name?cap_first}> subAdd${index!} = new ArrayList<>();
                List<${slave.name?cap_first}> subUpdate${index!} = new ArrayList<>();
                Function<Object, String> f${index!} = (Object::toString);
                List<String> slaveColumn${index!} = ExcelUtils.camelToSnake(Collections.singletonList(slaveNatural${index!}));
                List<String> strings${index!} = HussarUtils.isNotEmpty(subValues${index!}) ? ${slave.name?uncap_first}Service.listObjs(new QueryWrapper<${slave.name?cap_first}>().in(slaveColumn${index!}.get(0), subValues${index!}), f${index!}) : new ArrayList<>();
                if (!strings${index!}.isEmpty()) {
                    for (${slave.name?cap_first} ${slave.name?uncap_first} : ${slave.name}List) {
                        if (strings${index!}.contains(String.valueOf(declaredField${index!}.get(${slave.name?uncap_first})))) {
                            subUpdate${index!}.add(${slave.name?uncap_first});
                        } else {
                            subAdd${index!}.add(${slave.name?uncap_first});
                        }
                    }
                } else {
                    subAdd${index!}.addAll(${slave.name}List);
                }
                if (!subAdd${index!}.isEmpty()) {
                    ${slave.name?uncap_first}Service.saveBatch(subAdd${index!});
                }
                if (!subUpdate${index!}.isEmpty()) {
                    ${slave.name?uncap_first}Service.updateBatchById(subUpdate${index!});
                }
            <#assign index++>
            }
        </#list>
        }
    } catch (Exception e) {
        throw new RuntimeException(e);
    }
    return ApiResponse.success();
}
