package ${table.packageInfo.aspect!};

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;
import java.util.HashMap;
import java.util.Map;

<#list aspect.imports! as import>
import  ${import!};
</#list>

@Aspect
@Component
@SuppressWarnings("unchecked")
public class ${aspectName!} {

    <#list aspect.inversions! as inversion>
        @Autowired
        private ${inversion} ${inversion?uncap_first};
    </#list>

    <#if aspect.inversionsWithName??>
        <#assign keys=aspect.inversionsWithName?keys/>
        <#list keys! as key>
            @Autowired
            private ${key} ${aspect.inversionsWithName[key]?uncap_first};
        </#list>
    </#if>

    @Before(value = "execution( * *(..))&&@annotation(${annotationName?uncap_first}))", argNames = "joinPoint,${annotationName?uncap_first}")
    public void before(JoinPoint joinPoint, ${annotationName!} ${annotationName?uncap_first}) throws Throwable {
        Map<String, Object> params = new HashMap<>();
        if (joinPoint.getArgs()[0] instanceof HashMap) {
            params = (Map<String, Object>) joinPoint.getArgs()[0];
        }
        ${aspect.beforeCode!}
    }

    @After(value = "execution( * *(..))&&@annotation(${annotationName?uncap_first}))", argNames = "joinPoint,${annotationName?uncap_first}")
    public void after(JoinPoint joinPoint, ${annotationName!} ${annotationName?uncap_first}) {
        Map<String, Object> params = new HashMap<>();
        if (joinPoint.getArgs()[0] instanceof HashMap) {
            params = (Map<String, Object>) joinPoint.getArgs()[0];
        }
        ${aspect.afterCode!}

    }

}
