package ${table.packageInfo.Entity!};

<#assign entity = table.entityGenerateInfo!>
<#include "../../swagger/swagger_model.ftl">
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.ExpansionMapEntity;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import org.apache.ibatis.type.Alias;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.baomidou.mybatisplus.annotation.Version;
<#list entity.imports! as import>
import ${import};
</#list>
${entityimport}

<#if table.entityName?contains("Master")>
    /**
    * ${table.entityName?substring(0,table.entityName?index_of("Master"))}主表实体类
    */
<#else >
    /**
    * ${table.comment!}实体类
    */
</#if>

@Alias("${entity.qualifyBeanName!}")
<#if table.sourceDataModelName?? && table.sourceDataModelName != ''>
@TableName("${table.sourceDataModelName!}")
<#if table.entityName?contains("Master")>
    <#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
    @ApiModel(value = "${table.entityName?substring(0,table.entityName?index_of("Master"))}主表")
    </#if>
<#else >
    ${apimodel!}
</#if>
</#if>
public class ${table.entityName!} extends ExpansionMapEntity implements BaseEntity{

    private static final long serialVersionUID = 1L;

<#assign keyPropertyName = "">
<#list table.fields! as field>
    /**
    * ${field.comment}
    */
<#if table.useMybatisPlus && "" != field.name>
    <#if field.keyFlag>
        <#assign keyPropertyName= field.propertyName>
    @TableId("${field.name ? upper_case}")
    <#else >
    @TableField(
        <#if field.type == "date">value=</#if>"${field.name ? upper_case}"
        <#if field.type == "date">,updateStrategy = FieldStrategy.IGNORED</#if>
    )
    </#if>
</#if>
    <#if table.validateAnnotations?? && (table.validateAnnotations?size>0)>
        <#list table.validateAnnotations[field.propertyName]! as annotation>
            ${annotation}
        </#list>
    </#if>
    <#if field.fieldAnnotation??>
        ${field.fieldAnnotation}
    </#if>
    @ApiModelProperty(value = "${field.comment}")
    <#if field.versionFlag>
        @Version
    </#if>
    private ${field.propertyType} ${field.propertyName};

</#list>

<#list table.translateShowFields! as field>
    /**
    * ${field.comment}
    */
    @TableField(exist = false)
    @ApiModelProperty(value = "${field.comment}")
    private ${field.propertyType} ${field.propertyName};
</#list>

/* @begin property #自定义属性 */
/* @end property */

<#list table.fields! as field>
    <#assign getprefix="get">
    <#if field.propertyType == "Boolean">
        <#assign getprefix="is">
    </#if>
    public ${field.propertyType} ${getprefix}${field.capitalName!}() {
        return ${field.propertyName};
    }

    public void set${field.capitalName!}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
    }

</#list>

<#list table.translateShowFields! as field>
    <#assign getprefix="get">
    <#if field.propertyType == "Boolean">
        <#assign getprefix="is">
    </#if>
    public ${field.propertyType} ${getprefix}${field.capitalName!}() {
            return ${field.propertyName};
        }

    public void set${field.capitalName!}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
    }
</#list>

/* @begin getAndSet #自定义get、set */
/* @end getAndSet */

<#--<#if table.useMybatisPlus>
    @Override
    public Serializable pkVal() {
    <#if keyPropertyName != "">
        return this.${keyPropertyName};
    <#else>
        return null;
    </#if>
    }
</#if>-->

    @Override
    public String toString() {
    return "${table.enName}{" +
    <#list table.fields! as field>
        <#if field_index == 0>
            "${field.propertyName}=" + ${field.propertyName} +
        <#else>
            ", ${field.propertyName}=" + ${field.propertyName} +
        </#if>
    </#list>
    "}";
    }
}
