/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.util;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.dm.code.DmCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;

public class DmRenderUtil {
    public static DmCodeGenerateInfo genHookServiceImplCode(DmDataModelBaseDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ExtensionAnchorpoint" + ".java";
        String filePath = "template/dm/backcode/code/extension_anchorpoint_impl.ftl";
        HashMap<String, Object> controllerParams = new HashMap<String, Object>();
        controllerParams.put("packageName", dataModelDto.getPackageInfo().get("ServiceImpl"));
        controllerParams.put("serviceName", AppContextUtil.getServicePrefix() + dataModelDto.getModuleName() + "." + dataModelDto.getName());
        controllerParams.put("className", dataModelDto.getEntityName() + "ExtensionAnchorpoint");
        HashSet<String> imports = new HashSet<String>();
        imports.add("com.jxdinfo.hussar.common.formDesign.extension.method.ExtensionAnchorpointService");
        imports.add("com.jxdinfo.hussar.common.formDesign.extension.method.impl.ExtensionAnchorpointServiceImpl");
        controllerParams.put("imports", imports);
        String newCode = RenderUtil.renderTemplate((String)filePath, controllerParams);
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ExtensionAnchorpoint" + ".java");
        return codeGenerateInfo;
    }
}

