/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.processor;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.DmCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmModelFunction;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.DmRender;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.result.DmCodeResult;
import com.jxdinfo.hussar.formdesign.dm.util.DmCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmModelProcessor
implements DataModelProcessor<DmCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(DmModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"DM", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<DmCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx = this.getDmBackCtx(publishCtx);
        DmModelProcessor.init(backCtx, dataModelBase);
        DmModelProcessor.generateSingleModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    public void generateForExt(PublishCtx<DmCodeResult> context, JSONObject dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx = this.getDmBackCtx(context);
        DmModelProcessor.init(backCtx, dataModelBase);
        DmModelProcessor.generateSingleModel(backCtx, context);
        context.setPublishDTO(backCtx.getPublishDTO());
    }

    private DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> getDmBackCtx(PublishCtx<DmCodeResult> publishCtx) {
        DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx = new DmBackCtx<DmDataModelBase, DmDataModelBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        if (publishCtx.getPublishDTO() != null) {
            backCtx.setPublishDTO(publishCtx.getPublishDTO());
        }
        return backCtx;
    }

    public static void init(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx, JSONObject dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        DmDataModelBase currentModelBase = DmDataModelUtil.transfer(dataModelBase);
        DmModelFunction currentFunction = DmModelBeanUtil.getFunctionModelVisitorBean(currentModelBase.getFunctionType());
        String modelId = currentModelBase.getId();
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, DmDataModelBaseDTO> useDtoMap = new HashMap<String, DmDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void init(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        DmModelFunction currentFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        DmDataModelBase currentModelBase = DmDataModelUtil.transfer(dataModelBase);
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, DmDataModelBaseDTO> useDtoMap = new HashMap<String, DmDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx, PublishCtx<DmCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        DmModelProcessor.visit(backCtx);
        DmModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        DmDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        DmDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PageInfoNode pageInfoNode = null;
        if (backCtx.getUseDataModelBase().getIsPublishResource()) {
            pageInfoNode = DataModelUtil.getDataModelNode((String)useDataModelBase.getId());
        }
        if (HussarUtils.isEmpty(useDataModelBase.getOperations())) {
            useDataModelBase.customOption(backCtx);
            return;
        }
        for (DmDataModelOperation operation : useDataModelBase.getOperations()) {
            DmOperationVisitor<DmDataModelBase, DmDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("DM", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            try {
                backCtx.getModelFunction().accept(visitor, backCtx, operation);
            }
            catch (Exception var) {
                logger.error("\u6a21\u578b\uff1a{}\uff0c\u65b9\u6cd5\uff1a{} \u6e32\u67d3\u5931\u8d25\uff0c\u6e32\u67d3\u8def\u5f84\uff1a{}", new Object[]{useDataModelBase.getComment(), operation.getName(), visitor.getClass().getName()});
                throw new LcdpException(var, String.format("\u6a21\u578b%s\u6e32\u67d3\u5931\u8d25\uff0c\u5f02\u5e38\uff1a%s", useDataModelBase.getComment(), var.getMessage()));
            }
            if (!backCtx.getUseDataModelBase().getIsPublishResource() || !ToolUtil.isNotEmpty((Object)pageInfoNode)) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((PageInfoNode)pageInfoNode, (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getComment()));
        }
        useDataModelBase.customOption(backCtx);
    }

    public static void render(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx, PublishCtx<DmCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        DmRender<DmDataModelBase, DmDataModelBaseDTO> render = backCtx.getModelFunction().render();
        List<DmCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(DmCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
        if (HussarUtils.isNotEmpty((Object)backCtx.getParams())) {
            backCtx.getParams().keySet().forEach(key -> {
                if (ToolUtil.isEmpty((Object)publishCtx.getParams())) {
                    publishCtx.addParams(new HashMap());
                }
                publishCtx.getParams().putIfAbsent(key, backCtx.getParam((String)key));
            });
        }
    }
}

