/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.task.masterslavetask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMTASK_MASTER_SLAVESerialNumber")
public class DmMsTaskSerialNumberVisitor
implements DmOperationVisitor<DmTaskMsDataModel, DmTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsTaskSerialNumberVisitor.class);
    public static final String OPERATION_NAME = "DMTASK_MASTER_SLAVESerialNumber";

    @Override
    public void visit(DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> taskBackCtx, DmDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        DmFlowMsDataModelDTO dmFlowMsDataModelDTO = (DmFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        DmFlowMsDataModel dataModelBase = (DmFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        DmBackCtx backCtx = new DmBackCtx();
        backCtx.setUseDataModelBase(dataModelBase);
        HashMap<String, DmFlowMsDataModelDTO> map = new HashMap<String, DmFlowMsDataModelDTO>();
        map.put(modelId, dmFlowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        Map<String, DmDataModelBaseDTO> dataModelDtoMap = dmFlowMsDataModelDTO.getDataModelDtoMap();
        DmDataModelBase masterTable = dataModelBase.getMasterTable();
        DmDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterTable.getId());
        Optional<DmDataModelFieldDto> serialFieldOpt = mainDataModelDto.getFields().stream().filter(m -> HussarUtils.equals((Object)"serialNumber", (Object)m.getFill())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        if (HussarUtils.isEmpty(operation.getParams())) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", mainDataModelDto);
        params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        DmDataModelFieldDto field = serialFieldOpt.get();
        params.put("field", field);
        params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
        params.put("parameter", dmFlowMsDataModelDTO.getQueryDtoMap().get(dmFlowMsDataModelDTO.getName()).getEntityName());
        params.put("returnValue", mainDataModelDto.getEntityName());
        dmFlowMsDataModelDTO.addServiceImplImport(mainDataModelDto.getImportInfo().get("Entity"));
        dmFlowMsDataModelDTO.addServiceImport(mainDataModelDto.getImportInfo().get("Entity"));
        dmFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
        dmFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
        dmFlowMsDataModelDTO.addServiceImplImport("java.util.HashMap");
        dmFlowMsDataModelDTO.addServiceImplImport("java.util.Map");
        dmFlowMsDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSONObject");
        dmFlowMsDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSON");
        dmFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        dmFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        dmFlowMsDataModelDTO.addServiceImplImport("org.apache.commons.beanutils.BeanUtils");
        dmFlowMsDataModelDTO.addServiceImplImport("java.lang.reflect.InvocationTargetException");
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        backCtx.addServiceImplInversion(((DmFlowMsDataModel)backCtx.getUseDataModelBase()).getId(), "ISysCodeRuleService");
        String implPath = "template/dm/taskbackcode/masterslavetaskbackcode/serialNumber/serialNumberServiceImpl.ftl";
        String servicePath = "template/dm/taskbackcode/masterslavetaskbackcode/serialNumber/serialNumberService.ftl";
        SerialNumberUtil.saveCodeRule(JSONObject.parseObject((String)JSON.toJSONString((Object)masterTable)), masterTable.getComment(), masterTable.getSourceDataModelName(), field.getName(), params, false, field.getId());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, params));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

