/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.masterslave.extension;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMMASTER_SLAVEextensionSlaveQueryPlus")
public class DmMsExtensionSlaveQueryPlusVisitor
implements DmOperationVisitor<DmMsDataModel, DmMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsExtensionSlaveQueryPlusVisitor.class);
    public static final String OPERATION_NAME = "DMMASTER_SLAVEextensionSlaveQueryPlus";

    @Override
    public void visit(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation operation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        DmMsDataModelDTO dmMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", dmMsDataModelDTO);
        controllerParams.put("operationName", controllerParams.get("name"));
        List<DmDataModelBase> extendSlaveTables = DmMsExtensionSlaveQueryPlusVisitor.getSlaveArrayTables(dmMsDataModelDTO, dataModelBase);
        if (extendSlaveTables.isEmpty()) {
            return;
        }
        controllerParams.put("extendSlaveTable", extendSlaveTables);
        HashMap<String, String> slaveTableValueNames = new HashMap<String, String>();
        for (DmDataModelBase slaveTable : extendSlaveTables) {
            String slaveTableValueName = NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)slaveTable.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
            slaveTableValueNames.put(slaveTable.getId(), slaveTableValueName);
        }
        controllerParams.put("slaveTableValueNames", slaveTableValueNames);
        String serviceImplPath = "template/dm/masterslavebackcode/extension/slaveQueryPlus/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplInversion(modelId, dmMsDataModelDTO.getMapperName());
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static List<DmDataModelBase> getSlaveArrayTables(DmMsDataModelDTO dataModelBaseDTO, DmMsDataModel dataModelBase) {
        CopyOnWriteArrayList<DmDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<DmDataModelBase>(dataModelBase.getSlaveTables());
        block0: for (DmDataModelBase slaveArrayTable : slaveArrayTables) {
            if (!slaveArrayTable.isExtension()) {
                slaveArrayTables.remove(slaveArrayTable);
                continue;
            }
            for (DmRelationshipDTO relationshipDTO : dataModelBaseDTO.getRelationshipDtoList()) {
                if (!"association".equals(relationshipDTO.getRelateModelType()) || !slaveArrayTable.getId().equals(relationshipDTO.getSlaveTableId())) continue;
                slaveArrayTables.remove(slaveArrayTable);
                continue block0;
            }
        }
        for (DmDataModelBase slaveArrayTable : slaveArrayTables) {
            boolean flag = false;
            for (DmDataModelOperation operation : dataModelBase.getOperations()) {
                if (!slaveArrayTable.getId().equals(operation.getParams().get("slaveModelId")) || !operation.getType().equals("SlaveQuery")) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            slaveArrayTables.remove(slaveArrayTable);
        }
        return slaveArrayTables;
    }
}

