/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.masterslave;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMMASTER_SLAVESerialNumber")
public class DmMsSerialNumberVisitor
implements DmOperationVisitor<DmMsDataModel, DmMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsSerialNumberVisitor.class);
    public static final String OPERATION_NAME = "DMMASTER_SLAVESerialNumber";

    @Override
    public void visit(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        DmMsDataModelDTO dmMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Optional<DmDataModelFieldDto> serialFieldOpt = dmMsDataModelDTO.getFields().stream().filter(m -> HussarUtils.equals((Object)"serialNumber", (Object)m.getFill())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        DmDataModelBase masterTable = dataModelBase.getMasterTable();
        Map<String, DmDataModelBaseDTO> dataModelDtoMap = dmMsDataModelDTO.getDataModelDtoMap();
        DmDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterTable.getId());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", mainDataModelDto);
        params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        DmDataModelFieldDto field = serialFieldOpt.get();
        params.put("field", field);
        params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
        params.put("returnValue", mainDataModelDto.getEntityName());
        dmMsDataModelDTO.addServiceImplImport(mainDataModelDto.getImportInfo().get("Entity"));
        dmMsDataModelDTO.addServiceImport(mainDataModelDto.getImportInfo().get("Entity"));
        dmMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
        dmMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
        dmMsDataModelDTO.addServiceImplImport("java.util.HashMap");
        dmMsDataModelDTO.addServiceImplImport("java.util.Map");
        dmMsDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSONObject");
        dmMsDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSON");
        dmMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        dmMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        dmMsDataModelDTO.addServiceImplImport("org.apache.commons.beanutils.BeanUtils");
        dmMsDataModelDTO.addServiceImplImport("java.lang.reflect.InvocationTargetException");
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        backCtx.addServiceImplInversion(dataModelBase.getId(), "ISysCodeRuleService");
        String implPath = "template/dm/masterslavebackcode/serialNumber/serialNumberServiceImpl.ftl";
        String servicePath = "template/dm/masterslavebackcode/serialNumber/serialNumberService.ftl";
        SerialNumberUtil.saveCodeRule(JSONObject.parseObject((String)JSON.toJSONString((Object)masterTable)), masterTable.getComment(), masterTable.getSourceDataModelName(), field.getName(), params, false, field.getId());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, params));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

