/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.baseflow;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMFLOWSerialNumber")
public class DmFlowSerialNumberVisitor
implements DmOperationVisitor<DmFlowDataModel, DmFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmFlowSerialNumberVisitor.class);
    public static final String OPERATION_NAME = "DMFLOWSerialNumber";

    @Override
    public void visit(DmBackCtx<DmFlowDataModel, DmFlowDataModelDTO> flowBackCtx, DmDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = flowBackCtx.getUseDataModelBase().getId();
        DmFlowDataModelDTO dataModelBaseDTO = flowBackCtx.getUseDataModelDtoMap().get(modelId);
        DmFlowDataModel useDataModelBase = flowBackCtx.getUseDataModelBase();
        DmBackCtx backCtx = new DmBackCtx();
        backCtx.setUseDataModelBase(useDataModelBase);
        HashMap<String, DmFlowDataModelDTO> map = new HashMap<String, DmFlowDataModelDTO>();
        map.put(modelId, dataModelBaseDTO);
        backCtx.setUseDataModelDtoMap(map);
        Optional<DmDataModelFieldDto> serialFieldOpt = dataModelBaseDTO.getFields().stream().filter(m -> HussarUtils.equals((Object)"serialNumber", (Object)m.getFill())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        DmDataModelFieldDto field = serialFieldOpt.get();
        params.put("field", field);
        params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
        params.put("returnValue", dataModelBaseDTO.getEntityName());
        dataModelBaseDTO.addServiceImplImport(dataModelBaseDTO.getImportInfo().get("Entity"));
        params.put("parameter", dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getEntityName());
        dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
        dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
        dataModelBaseDTO.addServiceImplImport("java.util.HashMap");
        dataModelBaseDTO.addServiceImplImport("java.util.Map");
        dataModelBaseDTO.addServiceImplImport("com.alibaba.fastjson.JSONObject");
        dataModelBaseDTO.addServiceImplImport("com.alibaba.fastjson.JSON");
        dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        dataModelBaseDTO.addServiceImplImport("org.apache.commons.beanutils.BeanUtils");
        dataModelBaseDTO.addServiceImplImport("java.lang.reflect.InvocationTargetException");
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getServiceName());
        backCtx.addServiceImplInversion(useDataModelBase.getId(), "ISysCodeRuleService");
        String implPath = "template/dm/flowbackcode/baseflowbackcode/serialNumber/serialNumberServiceImpl.ftl";
        String servicePath = "template/dm/flowbackcode/baseflowbackcode/serialNumber/serialNumberService.ftl";
        SerialNumberUtil.saveCodeRule(JSONObject.parseObject((String)JSONObject.toJSONString((Object)useDataModelBase)), useDataModelBase.getComment(), useDataModelBase.getSourceDataModelName(), field.getName(), params, false, field.getId());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, params));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

