/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.base;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMBASESerialNumber")
public class DmSerialNumberVisitor
implements DmOperationVisitor<DmBaseDataModel, DmBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmSerialNumberVisitor.class);
    public static final String OPERATION_NAME = "DMBASESerialNumber";

    @Override
    public void visit(DmBackCtx<DmBaseDataModel, DmBaseDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        DmBaseDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = useDataModelBase.getId();
        DmBaseDataModelDTO dmBaseDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Optional<DmDataModelFieldDto> serialFieldOpt = dmBaseDataModelDTO.getFields().stream().filter(m -> HussarUtils.equals((Object)"serialNumber", (Object)m.getFill())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dmBaseDataModelDTO);
        DmDataModelFieldDto field = serialFieldOpt.get();
        params.put("field", field);
        params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
        params.put("returnValue", dmBaseDataModelDTO.getEntityName());
        dmBaseDataModelDTO.addServiceImplImport(dmBaseDataModelDTO.getImportInfo().get("Entity"));
        dmBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
        dmBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
        dmBaseDataModelDTO.addServiceImplImport("java.util.HashMap");
        dmBaseDataModelDTO.addServiceImplImport("java.util.Map");
        dmBaseDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSONObject");
        dmBaseDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSON");
        dmBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        dmBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        dmBaseDataModelDTO.addServiceImplImport("org.apache.commons.beanutils.BeanUtils");
        dmBaseDataModelDTO.addServiceImplImport("java.lang.reflect.InvocationTargetException");
        backCtx.addServiceImplInversion(useDataModelBase.getId(), "ISysCodeRuleService");
        String implPath = "template/dm/backcode/serialNumber/serialNumberServiceImpl.ftl";
        String servicePath = "template/dm/backcode/serialNumber/serialNumberService.ftl";
        SerialNumberUtil.saveCodeRule(JSONObject.parseObject((String)JSONObject.toJSONString((Object)useDataModelBase)), useDataModelBase.getComment(), useDataModelBase.getSourceDataModelName(), field.getName(), params, false, field.getId());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, params));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

