/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.element.masterslave;

import com.google.common.base.CaseFormat;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlTransUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipBase;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ResultMapUtil {
    protected static final int DEF_SB_SIZE = 128;
    private static final String KEY_COLUMN = "<id column=\"${column}\" property=\"${property}\"/>\n";
    private static final String RESULT_COLUMN = "<result column=\"${column}\" property=\"${property}\"/>\n";
    private static final String ASSOCIATION = "<association property=\"${property}\" javaType=\"${javaType}\">\n${associationContent}</association>\n";
    private static final String COLLECTION = "<collection property=\"${property}\" column=\"{${column}}\" ofType=\"${javaType}\" javaType=\"ArrayList\" select=\"${alias}SubSelect\" fetchType=\"eager\">\n</collection>\n";
    private static final String SUBSELECT = "<!-- \u4e00\u5bf9\u591a\u5b50\u67e5\u8be2 -->\n<select id=\"${alias}SubSelect\" resultMap=\"${subMap}\">\nSELECT\n${fieldSql!}\nFROM ${subTable!}\nWHERE ${whereSql!}\n</select>";
    private static final String SUB_MAP = "<!-- \u4e00\u5bf9\u591a\u67e5\u8be2Map -->\n<resultMap id=\"${subMap}\" type=\"${subClass}\">\n${result}</resultMap>\n";

    public static String renderResultMap(DmMsDataModel dataModelBase, Map<String, DmDataModelBaseDTO> dataModelDtoMap, Map<String, DmDataModelBase> dataModelBaseMap) {
        StringBuilder finalResult = new StringBuilder(128);
        List<DmDataModelField> baseFields = dataModelBase.getFields();
        int currIndex = -1;
        for (DmDataModelField modelFieldBase : baseFields) {
            ++currIndex;
            DmDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(baseFields, 0, currIndex);
            break;
        }
        DmDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterTableId = masterTable.getId();
        DmDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterTable.getId());
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        if (ToolUtil.isNotEmpty(baseFields)) {
            for (DmDataModelField field : baseFields) {
                String fromModelId = field.getSourceDataModelId();
                String attrType = field.getDataType();
                String attrName = field.getName();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)masterTableId) || DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)mainDataModelDto)) continue;
                DmRelationshipBase relationshipBase = ResultMapUtil.getRelation(fromModelId, dataModelBase);
                StringBuilder stringBuilder = new StringBuilder();
                DmDataModelBase dependModelBase = dataModelBaseMap.get(fromModelId);
                DmDataModelBaseDTO dependModelDto = dataModelDtoMap.get(fromModelId);
                List<DmDataModelField> dependFields = dependModelBase.getFields();
                for (DmDataModelField dependModelField : dependFields) {
                    if (!ToolUtil.isNotEmpty((Object)dependModelField.getSourceDataModelId())) continue;
                    stringBuilder.append(ResultMapUtil.handleAttr(dependModelField, aliasMap.get(fromModelId)));
                }
                if (ToolUtil.isEmpty((Object)relationshipBase) || "association".equals(relationshipBase.getRelateModelType())) {
                    finalResult.append(ASSOCIATION.replace("${property}", attrName).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${associationContent}", stringBuilder.toString()));
                    continue;
                }
                if (!"collection".equals(relationshipBase.getRelateModelType())) continue;
                String template = "${showName}=${alias}${realName},";
                StringBuilder column = new StringBuilder(128);
                for (DmRelationshipFieldBase relation : relationshipBase.getRelationships()) {
                    if ("input".equals(relation.getMode())) break;
                    String realName = "";
                    String showName = "";
                    for (DmDataModelField fieldBase1 : masterTable.getFields()) {
                        if (!StringUtils.isNotEmpty((CharSequence)fieldBase1.getSourceFieldName()) || !ToolUtil.isNotEmpty((Object)fieldBase1.getSourceDataModelId()) || !fieldBase1.getId().equals(relation.getMasterTableFieldId())) continue;
                        realName = ResultMapUtil.capitalFirst(fieldBase1.getName());
                        showName = fieldBase1.getName();
                        break;
                    }
                    column.append(template.replace("${showName}", CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, showName)).replace("${alias}", aliasMap.get(masterTableId)).replace("${realName}", realName));
                }
                finalResult.append(COLLECTION.replace("${property}", attrName).replace("${alias}", aliasMap.get(fromModelId)).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${column}", StringUtils.strip((String)column.toString(), (String)",")).replace("${collectionContent}", stringBuilder.toString()));
            }
        }
        return finalResult.toString();
    }

    public static String renderMasterResultMap(DmMsDataModel dataModelBase) {
        StringBuilder finalResult = new StringBuilder(128);
        List<DmDataModelField> baseFields = dataModelBase.getFields();
        int currIndex = -1;
        for (DmDataModelField modelFieldBase : baseFields) {
            ++currIndex;
            DmDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(baseFields, 0, currIndex);
            break;
        }
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        if (ToolUtil.isNotEmpty(baseFields)) {
            for (DmDataModelField dataModelFieldBase : baseFields) {
                String fromModelId = dataModelFieldBase.getSourceDataModelId();
                String originField = dataModelFieldBase.getSourceFieldName();
                String attrType = dataModelFieldBase.getDataType();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)aliasMap.get(fromModelId))) continue;
                finalResult.append(RESULT_COLUMN.replace("${column}", aliasMap.get(fromModelId) + dataModelFieldBase.getAttrName()).replace("${property}", dataModelFieldBase.getName()));
            }
        }
        return finalResult.toString();
    }

    public static String renderSubSelect(DmMsDataModel dataModelBase, Map<String, DmDataModelBaseDTO> dataModelDtoMap, Map<String, DmDataModelBase> dataModelBaseMap) throws LcdpException {
        StringBuilder finalResult = new StringBuilder(128);
        for (DmRelationshipBase relationship : dataModelBase.getRelationships()) {
            if (!"collection".equals(relationship.getRelateModelType())) continue;
            DmDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(relationship.getSlaveTableId());
            DmDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
            Map<String, String> aliasMap = dataModelBase.getModelAliasName();
            String alias = aliasMap.get(slaveModelBase.getId());
            String condition = ResultMapUtil.renderRelationCondition(dataModelBase.getMasterTable(), slaveModelBase, relationship.getRelationships(), alias, aliasMap.get(dataModelBase.getMasterTable().getId()));
            String subMap = ResultMapUtil.renderSubMap(slaveModelBase);
            finalResult.append(SUB_MAP.replace("${subMap}", alias + "SubResult").replace("${subClass}", slaveModelDto.getImportInfo().get("Entity")).replace("${result}", subMap));
            String subTable = slaveModelBase.getSourceDataModelName().toUpperCase() + " " + alias;
            finalResult.append(SUBSELECT.replace("${subMap}", alias + "SubResult").replace("${alias}", alias).replace("${fieldSql!}", "*").replace("${subTable!}", subTable).replace("${whereSql!}", condition));
        }
        return finalResult.toString();
    }

    public static String renderSubMap(DmDataModelBase dataModelBase) {
        StringBuilder finalResult = new StringBuilder(128);
        List<DmDataModelField> dataModelFieldBases = dataModelBase.getFields();
        int currIndex = -1;
        for (DmDataModelField modelFieldBase : dataModelFieldBases) {
            ++currIndex;
            DmDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(dataModelFieldBases, 0, currIndex);
            break;
        }
        if (ToolUtil.isNotEmpty(dataModelFieldBases)) {
            for (DmDataModelField dataModelFieldBase : dataModelFieldBases) {
                String showModelId = dataModelFieldBase.getSourceDataModelId();
                String originField = dataModelFieldBase.getSourceFieldName();
                String attrType = dataModelFieldBase.getDataType();
                if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)attrType)) continue;
                finalResult.append(ResultMapUtil.handleSubAttr(dataModelFieldBase));
            }
        }
        return finalResult.toString();
    }

    private static String renderRelationCondition(DmDataModelBase masterDataModelBase, DmDataModelBase slaveDataModelBase, List<DmRelationshipFieldBase> relationshipFieldBases, String alias, String mainAlias) {
        Optional<DmDataModelField> first;
        String field2;
        StringBuilder finalCondition = new StringBuilder(128);
        String modelConditionTemplate = "${CONNECT} ${T_RE}.${RE_FIELD} ${SYMBOL} ${FIELD}";
        for (int i = 0; i < relationshipFieldBases.size(); ++i) {
            DmRelationshipFieldBase relationshipFieldBase = relationshipFieldBases.get(i);
            String connect = relationshipFieldBase.getConnect();
            if (i == 0) {
                connect = "";
            }
            String mainField = DmDataModelUtil.getModelFieldById(masterDataModelBase.getFields(), relationshipFieldBase.getMasterTableFieldId()).getName();
            String dependField = DmDataModelUtil.getModelFieldById(slaveDataModelBase.getFields(), relationshipFieldBase.getSlaveTableFieldId()).getSourceFieldName();
            String symbol = relationshipFieldBase.getSymbol();
            field2 = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, mainField);
            field2 = "input".equals(relationshipFieldBase.getMode()) ? "'" + field2 + "'" : "#{" + field2 + "}";
            finalCondition.append(modelConditionTemplate.replace("${CONNECT}", connect).replace("${FIELD}", field2).replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)symbol)).replace("${T_RE}", alias).replace("${RE_FIELD}", dependField).replace("${RE}", mainAlias)).append(" ");
        }
        List<DmDataModelField> fields = slaveDataModelBase.getFields();
        if (HussarUtils.isNotEmpty(fields) && (first = fields.stream().filter(field -> "relationTag".equals(field.getUsage())).findFirst()).isPresent()) {
            DmDataModelField relationTagFiled = first.get();
            String connect = "";
            if (HussarUtils.isNotEmpty(relationshipFieldBases)) {
                connect = "AND";
            }
            String symbol = "=";
            String dependField = relationTagFiled.getSourceFieldName();
            field2 = "'" + slaveDataModelBase.getName() + "'";
            finalCondition.append(modelConditionTemplate.replace("${CONNECT}", connect).replace("${FIELD}", field2).replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)symbol)).replace("${T_RE}", alias).replace("${RE_FIELD}", dependField)).append(" ");
        }
        return finalCondition.toString();
    }

    private static String handleAttr(DmDataModelField dataModelFieldBase, String alias) {
        StringBuilder stringBuilder = new StringBuilder();
        String attrName = dataModelFieldBase.getAttrName();
        if (ToolUtil.isNotEmpty((Object)alias)) {
            if ("primary".equals(dataModelFieldBase.getUsage())) {
                stringBuilder.append(KEY_COLUMN.replace("${column}", alias + attrName).replace("${property}", dataModelFieldBase.getName()));
            } else {
                stringBuilder.append(RESULT_COLUMN.replace("${column}", alias + attrName).replace("${property}", dataModelFieldBase.getName()));
            }
        }
        return stringBuilder.toString();
    }

    private static String handleSubAttr(DmDataModelField dataModelFieldBase) {
        StringBuilder stringBuilder = new StringBuilder();
        String attrName = dataModelFieldBase.getName();
        if ("primary".equals(dataModelFieldBase.getUsage())) {
            stringBuilder.append(KEY_COLUMN.replace("${column}", dataModelFieldBase.getSourceFieldName()).replace("${property}", attrName));
        } else {
            stringBuilder.append(RESULT_COLUMN.replace("${column}", dataModelFieldBase.getSourceFieldName()).replace("${property}", attrName));
        }
        return stringBuilder.toString();
    }

    public static DmRelationshipBase getRelation(String fromModelId, DmMsDataModel dataModel) {
        for (DmRelationshipBase relationship : dataModel.getRelationships()) {
            if (!fromModelId.equals(relationship.getSlaveTableId())) continue;
            return relationship;
        }
        return new DmRelationshipBase();
    }

    public static String capitalFirst(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }

    public static String renderResultMap(DmTaskMsDataModel dataModelBase, Map<String, DmDataModelBaseDTO> dataModelDtoMap, Map<String, DmDataModelBase> dataModelBaseMap) {
        StringBuilder finalResult = new StringBuilder(128);
        List<DmDataModelField> baseFields = dataModelBase.getFields();
        int currIndex = -1;
        for (DmDataModelField modelFieldBase : baseFields) {
            ++currIndex;
            DmDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(baseFields, 0, currIndex);
            break;
        }
        DmDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterTableId = masterTable.getId();
        DmDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterTable.getId());
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        if (ToolUtil.isNotEmpty(baseFields)) {
            for (DmDataModelField field : baseFields) {
                String fromModelId = field.getSourceDataModelId();
                String attrType = field.getDataType();
                String attrName = field.getName();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)masterTableId) || DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)mainDataModelDto)) continue;
                DmRelationshipBase relationshipBase = ResultMapUtil.getRelation(fromModelId, dataModelBase);
                StringBuilder stringBuilder = new StringBuilder();
                DmDataModelBase dependModelBase = dataModelBaseMap.get(fromModelId);
                DmDataModelBaseDTO dependModelDto = dataModelDtoMap.get(fromModelId);
                List<DmDataModelField> dependFields = dependModelBase.getFields();
                for (DmDataModelField dependModelField : dependFields) {
                    if (!ToolUtil.isNotEmpty((Object)dependModelField.getSourceDataModelId())) continue;
                    stringBuilder.append(ResultMapUtil.handleAttr(dependModelField, aliasMap.get(fromModelId)));
                }
                if (ToolUtil.isEmpty((Object)relationshipBase) || "association".equals(relationshipBase.getRelateModelType())) {
                    finalResult.append(ASSOCIATION.replace("${property}", attrName).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${associationContent}", stringBuilder.toString()));
                    continue;
                }
                if (!"collection".equals(relationshipBase.getRelateModelType())) continue;
                String template = "${showName}=${alias}${realName},";
                StringBuilder column = new StringBuilder(128);
                for (DmRelationshipFieldBase relation : relationshipBase.getRelationships()) {
                    if ("input".equals(relation.getMode())) break;
                    String realName = "";
                    String showName = "";
                    for (DmDataModelField fieldBase1 : masterTable.getFields()) {
                        if (!StringUtils.isNotEmpty((CharSequence)fieldBase1.getSourceFieldName()) || !ToolUtil.isNotEmpty((Object)fieldBase1.getSourceDataModelId()) || !fieldBase1.getId().equals(relation.getMasterTableFieldId())) continue;
                        realName = ResultMapUtil.capitalFirst(fieldBase1.getName());
                        showName = fieldBase1.getName();
                        break;
                    }
                    column.append(template.replace("${showName}", CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, showName)).replace("${alias}", aliasMap.get(masterTableId)).replace("${realName}", realName));
                }
                finalResult.append(COLLECTION.replace("${property}", attrName).replace("${alias}", aliasMap.get(fromModelId)).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${column}", StringUtils.strip((String)column.toString(), (String)",")).replace("${collectionContent}", stringBuilder.toString()));
            }
        }
        return finalResult.toString();
    }

    public static String renderMasterResultMap(DmTaskMsDataModel dataModelBase) {
        StringBuilder finalResult = new StringBuilder(128);
        List<DmDataModelField> baseFields = dataModelBase.getFields();
        int currIndex = -1;
        for (DmDataModelField modelFieldBase : baseFields) {
            ++currIndex;
            DmDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(baseFields, 0, currIndex);
            break;
        }
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        if (ToolUtil.isNotEmpty(baseFields)) {
            for (DmDataModelField dataModelFieldBase : baseFields) {
                String fromModelId = dataModelFieldBase.getSourceDataModelId();
                String originField = dataModelFieldBase.getSourceFieldName();
                String attrType = dataModelFieldBase.getDataType();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)aliasMap.get(fromModelId))) continue;
                finalResult.append(RESULT_COLUMN.replace("${column}", aliasMap.get(fromModelId) + dataModelFieldBase.getAttrName()).replace("${property}", dataModelFieldBase.getName()));
            }
        }
        return finalResult.toString();
    }

    public static String renderResultMap(DmTaskDataModel dataModelBase, Map<String, DmDataModelBaseDTO> dataModelDtoMap, Map<String, DmDataModelBase> dataModelBaseMap) {
        StringBuilder finalResult = new StringBuilder(128);
        List<DmDataModelField> baseFields = dataModelBase.getFields();
        int currIndex = -1;
        for (DmDataModelField modelFieldBase : baseFields) {
            ++currIndex;
            DmDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(baseFields, 0, currIndex);
            break;
        }
        DmTaskDataModel TaskBusinessTable = dataModelBase;
        String TaskBusinessTableId = TaskBusinessTable.getId();
        DmDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(TaskBusinessTable.getId());
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        if (ToolUtil.isNotEmpty(baseFields)) {
            for (DmDataModelField field : baseFields) {
                String fromModelId = field.getSourceDataModelId();
                String attrType = field.getDataType();
                String attrName = field.getName();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)TaskBusinessTableId) || DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)mainDataModelDto)) continue;
                DmRelationshipBase relationshipBase = ResultMapUtil.getRelation(fromModelId, dataModelBase);
                StringBuilder stringBuilder = new StringBuilder();
                DmDataModelBase dependModelBase = dataModelBaseMap.get(fromModelId);
                DmDataModelBaseDTO dependModelDto = dataModelDtoMap.get(fromModelId);
                List<DmDataModelField> dependFields = dependModelBase.getFields();
                for (DmDataModelField dependModelField : dependFields) {
                    if (!ToolUtil.isNotEmpty((Object)dependModelField.getSourceDataModelId())) continue;
                    stringBuilder.append(ResultMapUtil.handleAttr(dependModelField, aliasMap.get(fromModelId)));
                }
                if (ToolUtil.isEmpty((Object)relationshipBase) || "association".equals(relationshipBase.getRelateModelType())) {
                    finalResult.append(ASSOCIATION.replace("${property}", attrName).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${associationContent}", stringBuilder.toString()));
                    continue;
                }
                if (!"collection".equals(relationshipBase.getRelateModelType())) continue;
                String template = "${showName}=${alias}${realName},";
                StringBuilder column = new StringBuilder(128);
                for (DmRelationshipFieldBase relation : relationshipBase.getRelationships()) {
                    if ("input".equals(relation.getMode())) break;
                    String realName = "";
                    String showName = "";
                    for (DmDataModelField fieldBase1 : TaskBusinessTable.getFields()) {
                        if (!StringUtils.isNotEmpty((CharSequence)fieldBase1.getSourceFieldName()) || !ToolUtil.isNotEmpty((Object)fieldBase1.getSourceDataModelId()) || !fieldBase1.getId().equals(relation.getMasterTableFieldId())) continue;
                        realName = ResultMapUtil.capitalFirst(fieldBase1.getName());
                        showName = fieldBase1.getName();
                        break;
                    }
                    column.append(template.replace("${showName}", CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, showName)).replace("${alias}", aliasMap.get(TaskBusinessTableId)).replace("${realName}", realName));
                }
                finalResult.append(COLLECTION.replace("${property}", attrName).replace("${alias}", aliasMap.get(fromModelId)).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${column}", StringUtils.strip((String)column.toString(), (String)",")).replace("${collectionContent}", stringBuilder.toString()));
            }
        }
        return finalResult.toString();
    }

    public static String renderMasterResultMap(DmTaskDataModel dataModelBase) {
        StringBuilder finalResult = new StringBuilder(128);
        List<DmDataModelField> baseFields = dataModelBase.getFields();
        int currIndex = -1;
        for (DmDataModelField modelFieldBase : baseFields) {
            ++currIndex;
            DmDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(baseFields, 0, currIndex);
            break;
        }
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        if (ToolUtil.isNotEmpty(baseFields)) {
            for (DmDataModelField dataModelFieldBase : baseFields) {
                String fromModelId = dataModelFieldBase.getSourceDataModelId();
                String originField = dataModelFieldBase.getSourceFieldName();
                String attrType = dataModelFieldBase.getDataType();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)aliasMap.get(fromModelId))) continue;
                finalResult.append(RESULT_COLUMN.replace("${column}", aliasMap.get(fromModelId) + dataModelFieldBase.getAttrName()).replace("${property}", dataModelFieldBase.getName()));
            }
        }
        return finalResult.toString();
    }

    public static String renderSubSelect(DmTaskDataModel dataModelBase, Map<String, DmDataModelBaseDTO> dataModelDtoMap, Map<String, DmDataModelBase> dataModelBaseMap) throws LcdpException {
        StringBuilder finalResult = new StringBuilder(128);
        for (DmRelationshipBase relationship : dataModelBase.getRelationships()) {
            if (!"collection".equals(relationship.getRelateModelType())) continue;
            DmDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(relationship.getSlaveTableId());
            DmDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
            Map<String, String> aliasMap = dataModelBase.getModelAliasName();
            String alias = aliasMap.get(slaveModelBase.getId());
            String condition = ResultMapUtil.renderRelationCondition(dataModelBase, slaveModelBase, relationship.getRelationships(), alias, aliasMap.get(dataModelBase.getId()));
            String subMap = ResultMapUtil.renderSubMap(slaveModelBase);
            finalResult.append(SUB_MAP.replace("${subMap}", alias + "SubResult").replace("${subClass}", slaveModelDto.getImportInfo().get("Entity")).replace("${result}", subMap));
            String subTable = slaveModelBase.getSourceDataModelName() + " " + alias;
            finalResult.append(SUBSELECT.replace("${subMap}", alias + "SubResult").replace("${alias}", alias).replace("${fieldSql!}", "*").replace("${subTable!}", subTable).replace("${whereSql!}", condition));
        }
        return finalResult.toString();
    }

    public static DmRelationshipBase getRelation(String fromModelId, DmTaskDataModel dataModel) {
        for (DmRelationshipBase relationship : dataModel.getRelationships()) {
            if (!fromModelId.equals(relationship.getSlaveTableId())) continue;
            return relationship;
        }
        return new DmRelationshipBase();
    }
}

