/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FormDesignStringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.function.DmModelFunction;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.service.DmWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(DmModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"DM", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + FormDesignStringUtil.underlineToHump((String)dataModelBase.getName());
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            return FileUtil.posixPath((String[])new String[]{apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
        if (ToolUtil.isEmpty((Object)dataModelJson)) {
            return "";
        }
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModelJson.getString("functionType"));
        DmDataModelBase lrDataModelBase = modelFunction.parseDataModel(dataModelJson);
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(DmDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        DmDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (DmDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId, String oldVersion, String organId, String newOrganId) throws LcdpException, IOException, CloneNotSupportedException {
        return new DmWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId, oldVersion, organId, newOrganId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        List<DataModelFieldBase> extSlaveFields;
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        DmDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> dmDataModelFields = new ArrayList<DataModelFieldBase>();
        List<DmDataModelField> fields = dataModelBase.getFields();
        List<Object> slaveTables = new ArrayList();
        DmDataModelBase masterTable = new DmBaseDataModel();
        if (modelFunction instanceof DmFlowMsDataModel) {
            slaveTables = ((DmFlowMsDataModel)dataModelBase).getSlaveTables();
            masterTable = ((DmFlowMsDataModel)dataModelBase).getMasterTable();
        } else if (modelFunction instanceof DmMsDataModel) {
            slaveTables = ((DmMsDataModel)dataModelBase).getSlaveTables();
            masterTable = ((DmMsDataModel)dataModelBase).getMasterTable();
        }
        if (ToolUtil.isNotEmpty(fields)) {
            dmDataModelFields.addAll(fields);
            dmDataModelFields.addAll(this.extFields(modelId, HussarUtils.isEmpty((Object)masterTable.getId()) ? modelId : masterTable.getId()));
            if (HussarUtils.isNotEmpty(slaveTables)) {
                for (DmDataModelBase dmDataModelBase : slaveTables) {
                    dmDataModelFields.addAll(this.extFields(modelId, dmDataModelBase.getId()));
                }
            }
        } else {
            dmDataModelFields.addAll(masterTable.getFields());
            dmDataModelFields.addAll(this.extFields(modelId, masterTable.getId()));
            if (HussarUtils.isNotEmpty(slaveTables)) {
                for (DmDataModelBase dmDataModelBase : slaveTables) {
                    dmDataModelFields.addAll(dmDataModelBase.getFields());
                    dmDataModelFields.addAll(this.extFields(modelId, dmDataModelBase.getId()));
                }
            }
        }
        if (modelFunction instanceof DmTaskDataModel) {
            dmDataModelFields.addAll(((DmTaskDataModel)dataModelBase).getTask().getFields());
        } else if (modelFunction instanceof DmTaskMsDataModel) {
            dmDataModelFields.addAll(((DmTaskMsDataModel)dataModelBase).getTask().getFields());
        }
        if ((modelFunction instanceof DmMsDataModel || modelFunction instanceof DmFlowMsDataModel || modelFunction instanceof DmTaskDataModel) && HussarUtils.isNotEmpty(extSlaveFields = this.extSlaveFields(modelId))) {
            dmDataModelFields.addAll(extSlaveFields);
        }
        return dmDataModelFields;
    }

    private List<DataModelFieldBase> extFields(String sourceId, String modelId) throws LcdpException {
        JSONObject extFieldsJson;
        Object fields;
        Object extFieldsObj;
        JSONObject dataModelBaseExt;
        ArrayList<DataModelFieldBase> extFields = new ArrayList<DataModelFieldBase>();
        if (AppContextUtil.isExtension() && HussarUtils.isNotEmpty((Object)(dataModelBaseExt = DataModelUtil.getDataModelJsonExt((String)sourceId))) && HussarUtils.isNotEmpty((Object)(extFieldsObj = dataModelBaseExt.get((Object)"extFields"))) && HussarUtils.isNotEmpty((Object)(fields = (extFieldsJson = JSONObject.parseObject((String)JSON.toJSONString((Object)extFieldsObj))).get((Object)modelId)))) {
            List dataModelFieldBases = JSONArray.parseArray((String)JSON.toJSONString((Object)fields), DataModelFieldBase.class);
            extFields.addAll(dataModelFieldBases);
        }
        return extFields;
    }

    private List<DataModelFieldBase> extSlaveFields(String sourceId) throws LcdpException {
        JSONArray extSlaveTables;
        ArrayList<DataModelFieldBase> extSlaveFields = new ArrayList<DataModelFieldBase>();
        JSONObject dataModelBaseExt = DataModelUtil.getDataModelJsonExt((String)sourceId);
        if (HussarUtils.isNotEmpty((Object)dataModelBaseExt) && HussarUtils.isNotEmpty((Object)(extSlaveTables = dataModelBaseExt.getJSONArray("slaveTables")))) {
            for (Object extSlaveTable : extSlaveTables) {
                DmDataModelBase dmDataModelBase = (DmDataModelBase)JsonUtil.parse((String)extSlaveTable.toString(), DmBaseDataModel.class);
                if (!HussarUtils.isNotEmpty((Object)dmDataModelBase) || !HussarUtils.isNotEmpty(dmDataModelBase.getFields())) continue;
                extSlaveFields.addAll(dmDataModelBase.getFields());
            }
        }
        return extSlaveFields;
    }

    public void delete(String modelId) throws LcdpException {
    }

    public Map<String, Map<String, Object>> getSlaveModelInfos(String modelId) throws LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        DmDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return model.getSlaveModelInfo();
    }

    public Map<String, Map<String, String>> getModelAliasName(String modelId) throws LcdpException, IOException, CloneNotSupportedException {
        HashMap<String, Map<String, String>> alias = new HashMap<String, Map<String, String>>();
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        DmDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if ("TASK_MASTER_SLAVE".equals(model.getFunctionType())) {
            DmTaskMsDataModelDTO enclosure = (DmTaskMsDataModelDTO)modelFunction.enclosure().enclosure(model);
            DmDataModelBase dmDataModelBase = enclosure.getDataModelBaseMap().get(modelId);
            alias.put("task", dmDataModelBase.getModelAliasName());
        }
        alias.put("noTask", model.getModelAliasName());
        return alias;
    }

    public Map<String, Object> getSomeModelInfo(JSONObject dataModel) throws LcdpException, IOException, CloneNotSupportedException {
        HashMap<String, Object> some = new HashMap<String, Object>();
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModel.getString("functionType"));
        DmDataModelBase model = modelFunction.parseDataModel(dataModel);
        DmDataModelBaseDTO enclosure = modelFunction.enclosure().enclosure(model);
        if ("TASK_MASTER_SLAVE".equals(model.getFunctionType())) {
            DmDataModelBaseDTO taskDTO = ((DmTaskMsDataModelDTO)enclosure).getDataModelDtoMap().get(dataModel.get((Object)"id"));
            some.put("importInfo", taskDTO.getImportInfo());
            String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)taskDTO.getServiceImplName(), (String)taskDTO.getTablePath().toLowerCase());
            some.put("qualifyBeanName", qualifyBeanName);
            return some;
        }
        if ("TASK".equals(model.getFunctionType())) {
            DmDataModelBaseDTO taskDTO = ((DmTaskDataModelDTO)enclosure).getDataModelDtoMap().get(dataModel.get((Object)"id"));
            some.put("importInfo", taskDTO.getImportInfo());
            String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)taskDTO.getServiceImplName(), (String)taskDTO.getTablePath().toLowerCase());
            some.put("qualifyBeanName", qualifyBeanName);
            return some;
        }
        some.put("importInfo", enclosure.getImportInfo());
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)enclosure.getServiceImplName(), (String)enclosure.getTablePath().toLowerCase());
        some.put("qualifyBeanName", qualifyBeanName);
        return some;
    }
}

