/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.render.DmBaseRender;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMMASTER_SLAVETotalCalculate")
public class DmMsTotalCalculateVisitor
implements DmOperationVisitor<DmMsDataModel, DmMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsTotalCalculateVisitor.class);
    public static final String OPERATION_NAME = "DMMASTER_SLAVETotalCalculate";

    @Override
    public void visit(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        DmMsDataModel dmBaseDataModel = backCtx.getUseDataModelBase();
        String modelId = dmBaseDataModel.getId();
        String expansionModelId = backCtx.getUseDataModelDtoMap().get(modelId).getControllerGenerateInfo().getExpansionModelId();
        boolean extensionFlag = backCtx.getUseDataModelDtoMap().get(modelId).isExtension();
        DmMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, dmBaseDataModel);
        boolean isLogicallyDelete = dmBaseDataModel.isLogicallyDelete();
        if (isLogicallyDelete) {
            String logicallyFlag = dmBaseDataModel.getModelAliasName().get(dmBaseDataModel.getMasterTable().getId()) + "." + dmBaseDataModel.getDeleteFlag().getSourceFieldName();
            controllerParams.put("logicallyFlag", logicallyFlag);
        }
        this.renderTotalCalculate(backCtx, modelId, dataModelBaseDTO, controllerParams);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        String controllerPath = "template/dm/masterslavebackcode/totalCalculate/controller.ftl";
        controllerParams.put("expansionModelIdTotal", expansionModelId + "Total");
        controllerParams.put("extension", AppContextUtil.isExtension());
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/dm/masterslavebackcode/totalCalculate/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/dm/masterslavebackcode/totalCalculate/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/dm/masterslavebackcode/totalCalculate/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/dm/masterslavebackcode/totalCalculate/xml.ftl";
        for (DmDataModelField dmDataModelField : dmBaseDataModel.getFields()) {
            dmDataModelField.setTableAlias(backCtx.getUseDataModelBase().getModelAliasName().get(dmDataModelField.getSourceDataModelId()));
        }
        String finalRelation = SqlReturnUtil.renderTotalCalculateRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap(), controllerParams);
        controllerParams.put("relation", finalRelation);
        controllerParams.put("sumFields", dmBaseDataModel.getFields());
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, DmBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, String modelId, DmMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (backCtx.getUseDataModelBase().isLogicallyDelete()) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "java.util.Map");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
    }

    private Map<String, Object> initParams(DmDataModelOperation dataModelOperation, DmMsDataModelDTO dataModelBaseDTO, DmMsDataModel dmBaseDataModel) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("isSelectCondition", Boolean.FALSE);
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        boolean isLogicallyDelete = dmBaseDataModel.isLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            DmDataModelField logicallyField = dmBaseDataModel.getDeleteFlag();
            controllerParams.put("logicallyFlag", logicallyField.getSourceFieldName());
            String logicallyFieldName = logicallyField.getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("getLogicallyFlag", String.valueOf(chars));
            controllerParams.put("deleteFlagName", logicallyField.getSourceFieldName());
        }
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u603b\u8ba1\u6570\u636e");
            } else {
                dataModelOperation.setExegesis("\u603b\u8ba1\u6570\u636e");
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderTotalCalculate(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, String modelId, DmMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        DmQueryDTO totalQuery = DmDataModelUtil.getTotalQueryDto(dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(totalQuery);
        controllerParams.put("QueryObj", totalQuery.getEntityName());
        controllerParams.put("queryObj", totalQuery.getName());
        String importInfo = totalQuery.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private void renderPageVo(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, String modelId, DmMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        DmDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

