/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.masterslaveflow.extension;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.masterslave.util.DmMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.dm.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DmFlowMsExtensionUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";
    private static final String FLOW_INCREMENT_NAME = "FlowIncrementDTO";

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx) throws LcdpException {
        DmFlowMsExtensionUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx) throws LcdpException {
        DmFlowMsExtensionUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        DmMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        DmMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        DmDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<DmRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        DmDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        ArrayList<DmRelationshipDTO> dmRelationshipDTOList = new ArrayList<DmRelationshipDTO>(relationshipDtoList);
        if (params.get("logicallyDelete") != null) {
            for (DmRelationshipDTO relationshipDTO : dmRelationshipDTOList) {
                if (!relationshipDTO.getSlaveTableDto().isExtension()) {
                    relationshipDtoList.remove(relationshipDTO);
                    continue;
                }
                relationshipDTO.init();
            }
        } else {
            for (DmRelationshipDTO relationshipDTO : dmRelationshipDTOList) {
                if (!relationshipDTO.getSlaveTableDto().isExtension()) {
                    relationshipDtoList.remove(relationshipDTO);
                    continue;
                }
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = new StringBuilder();
        if (HussarUtils.isNotEmpty(relationshipDtoList)) {
            relationStr = DmFlowMsExtensionUtil.getDelStr(relationshipDtoList, masterDto);
        }
        DmFlowMsExtensionUtil.renderTransaction(backCtx, params, currentModelId);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (DmRelationshipDTO dmRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            DmDataModelBaseDTO dmDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(dmRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, dmDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, dmDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, dmDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        DmMsDataModelDTO dmMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<DmRelationshipDTO> relationshipDtoList = dmMsDataModelDTO.getRelationshipDtoList();
        DmDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, DmDataModelBaseDTO> dataModelDtoMap = dmMsDataModelDTO.getDataModelDtoMap();
        DmDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        DmFlowMsExtensionUtil.renderTransaction(backCtx, controllerParams, modelId);
        String masterFillCode = DmFlowMsExtensionUtil.renderFillCode(backCtx, mainDataModelDto, dmMsDataModelDTO);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (DmRelationshipDTO relationshipDTO : relationshipDtoList) {
                List<DmRelationshipFieldDTO> dmRelationshipFieldDTOS;
                String slaveTableId = relationshipDTO.getSlaveTableId();
                String relateModelType = relationshipDTO.getRelateModelType();
                DmDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = DmFlowMsExtensionUtil.renderFillCode(backCtx, slaveModelDto, dmMsDataModelDTO);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                if (slaveFillCode != null) {
                    relationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(dmRelationshipFieldDTOS = relationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
            controllerParams.put("slaveFillCodeList", slaveFillCodeList);
        }
    }

    private static void renderTransaction(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams, String modelId) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, DmDataModelBaseDTO dataModelBaseDTO, DmMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (DmDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/dm/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<DmRelationshipDTO> relationshipDtoList, DmDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (DmRelationshipDTO relationtMap : relationshipDtoList) {
            List<DmRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            DmRelationshipFieldDTO dmRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                Optional<DmDataModelFieldDto> relationTag;
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(dmRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
                List<DmDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    DmDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(");\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(dmRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                Optional<DmDataModelFieldDto> relationTag;
                DmRelationshipFieldDTO dmRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(dmRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(dmRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(dmRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(DmFlowMsExtensionUtil.lowercase(masterDto.getEntityName())).append(".get").append(dmRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(dmRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(DmFlowMsExtensionUtil.lowercase(masterDto.getEntityName())).append(".get").append(dmRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                List<DmDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    DmDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static void generateIncrementDTO(DmMsDataModelDTO dmFlowDataModelDTO, DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) {
        Map<String, Object> params = dataModelOperation.getParams();
        Map slaveTablePlusSave = (Map)params.get("slaveTablePlusSave");
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        for (DmDataModelBase dmDataModelBase : dataModelBase.getSlaveTables()) {
            String slaveModelName = dmDataModelBase.getName();
            DmDataModelBaseDTO dmDataModelBaseDTO = dmFlowDataModelDTO.getDataModelDtoMap().get(dmDataModelBase.getId());
            for (DmDataModelFieldDto field : dmDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(field.getFill())) continue;
                relationTagKeys.put(slaveModelName, field.getCapitalName());
            }
        }
        params.put("relationTagKeys", relationTagKeys);
        boolean plusFlag = false;
        if (HussarUtils.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        params.put("ifPlusSave", plusFlag);
        if (!plusFlag) {
            return;
        }
        for (DmRelationshipDTO relationshipDTO : dmFlowDataModelDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        DmFlowMsExtensionUtil.addIncrementTable(dmFlowDataModelDTO, slaveTablePlusSave, dataModelBase);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        for (DmDataModelBase modelBase : dataModelBase.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((DmBaseDataModel)modelBase).getLogicallyDelete());
            DmDataModelBaseDTO dmDataModelBaseDTO = dmFlowDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, DmMasterSlaveUtil.getCapitalName(slaveModelName));
            for (DmDataModelField dmDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(dmDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, dmDataModelField.getName());
                break;
            }
            for (DmDataModelFieldDto dmDataModelFieldDto : dmDataModelBaseDTO.getFields()) {
                if ("primary".equals(dmDataModelFieldDto.getFill())) {
                    hashMap.put(slaveModelName, dmDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(dmDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, dmDataModelFieldDto.getCapitalName());
            }
        }
        params.put("primaryKeys", hashMap);
        params.put("foreignKeys", foreignKeys);
        params.put("slaveTablePlusSave", slaveTablePlusSave);
        params.put("slaveTable", DmMasterSlaveUtil.ofSlaveParam(dataModelBase, dmFlowDataModelDTO));
        params.put("isLogicallyDelete", isLogicallyDelete);
        params.put("logicallyDelField", logicallyDelField);
        params.put("capitalNameList", capitalNameList);
        String modelId = backCtx.getUseDataModelBase().getId();
        if (HussarUtils.isEmpty((Object)dmFlowDataModelDTO.getQueryDtoMap().get(dmFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME))) {
            DmQueryDTO oldDTO = dmFlowDataModelDTO.getQueryDtoMap().get(dmFlowDataModelDTO.getName());
            DmQueryDTO dmQueryDTO = (DmQueryDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oldDTO), DmQueryDTO.class);
            HashMap<String, Object> newParams = new HashMap<String, Object>();
            newParams.put("queryDto", dmQueryDTO);
            HashMap<String, Boolean> table = new HashMap<String, Boolean>();
            table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
            newParams.put("table", table);
            dmQueryDTO.setParams(newParams);
            String string = dmFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME;
            String plusTableName = dmFlowDataModelDTO.getEntityName() + "IncrementTable";
            for (DmQueryFieldDTO dto : dmQueryDTO.getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                dto.getDbColumnType().setType(plusTableName);
                dto.getDbColumnType().setImportT(dmQueryDTO.getPackageInfo() + "." + plusTableName);
                params.put("incrementTable", dto.getDbColumnType());
                backCtx.addServiceImplImport(modelId, dto.getDbColumnType().getImportT());
                break;
            }
            dmQueryDTO.setName(dmQueryDTO.getName() + FLOW_INCREMENT_NAME);
            dmQueryDTO.setEntityName(string);
            dmQueryDTO.setImportInfo(dmQueryDTO.getPackageInfo() + "." + string);
            dmQueryDTO.setWriteFilePath(FileUtil.systemPath((String[])new String[]{dmFlowDataModelDTO.getTablePath(), "dto", string + ".java"}));
            dmFlowDataModelDTO.getQueryDtoMap().put(dmQueryDTO.getName(), dmQueryDTO);
            params.put("parameter", string);
            backCtx.addControllerImport(modelId, dmQueryDTO.getImportInfo());
            backCtx.addServiceImport(modelId, dmQueryDTO.getImportInfo());
            backCtx.addServiceImplImport(modelId, dmQueryDTO.getImportInfo());
        } else {
            for (DmQueryFieldDTO dto : dmFlowDataModelDTO.getQueryDtoMap().get(dmFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME).getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                params.put("incrementTable", dto.getDbColumnType());
                break;
            }
            params.put("parameter", dmFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME);
        }
    }

    private static void addIncrementTable(DmMsDataModelDTO dataModelBaseDTO, Map<String, Boolean> slaveTablePlusSave, DmMsDataModel dataModelBase) {
        DmQueryDTO queryDTO = new DmQueryDTO();
        String masterId = dataModelBase.getMasterTable().getId();
        queryDTO.setFtlPath("template/dm/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelBaseDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", DmMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setName(dataModelBaseDTO.getName() + "IncrementTable");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "IncrementTable");
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }
}

