/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.render;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlTransUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.DmCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.code.info.AspectGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.code.info.EntityGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.code.info.MapperGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.code.info.ServiceImplGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmRender;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataSourceUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmRenderUtil;
import com.jxdinfo.hussar.formdesign.dm.util.SqlReturnUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMFLOW_MASTER_SLAVERENDER")
public class DmFlowMsRender
implements DmRender<DmFlowMsDataModel, DmFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmFlowMsRender.class);
    public static final String RENDER = "DMFLOW_MASTER_SLAVERENDER";

    @Override
    public List<DmCodeGenerateInfo> renderCode(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        Map<String, DmQueryDTO> queryDtoMap;
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<DmCodeGenerateInfo> generateInfos = new ArrayList<DmCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        DmMsDataModelDTO DMMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        backCtx.addParam(String.format("publishTemplateDto_%s", modelId), DMMsDataModelDTO.getPublishTemplateDto());
        boolean extension = backCtx.getUseDataModelBase().isExtension();
        DMMsDataModelDTO.setExtension(extension);
        generateInfos.add(this.genEntityCode(DMMsDataModelDTO));
        generateInfos.add(this.genVoCode(DMMsDataModelDTO));
        generateInfos.add(this.genControllerCode(DMMsDataModelDTO));
        generateInfos.add(this.genServiceCode(DMMsDataModelDTO));
        generateInfos.add(this.genServiceImplCode(DMMsDataModelDTO));
        generateInfos.add(this.genMapperCode(DMMsDataModelDTO));
        generateInfos.add(this.genXmlCode(DMMsDataModelDTO, backCtx));
        generateInfos.add(this.genApiCode(DMMsDataModelDTO, baseFile));
        if (AppContextUtil.isHTSZMode() && !AppContextUtil.isExtension() && !backCtx.isRenderPoint()) {
            generateInfos.add(DmRenderUtil.genHookServiceImplCode(DMMsDataModelDTO));
            backCtx.setRenderPoint(true);
        }
        if (ToolUtil.isNotEmpty(queryDtoMap = DMMsDataModelDTO.getQueryDtoMap())) {
            for (Map.Entry<String, DmQueryDTO> queryDTOEntry : queryDtoMap.entrySet()) {
                DmQueryDTO queryDTO = queryDTOEntry.getValue();
                DmCodeGenerateInfo queryCodeGenerateInfo = this.dynamicModelCode(queryDTO, DMMsDataModelDTO);
                if (null == queryCodeGenerateInfo) continue;
                generateInfos.add(queryCodeGenerateInfo);
            }
        }
        Map<String, AspectGenerateInfo> aspectGenerateInfoMap = DMMsDataModelDTO.getAspectGenerateInfoMap();
        if (ToolUtil.isNotEmpty(DMMsDataModelDTO.getAnnotationNames()) && ToolUtil.isNotEmpty(aspectGenerateInfoMap)) {
            for (String annotationName : DMMsDataModelDTO.getAnnotationNames()) {
                generateInfos.add(this.genAnnotationCode(DMMsDataModelDTO, annotationName));
                AspectGenerateInfo aspectGenerateInfo = Optional.ofNullable(aspectGenerateInfoMap.get(aspectGenerateInfoMap.keySet().stream().filter(key -> key.equals(annotationName)).findFirst().orElse(""))).orElseGet(AspectGenerateInfo::new);
                generateInfos.add(this.genAspectCode(DMMsDataModelDTO, annotationName, aspectGenerateInfo));
            }
        }
        Map<String, DmDataModelBase> dataModelBaseMap = DMMsDataModelDTO.getDataModelBaseMap();
        Map<String, DmDataModelBaseDTO> dataModelDtoMap = DMMsDataModelDTO.getDataModelDtoMap();
        if (ToolUtil.isNotEmpty(dataModelBaseMap)) {
            for (String key2 : dataModelBaseMap.keySet()) {
                DmBackCtx newBackCtx = new DmBackCtx();
                DmDataModelBase dmDataModelBase = dataModelBaseMap.get(key2);
                DmDataModelBaseDTO DMDataModelBaseDTO = dataModelDtoMap.get(key2);
                HashMap<String, DmDataModelBaseDTO> map = new HashMap<String, DmDataModelBaseDTO>();
                map.put(key2, DMDataModelBaseDTO);
                newBackCtx.setBaseFile(baseFile);
                newBackCtx.setUseDataModelBase(dmDataModelBase);
                newBackCtx.setUseDataModelDtoMap(map);
                newBackCtx.setRenderPoint(backCtx.isRenderPoint());
                List<DmCodeGenerateInfo> childGenerators = DmModelBeanUtil.getFunctionModelVisitorBean(newBackCtx.getUseDataModelBase().getFunctionType()).render().renderCode(newBackCtx);
                if (!ToolUtil.isNotEmpty(childGenerators)) continue;
                for (DmCodeGenerateInfo childGenerator : childGenerators) {
                    if ("controller".equals(childGenerator.getFileType()) || "js".equals(childGenerator.getFileType())) continue;
                    generateInfos.add(childGenerator);
                }
            }
        }
        return generateInfos;
    }

    private DmCodeGenerateInfo genEntityCode(DmMsDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "model" + File.separator + dataModelBaseDTO.getEntityName() + ".java";
        String filePath = "template/dm/flowbackcode/mscode/entity.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getEntityName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getEntityGenerateInfo())) {
            EntityGenerateInfo entityGenerateInfo = new EntityGenerateInfo();
            entityGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setEntityGenerateInfo(entityGenerateInfo);
        } else {
            dataModelBaseDTO.getEntityGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            Set imports = Optional.ofNullable(dataModelBaseDTO.getEntityGenerateInfo().getImports()).orElseGet(HashSet::new);
            imports.add("com.baomidou.mybatisplus.annotation.TableField");
            dataModelBaseDTO.getEntityGenerateInfo().setImports(imports);
        }
        String newCode = DmBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("entity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getEntityName() + ".java");
        return codeGenerateInfo;
    }

    private DmCodeGenerateInfo genVoCode(DmMsDataModelDTO dto) throws LcdpException {
        String modulePath = dto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dto.getVoName() + ".java";
        String filePath = "template/dm/flowbackcode/mscode/vo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dto.getVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dto.getVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dto.setVoGeneratorInfo(info);
        } else {
            dto.getVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = DmBackRenderUtil.renderTemplate(filePath, dto);
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("vo");
        codeGenerateInfo.setFileId(dto.getId());
        codeGenerateInfo.setFileName(dto.getVoName() + ".java");
        return codeGenerateInfo;
    }

    private DmCodeGenerateInfo genControllerCode(DmMsDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getControllerGenerateInfo())) {
            ControllerGenerateInfo controllerGenerateInfo = new ControllerGenerateInfo();
            controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        } else {
            dataModelDto.getControllerGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getControllerGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(dataModelDto.getImportInfo().get("Entity"));
        imports.add(dataModelDto.getImportInfo().get("Service"));
        dataModelDto.getControllerGenerateInfo().setImports(imports);
        String filePath = "template/dm/flowbackcode/mscode/controller.ftl";
        String newCode = DmBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(PrefixUtil.replacePrefix((String)newCode));
        codeGenerateInfo.setFileType("controller");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getControllerName() + ".java");
        return codeGenerateInfo;
    }

    private DmCodeGenerateInfo genServiceCode(DmMsDataModelDTO dataModelDto) throws LcdpException, IOException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String filePath = "template/dm/flowbackcode/mscode/service.ftl";
        String newCode = DmBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("service");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Service" + ".java");
        return codeGenerateInfo;
    }

    private DmCodeGenerateInfo genServiceImplCode(DmMsDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String filePath = "template/dm/flowbackcode/mscode/service_impl.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getServiceImplGenerateInfo())) {
            ServiceImplGenerateInfo serviceImplGenerateInfo = new ServiceImplGenerateInfo();
            serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        } else {
            dataModelDto.getServiceImplGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getServiceImplGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(DmDataSourceUtil.getDataSourceServiceImpl(dataModelDto.getDataSourceName()));
        imports.add("java.util.List");
        imports.add("java.util.Map");
        imports.add("com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        imports.add("org.springframework.beans.factory.annotation.Autowired");
        dataModelDto.addServiceImplInversion(dataModelDto.getMapperName());
        dataModelDto.getServiceImplGenerateInfo().setImports(imports);
        String newCode = DmBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ServiceImpl" + ".java");
        return codeGenerateInfo;
    }

    private DmCodeGenerateInfo genMapperCode(DmMsDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".java";
        String filePath = "template/dm/flowbackcode/mscode/mapper.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getMapperName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getMapperGenerateInfo())) {
            MapperGenerateInfo mapperGenerateInfo = new MapperGenerateInfo();
            mapperGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setMapperGenerateInfo(mapperGenerateInfo);
        } else {
            dataModelDto.getMapperGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getMapperGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add("org.apache.ibatis.annotations.Param");
        imports.add("java.util.List");
        dataModelDto.getMapperGenerateInfo().setImports(imports);
        String newCode = DmBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("mapper");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".java");
        return codeGenerateInfo;
    }

    private DmCodeGenerateInfo genXmlCode(DmMsDataModelDTO dataModelDto, DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx) throws LcdpException {
        this.structureTranslateXml(dataModelDto, backCtx);
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + "mapping" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".xml";
        String filePath = "template/dm/flowbackcode/mscode/xml.ftl";
        String newCode = DmBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("xml");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".xml");
        return codeGenerateInfo;
    }

    private void structureTranslateXml(DmMsDataModelDTO dataModelDto, DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx) throws LcdpException {
        DmFlowMsDataModel msModelBase = backCtx.getUseDataModelBase();
        Map<String, String> modelAliasName = msModelBase.getModelAliasName();
        HashMap<String, CharSequence> xmlParams = new HashMap<String, CharSequence>();
        xmlParams.put("return", SqlReturnUtil.renderReturn(msModelBase, modelAliasName));
        xmlParams.put("relation", SqlReturnUtil.renderRelation(msModelBase, dataModelDto.getDataModelBaseMap()));
        StringBuilder whereResult = new StringBuilder(128);
        whereResult.append("<where>\n");
        String template = "<if test=\"${obj}.${attr} != '' and ${obj}.${attr} != null\">\n${T}.${rAttr} ${symbol} ${objAttr}\n</if>\n";
        String templateNoEmpty = "<if test=\"${obj}.${attr} != null\">\n${T}.${rAttr} ${symbol} ${objAttr}\n</if>\n";
        String objName = msModelBase.getName();
        List<DmDataModelField> fields = msModelBase.getFields();
        for (DmDataModelField field : fields) {
            String dataType = field.getDataType();
            if ("array".equals(dataType)) continue;
            String sourceFieldName = field.getSourceFieldName();
            String name = field.getName();
            String objAttr = "#{" + objName + "." + name + "}";
            String useTemplate = template;
            if (ToolUtil.isNotEmpty((Object)dataType) && ("date".equals(dataType) || "boolean".equals(dataType) || "int".equals(dataType) || "long".equals(dataType))) {
                useTemplate = templateNoEmpty;
            }
            String where = useTemplate.replace("${obj}", objName).replace("${attr}", name).replace("${rAttr}", sourceFieldName).replace("${symbol}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${objAttr}", objAttr).replace("${T}", String.valueOf(modelAliasName.get(field.getSourceDataModelId())));
            whereResult.append(where);
        }
        whereResult.append("</where>\n");
        xmlParams.put("whereSql", whereResult);
        dataModelDto.addXmlCode(RenderUtil.renderTemplate((String)"template/dm/masterslavebackcode/code/translate_xml.ftl", xmlParams));
    }

    private DmCodeGenerateInfo genAnnotationCode(DmMsDataModelDTO dataModelDto, String annotationName) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "annotation" + File.separator + annotationName + ".java";
        String filePath = "template/dm/flowbackcode/mscode/annotation.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("annotation");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(annotationName);
        return codeGenerateInfo;
    }

    private DmCodeGenerateInfo genApiCode(DmMsDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = DmBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private DmCodeGenerateInfo genAspectCode(DmMsDataModelDTO dataModelDto, String annotationName, AspectGenerateInfo aspectGenerateInfo) throws LcdpException {
        String aspectName = annotationName + NamingStrategy.capitalFirst((String)"aspect");
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "aspect" + File.separator + aspectName + ".java";
        String filePath = "template/dm/flowbackcode/mscode/aspect.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("aspectName", aspectName);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        params.put("aspect", aspectGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("aspect");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(aspectName);
        return codeGenerateInfo;
    }

    public static String renderTemplate(String templatePath, ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }

    private DmCodeGenerateInfo dynamicModelCode(DmQueryDTO queryDTO, DmDataModelBaseDTO dataModelDto) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryDTO)) {
            String writePath = queryDTO.getWriteFilePath();
            String filePath = queryDTO.getFtlPath();
            String newCode = RenderUtil.renderTemplate((String)filePath, queryDTO.getParams());
            DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(queryDTO.getEntityName());
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private DmCodeGenerateInfo genQueryVoCode(DmQueryDTO queryVODto, DmMsDataModelDTO dataModelDto, String modulePath, DmMsDataModel dmMsDataModel) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryVODto)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("queryDto", queryVODto);
            params.put("model", dataModelDto);
            params.put("modelArrayWithPage", dmMsDataModel.getOperations().get(0).getReturnValue());
            String writePath = modulePath + File.separator + "qo" + File.separator + this.upperCase(dmMsDataModel.getOperations().get(0).getReturnValue()) + ".java";
            String filePath = "template/dm/flowbackcode/mscode/queryVo.ftl";
            String newCode = RenderUtil.renderTemplate((String)filePath, params);
            DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(this.upperCase(dmMsDataModel.getOperations().get(0).getReturnValue()));
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private String upperCase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

