/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.element.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmEnclosure;
import com.jxdinfo.hussar.formdesign.dm.function.DmRender;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmTaskMsDataModel
extends DmMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(DmTaskMsDataModel.class);
    public static final String FUNCTION_TYPE = "TASK_MASTER_SLAVE";
    public static final String TASK_KEY = "task";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private DmBaseDataModel task;
    private List<DmDataModelField> flowFields;

    public List<DmDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<DmDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"DM.TASK_MASTER_SLAVE", DmTaskMsDataModel.class);
    }

    public DmBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(DmBaseDataModel task) {
        this.task = task;
    }

    @Override
    public DmTaskMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        DmTaskMsDataModel dmTaskMsDataModel;
        try {
            ArrayList<DmDataModelField> fieldList = new ArrayList<DmDataModelField>();
            dmTaskMsDataModel = (DmTaskMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), DmTaskMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                DmDataModelBase master = DmDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(dmTaskMsDataModel.getName() + "Master");
                dmTaskMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<DmDataModelBase> slaveTables = new ArrayList<DmDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    DmDataModelBase slaveTable = DmDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (DmRelationshipBase relationship : dmTaskMsDataModel.getRelationships()) {
                    if (relationship.getMasterTableId().equals(dmTaskMsDataModel.task.getId())) continue;
                    DmDataModelBase dataModelBase = slaveTables.stream().filter(item -> HussarUtils.equals((Object)item.getId(), (Object)relationship.getSlaveTableId())).findFirst().orElseGet(DmBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    DmDataModelField dmDataModelField = new DmDataModelField();
                    dmDataModelField.setId(UUID.randomUUID().toString());
                    dmDataModelField.setName(dataModelBase.getName());
                    dmDataModelField.setComment(dataModelBase.getComment());
                    dmDataModelField.setSourceDataModelId(dataModelBase.getId());
                    dmDataModelField.setDataType("array");
                    fieldList.add(dmDataModelField);
                }
                dmTaskMsDataModel.setSlaveTables(slaveTables);
            }
            dmTaskMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return dmTaskMsDataModel;
    }

    @Override
    public DmEnclosure<DmDataModelBase> enclosure() throws LcdpException {
        return DmModelBeanUtil.getEnclosureBean("DM", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public DmRender<DmDataModelBase, DmDataModelBaseDTO> render() throws LcdpException {
        return DmModelBeanUtil.getRenderBean("DM", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<DmDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<DmDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<DmDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<DmDataModelField>> contrastVOS = this.task.modelContrastTable((FieldsContrastParam<DmDataModelField>)fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable((FieldsContrastParam<DmDataModelField>)fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<DmDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId, Map<String, List<JSONObject>> extFields, List<JSONObject> extSlaveTables) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId, extFields, extSlaveTables).getDetails().get(0));
        details.addAll(super.checkTableContrast(modelId, extFields, extSlaveTables).getDetails());
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        this.task.updateIndexForSystemTask(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public Boolean updateIndex(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        return this.task.updateIndexForSystemTask(fieldsContrastParam);
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.getMasterTable().getId(), "T2");
        List<DmRelationshipBase> relationships = super.getRelationships();
        if (ToolUtil.isNotEmpty(relationships) && !relationships.isEmpty()) {
            for (int i = 0; i < relationships.size(); ++i) {
                DmRelationshipBase relationship = relationships.get(i);
                if (relationship.getSlaveTableId().equals(super.getId())) continue;
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public void customOption(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx) throws LcdpException {
        DmModelBeanUtil.getCustomOperationBean("DM", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() throws LcdpException {
        Map<String, Map<String, Object>> slaveModelInfo = super.getSlaveModelInfo();
        HashMap<String, String> val = new HashMap<String, String>();
        val.put("name", this.task.getName());
        val.put("sourceDataModelName", this.task.getSourceDataModelName());
        val.put("type", TASK_KEY);
        slaveModelInfo.put(this.task.getId(), val);
        return slaveModelInfo;
    }
}

