/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMFLOWTemplatePrint")
public class DmFlowTemplatePrintVisitor
implements DmOperationVisitor<DmFlowDataModel, DmFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmFlowTemplatePrintVisitor.class);
    private static final String templatePrintDTO = "com.jxdinfo.hussar.common.formDesign.TemplatePrintDTO";
    private static final String templatePrintService = "com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService";
    public static final String OPERATION_NAME = "DMFLOWTemplatePrint";

    @Override
    public void visit(DmBackCtx<DmFlowDataModel, DmFlowDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        DmFlowDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = useDataModelBase.getId();
        DmFlowDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        String controllerPath = "template/dm/flowbackcode/baseflowbackcode/templatePrint/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/dm/flowbackcode/baseflowbackcode/templatePrint/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/dm/flowbackcode/baseflowbackcode/templatePrint/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, "ISysTemplatePrintInfoService");
        backCtx.addServiceImplInversion(modelId, "ISysTemplatePrintInfoHookStrategyService");
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6a21\u677f\u6253\u5370");
        backCtx.addApi(modelId, DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(DmBackCtx<DmFlowDataModel, DmFlowDataModelDTO> backCtx, String modelId, DmFlowDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, templatePrintDTO);
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, templatePrintDTO);
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, templatePrintDTO);
        backCtx.addServiceImplImport(modelId, templatePrintService);
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoHookStrategyService");
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
    }

    private Map<String, Object> initParams(DmDataModelOperation dataModelOperation, DmFlowDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6a21\u677f\u6253\u5370");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }
}

