/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.baseflow.util.DmFlowBaseUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMFLOWPrevNodeReject")
public class DmFlowPrevNodeRejectCodeVisitor
implements DmOperationVisitor<DmFlowDataModel, DmFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmFlowPrevNodeRejectCodeVisitor.class);
    public static final String OPERATION_NAME = "DMFLOWPrevNodeReject";

    @Override
    public void visit(DmBackCtx<DmFlowDataModel, DmFlowDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        DmFlowDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        DmDataModelFieldDto keyField = useDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> params = this.initParams(dataModelOperation, useDataModelDTO);
        this.renderImport(backCtx, modelId, useDataModelDTO);
        String controllerPath = "template/dm/flowbackcode/baseflowbackcode/prevnodereject/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, params));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/dm/flowbackcode/baseflowbackcode/prevnodereject/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, params));
        String fillCode = DmFlowBaseUtil.renderFillCode(useDataModelDTO);
        if (fillCode != null) {
            params.put("fillCode", fillCode);
        }
        String serviceImplPath = "template/dm/flowbackcode/baseflowbackcode/prevnodereject/service_impl.ftl";
        params.put("isRemote", VfgModeTool.isRemote());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, params));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", useDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9");
        backCtx.addApi(useDataModelDTO.getId(), DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(DmBackCtx<DmFlowDataModel, DmFlowDataModelDTO> backCtx, String modelId, DmFlowDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "org.springframework.aop.framework.AopContext");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
    }

    private Map<String, Object> initParams(DmDataModelOperation dataModelOperation, DmFlowDataModelDTO dataModelBaseDTO) {
        Map<String, Object> params = dataModelOperation.getParams();
        params.put("table", dataModelBaseDTO);
        params.put("dataSourceAnnotation", DmDataSourceUtil.getMethodDataSourceAnnotation());
        params.put("parameter", dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getEntityName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9");
            params.put("exegesis", dataModelOperation.getExegesis());
        }
        return params;
    }
}

