/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.customOption.task;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.DmCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmCustomOperation;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Component;

@Component(value="DMTASK_MASTER_SLAVECUSTOM_OPTION")
public class DmTaskMsCustomOption
implements DmCustomOperation<DmTaskMsDataModel, DmTaskMsDataModelDTO> {
    public static final String CUSTOM_OPTION = "DMTASK_MASTER_SLAVECUSTOM_OPTION";

    @Override
    public void publishCustomOption(DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> backCtx) throws LcdpException {
        this.publishTaskDataBackFill(backCtx);
    }

    private void publishTaskDataBackFill(DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> backCtx) throws LcdpException {
        if (ToolUtil.isEmpty((Object)backCtx.getParams()) || ToolUtil.isEmpty(backCtx.getParams().get("identity"))) {
            return;
        }
        DmTaskMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        DmTaskMsDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        if (ToolUtil.isEmpty(useDataModelDTO.getCustomCodeGenerateInfo())) {
            useDataModelDTO.setCustomCodeGenerateInfo(new HashMap<String, DmCodeGenerateInfo>());
        }
        useDataModelDTO.getCustomCodeGenerateInfo().put(useDataModelBase.getId(), this.genTaskDataBackFillCode(backCtx));
    }

    private DmCodeGenerateInfo genTaskDataBackFillCode(DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> backCtx) throws LcdpException {
        DmTaskMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        DmTaskMsDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        DmBaseDataModel task = useDataModelBase.getTask();
        String taskId = task.getId();
        DmDataModelBaseDTO userTaskModelDTO = useDataModelDTO.getDataModelDtoMap().get(taskId);
        DmDataModelBaseDTO userBusinessModelDTO = useDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        String modulePath = useDataModelDTO.getTablePath().toLowerCase();
        String fileName = userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl";
        String writePath = modulePath + File.separator + "Task".toLowerCase() + File.separator + fileName + ".java";
        String dataBackFillPath = "template/dm/taskbackcode/mscode/task_data_backfill_service_impl.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("package", userTaskModelDTO.getPackageInfo().get("Task"));
        params.put("className", fileName);
        params.put("identity", backCtx.getParams().get("identity"));
        TreeSet<String> imports = new TreeSet<String>();
        params.put("implementServiceNameImportInfo", "com.jxdinfo.hussar.workflow.task.model.service.TaskModelService");
        params.put("implementServiceName", "TaskModelService");
        params.put("ProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto");
        params.put("DeletedProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto");
        params.put("ProcessNodeInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto");
        params.put("CompleteTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto");
        params.put("UpdateTaskUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto");
        params.put("WorkflowUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto");
        params.put("TaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto");
        params.put("DeletedTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto");
        params.put("taskEntity", userTaskModelDTO.getEntityName());
        params.put("taskEntityImportInfo", userTaskModelDTO.getImportInfo().get("Entity"));
        params.put("taskServiceName", userTaskModelDTO.getServiceName());
        params.put("taskServiceImportInfo", userTaskModelDTO.getImportInfo().get("Service"));
        params.put("businessServiceName", userBusinessModelDTO.getServiceName());
        params.put("businessServiceImportInfo", userBusinessModelDTO.getImportInfo().get("Service"));
        params.put("businessEntity", userBusinessModelDTO.getEntityName());
        params.put("businessEntityImportInfo", userBusinessModelDTO.getImportInfo().get("Entity"));
        HashMap<String, String> businessColumn = new HashMap<String, String>();
        List<DmDataModelFieldDto> businessFields = userBusinessModelDTO.getFields();
        for (DmDataModelFieldDto dmDataModelFieldDto : businessFields) {
            if (!ToolUtil.isNotEmpty((Object)dmDataModelFieldDto.getFill())) continue;
            businessColumn.put(dmDataModelFieldDto.getFill(), dmDataModelFieldDto.getName());
            if (!"primary".equals(dmDataModelFieldDto.getFill())) continue;
            params.put("primaryType", dmDataModelFieldDto.getColumnType().getType());
            if (!ToolUtil.isNotEmpty((Object)dmDataModelFieldDto.getColumnType().getImportT())) continue;
            imports.add(dmDataModelFieldDto.getColumnType().getImportT());
        }
        params.put("businessColumn", businessColumn);
        List<DmDataModelField> fields = task.getFields();
        for (DmDataModelField field : fields) {
            if ("foreign".equals(field.getUsage())) {
                params.put("taskForeign", field.getSourceFieldName());
            }
            if (!"taskId".equals(field.getName())) continue;
            params.put("taskTaskId", field.getSourceFieldName());
        }
        params.put("dataSourceName", useDataModelBase.getDataSourceName());
        params.put("imports", imports);
        DmCodeGenerateInfo dmCodeGenerateInfo = new DmCodeGenerateInfo();
        dmCodeGenerateInfo.setFileWriteRelativePath(writePath);
        dmCodeGenerateInfo.setFileContent(RenderUtil.renderTemplate((String)dataBackFillPath, params));
        dmCodeGenerateInfo.setFileType("serviceImpl");
        dmCodeGenerateInfo.setFileId(useDataModelDTO.getId());
        dmCodeGenerateInfo.setFileName(userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl" + ".java");
        return dmCodeGenerateInfo;
    }
}

