/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.PropertyType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableIndex;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.dataset.ValueObjectProperty;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.function.DmModelFunction;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmEditDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.index.DmDataModelIndex;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class DmDataModelUtil {
    public static final String SLAVE_PAGE_VO = "SlavePageVO";
    public static final String PAGE_VO = "PageVO";
    private static final Pattern TPATTERN = Pattern.compile("[A-Z0-9]");

    public static DmDataModelBase transfer(DataModelBase dataModelBase) throws LcdpException {
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        return modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)dataModelBase.getId()));
    }

    public static DmDataModelBase transfer(String jsonData) throws LcdpException {
        DataModelBase dataModel = (DataModelBase)JSONObject.parseObject((String)jsonData, DataModelBase.class);
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        return modelFunction.parseDataModel(JSONObject.parseObject((String)jsonData));
    }

    public static DmDataModelBase transfer(JSONObject jsonObject) throws LcdpException {
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(String.valueOf(jsonObject.get((Object)"functionType")));
        return modelFunction.parseDataModel(jsonObject);
    }

    public static DmDataModelField getModelFieldById(List<DmDataModelField> fields, String fieldId) {
        return fields.stream().filter(field -> field.getId().equals(fieldId)).findFirst().orElseGet(DmDataModelField::new);
    }

    public static void addQueryPageVo(DmDataModelBaseDTO dataModelBaseDTO) {
        DmQueryDTO queryDTO = new DmQueryDTO();
        queryDTO.setFtlPath("template/dm/backcode/code/page.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }

    public static void addSlaveQueryPageVo(DmDataModelBaseDTO dataModelBaseDTO, DmDataModelOperation dataModelOperation) {
        DmQueryDTO queryDTO = new DmQueryDTO();
        queryDTO.setFtlPath("template/dm/backcode/code/slave_page.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + SLAVE_PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + SLAVE_PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }

    public static String camelToUnderLine(String str) {
        Matcher matcher = TPATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static void addQueryPageViewVo(DmDataModelBaseDTO dataModelBaseDTO) {
        DmDataModelUtil.addQueryPageVo(dataModelBaseDTO);
    }

    public static void addQueryPageMsVo(DmDataModelBaseDTO msdataModelBaseDTO) {
        DmDataModelUtil.addQueryPageVo(msdataModelBaseDTO);
    }

    public static DmQueryDTO getQueryDto(DataSet dataSet, DmDataModelBaseDTO dataModelDTO) {
        DmQueryDTO queryDto;
        block4: {
            block3: {
                queryDto = new DmQueryDTO();
                queryDto.setId(dataSet.getId());
                queryDto.setName(EnclosureUtil.processName((String)dataSet.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
                queryDto.setComment(dataSet.getComment());
                Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
                queryDto.setPackageInfo(packageInfo.get("dto"));
                queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataSet.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
                queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
                queryDto.setFtlPath("template/dm/backcode/code/queryDto.ftl");
                HashMap<String, Object> params = new HashMap<String, Object>();
                HashMap<String, Boolean> table = new HashMap<String, Boolean>();
                table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
                params.put("queryDto", queryDto);
                params.put("table", table);
                queryDto.setParams(params);
                queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
                if (!dataSet.getDataSetObject().getObjectType().equals(ComponentData.DataSetObjectTypeEnum.DATA_MODEL.getValue())) break block3;
                queryDto.setDataModel(true);
                if (!ToolUtil.isNotEmpty(dataModelDTO.getFields())) break block4;
                for (DmDataModelFieldDto field : dataModelDTO.getFields()) {
                    DmQueryFieldDTO queryVOFieldDto = new DmQueryFieldDTO();
                    queryVOFieldDto.setComment(field.getComment());
                    queryVOFieldDto.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)field.getColumnType().getType()));
                    queryVOFieldDto.setPropertyName(field.getName());
                    queryDto.addVOField(queryVOFieldDto);
                }
                break block4;
            }
            if (ToolUtil.isNotEmpty((Object)dataSet.getDataSetObject().getProperties())) {
                List<DmQueryFieldDTO> queryVOFields = DmDataModelUtil.addQueryVOField(dataSet.getDataSetObject().getProperties(), queryDto);
                for (DmQueryFieldDTO queryVOField : queryVOFields) {
                    queryDto.addVOField(queryVOField);
                }
            }
        }
        return queryDto;
    }

    public static DmQueryDTO getFilterDto(DmDataModelBaseDTO dataModelDTO) {
        DmQueryDTO queryDto = new DmQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setImports(Collections.singleton(dataModelDTO.getImportInfo().get("Entity")));
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setFtlPath("template/dm/backcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("queryDto", queryDto);
        params.put("table", table);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    public static DmQueryDTO getTotalQueryDto(DmDataModelBaseDTO dataModelDTO) {
        DmQueryDTO queryDto = new DmQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelDTO.getName() + "TotalQuery"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setFtlPath("template/backcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("queryDto", queryDto);
        params.put("table", table);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    public static List<DmQueryFieldDTO> addQueryVOField(List<ValueObjectProperty> properties, DmQueryDTO queryDto) {
        ArrayList<DmQueryFieldDTO> children = new ArrayList<DmQueryFieldDTO>();
        for (ValueObjectProperty property : properties) {
            DmQueryFieldDTO queryVOFieldDto = new DmQueryFieldDTO();
            queryVOFieldDto.setComment(property.getComment());
            queryVOFieldDto.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)property.getBaseDataType()));
            queryVOFieldDto.setType(property.getBaseDataType());
            queryVOFieldDto.setPropertyName(property.getName());
            if (ToolUtil.isNotEmpty((Object)property.getProperties())) {
                queryVOFieldDto.setChildren(DmDataModelUtil.addQueryVOField(property.getProperties(), queryDto));
            }
            children.add(queryVOFieldDto);
            if (null == queryVOFieldDto.getDbColumnType() || null == queryVOFieldDto.getDbColumnType().getImportT()) continue;
            queryDto.addImport(queryVOFieldDto.getDbColumnType().getImportT());
        }
        return children;
    }

    public static PropertyType getEntityPropertyType(String type, DmDataModelBaseDTO dataModelDto) {
        PropertyType propertyType = null;
        if (ToolUtil.isNotEmpty((Object)type)) {
            propertyType = new PropertyType();
            propertyType.setImportT(dataModelDto.getImportInfo().get("Entity"));
            String modelName = dataModelDto.getEntityName();
            if (type.equals("array")) {
                propertyType.setType("List<${model}>".replace("${model}", modelName));
            } else if (type.equals("object")) {
                propertyType.setType(modelName);
            }
        }
        return propertyType;
    }

    public static ContrastVO<DmDataModelField> contrastWith(List<TableField> tableFields, List<DmDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        List<Object> addFields = new ArrayList();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList delFields = new ArrayList();
        ArrayList<DmDataModelField> modifyFields = new ArrayList<DmDataModelField>();
        HashMap<String, DmDataModelField> fieldMap = new HashMap<String, DmDataModelField>();
        for (DmDataModelField field : modelFields) {
            fieldMap.put(field.getSourceFieldName(), field);
        }
        for (TableField tableField : tableFields) {
            if (!ToolUtil.isNotEmpty(fieldMap.get(tableField.getName()))) continue;
            DmDataModelField field = (DmDataModelField)((Object)fieldMap.get(tableField.getName()));
            fieldMap.remove(field.getSourceFieldName());
            addTableFields.remove(tableField);
            if (field.getSourceDataType().equalsIgnoreCase(tableField.getType()) && field.getDataIsEmpty() == tableField.getDataIsEmpty() && field.getDataLength() == tableField.getDataLength() && field.getDataDot() == tableField.getDataDot() && HussarUtils.equals((Object)field.getComment(), (Object)tableField.getComment()) && "primary".equals(field.getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableField.getPrimarys())) continue;
            modifyFields.add(DmDataModelUtil.tabTransmodelOne(tableField, field.getId()));
        }
        if (fieldMap.size() > 0) {
            delFields.addAll(fieldMap.values());
        }
        addFields = DmDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<DmDataModelField> pushContrastWith(List<TableField> tableFields, List<DmDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        List<Object> addFields = new ArrayList();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<DmDataModelField> delFields = new ArrayList<DmDataModelField>();
        ArrayList<DmDataModelField> modifyFields = new ArrayList<DmDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().toUpperCase().equals(tableFields.get(j).getName().toUpperCase())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(DmDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        addFields = DmDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<DmDataModelField> contrastWithView(List<TableField> tableFields, List<DmDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<DmDataModelField> delFields = new ArrayList<DmDataModelField>();
        ArrayList<DmDataModelField> modifyFields = new ArrayList<DmDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equalsIgnoreCase(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot()) break;
                modifyFields.add(DmDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<DmDataModelField> addFields = DmDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<DmDataModelField> contrastWithIgnoreCase(List<TableField> tableFields, List<DmDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<DmDataModelField> delFields = new ArrayList<DmDataModelField>();
        ArrayList<DmDataModelField> modifyFields = new ArrayList<DmDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot()) break;
                modifyFields.add(DmDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<DmDataModelField> addFields = DmDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<DmDataModelField> mcontrastWith(List<TableField> tableFields, List<DmDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<DmDataModelField> addFields = new ArrayList<DmDataModelField>();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<DmDataModelField> modifyFields = new ArrayList<DmDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)modelFields.get(i).getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(modelFields.get(i));
            }
            if (flag) continue;
            addFields.add(modelFields.get(i));
        }
        List<DmDataModelField> delFields = DmDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastIndexVO<DmDataModelIndex> contrastIndexWith(List<TableIndex> tableIndexs, List<DmDataModelIndex> modelIndexs, TableCorrespond modelFislds) {
        boolean flag;
        ContrastIndexVO index = new ContrastIndexVO();
        ArrayList<DmDataModelIndex> addIndexs = new ArrayList<DmDataModelIndex>();
        ArrayList<DmDataModelIndex> delIndexs = new ArrayList<DmDataModelIndex>();
        if (!HussarUtils.isEmpty(tableIndexs)) {
            if (!HussarUtils.isEmpty(modelIndexs)) {
                ArrayList<TableIndex> addTableIndexs = new ArrayList<TableIndex>();
                CollectionUtils.addAll(addTableIndexs, (Object[])new Object[tableIndexs.size()]);
                Collections.copy(addTableIndexs, tableIndexs);
                for (int i = 0; i < modelIndexs.size(); ++i) {
                    flag = false;
                    for (int j = 0; j < tableIndexs.size(); ++j) {
                        if (!tableIndexs.get(j).getIndexName().equalsIgnoreCase(modelIndexs.get(i).getIndexName())) continue;
                        flag = true;
                        addTableIndexs.remove(tableIndexs.get(j));
                        if (modelIndexs.get(i).isChkUnique() == (tableIndexs.get(j).getIsNonUnique() == 0) && modelIndexs.get(i).getColumnName().equals(tableIndexs.get(j).getColumnName())) break;
                        delIndexs.add(modelIndexs.get(i));
                        addIndexs.add(DmDataModelUtil.tabTransmodelIndexOne(tableIndexs.get(j), modelIndexs.get(i).getIndexName()));
                    }
                    if (flag) continue;
                    delIndexs.add(modelIndexs.get(i));
                }
                addIndexs.addAll(DmDataModelUtil.tabTransmodelIndex(addTableIndexs));
            } else {
                addIndexs.addAll(DmDataModelUtil.tabTransmodelIndex(tableIndexs));
            }
        } else if (!HussarUtils.isEmpty(modelIndexs)) {
            delIndexs.addAll(modelIndexs);
        }
        if (HussarUtils.isNotEmpty((Object)modelFislds)) {
            List modifyFields;
            ArrayList fields = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)modelFislds.getAddFields())) {
                fields.addAll(JSONArray.parseArray((String)modelFislds.getAddFields(), DmDataModelField.class));
            }
            if (HussarUtils.isNotEmpty((Object)modelFislds.getDelFields())) {
                fields.addAll(JSONArray.parseArray((String)modelFislds.getDelFields(), DmDataModelField.class));
            }
            if (HussarUtils.isNotEmpty((Object)(modifyFields = JSONArray.parseArray((String)modelFislds.getModifyFields(), DmEditDataModelField.class)))) {
                fields.addAll(modifyFields.stream().map(DmEditDataModelField::getNewField).collect(Collectors.toList()));
            }
            flag = false;
            if (HussarUtils.isNotEmpty(fields) && HussarUtils.isNotEmpty(delIndexs)) {
                Iterator iterator = delIndexs.iterator();
                while (iterator.hasNext()) {
                    DmDataModelIndex delIndex = (DmDataModelIndex)((Object)iterator.next());
                    for (DmDataModelField field : fields) {
                        if (!field.getSourceFieldName().equals(delIndex.getColumnName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        iterator.remove();
                        continue;
                    }
                    flag = false;
                }
            }
            if (HussarUtils.isNotEmpty(fields) && HussarUtils.isNotEmpty(addIndexs)) {
                Iterator iterator = addIndexs.iterator();
                while (iterator.hasNext()) {
                    DmDataModelIndex addIndex = (DmDataModelIndex)((Object)iterator.next());
                    for (DmDataModelField field : fields) {
                        if (!field.getSourceFieldName().equals(addIndex.getColumnName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        iterator.remove();
                        continue;
                    }
                    flag = false;
                }
            }
        }
        index.setAddIndexs(addIndexs);
        index.setDelIndexs(delIndexs);
        return index;
    }

    public static ContrastIndexVO<DmDataModelIndex> mcontrastIndexWith(List<TableIndex> tableIndexs, List<DmDataModelIndex> modelIndexs) {
        ContrastIndexVO index = new ContrastIndexVO();
        ArrayList<DmDataModelIndex> addIndexs = new ArrayList<DmDataModelIndex>();
        ArrayList<DmDataModelIndex> delIndexs = new ArrayList<DmDataModelIndex>();
        if (!HussarUtils.isEmpty(modelIndexs)) {
            if (!HussarUtils.isEmpty(tableIndexs)) {
                ArrayList<TableIndex> addTableIndexs = new ArrayList<TableIndex>();
                CollectionUtils.addAll(addTableIndexs, (Object[])new Object[tableIndexs.size()]);
                Collections.copy(addTableIndexs, tableIndexs);
                for (int i = 0; i < modelIndexs.size(); ++i) {
                    boolean flag = false;
                    for (int j = 0; j < tableIndexs.size(); ++j) {
                        if (!tableIndexs.get(j).getIndexName().equalsIgnoreCase(modelIndexs.get(i).getIndexName())) continue;
                        flag = true;
                        addTableIndexs.remove(tableIndexs.get(j));
                        if (modelIndexs.get(i).isChkUnique() == (tableIndexs.get(j).getIsNonUnique() == 0) && modelIndexs.get(i).getColumnName().equals(tableIndexs.get(j).getColumnName())) break;
                        delIndexs.add(DmDataModelUtil.tabTransmodelIndexOne(tableIndexs.get(j), modelIndexs.get(i).getIndexName()));
                        addIndexs.add(modelIndexs.get(i));
                    }
                    if (flag) continue;
                    addIndexs.add(modelIndexs.get(i));
                }
                delIndexs.addAll(DmDataModelUtil.tabTransmodelIndex(addTableIndexs));
            } else {
                addIndexs.addAll(modelIndexs);
            }
        } else if (!HussarUtils.isEmpty(tableIndexs)) {
            delIndexs.addAll(DmDataModelUtil.tabTransmodelIndex(tableIndexs));
        }
        index.setAddIndexs(addIndexs);
        index.setDelIndexs(delIndexs);
        return index;
    }

    public static List<DmDataModelField> tabTransmodel(List<TableField> tableFields) {
        ArrayList<DmDataModelField> modelFields = new ArrayList<DmDataModelField>();
        tableFields.forEach(tab -> {
            DmDataModelField field = new DmDataModelField();
            field.setSourceFieldName(tab.getName());
            field.setDataIsEmpty(tab.getDataIsEmpty());
            field.setDataLength(tab.getDataLength());
            field.setDataDot(tab.getDataDot());
            field.setComment(tab.getComment());
            field.setSourceDataType(tab.getType().toUpperCase());
            if ("PRI".equals(tab.getPrimarys())) {
                field.setUsage("primary");
            }
            modelFields.add(field);
        });
        return modelFields;
    }

    public static DmDataModelField tabTransmodelOne(TableField tableFields, String id) {
        DmDataModelField field = new DmDataModelField();
        field.setId(id);
        field.setSourceFieldName(tableFields.getName());
        field.setDataIsEmpty(tableFields.getDataIsEmpty());
        field.setDataLength(tableFields.getDataLength());
        field.setDataDot(tableFields.getDataDot());
        field.setComment(tableFields.getComment());
        if ("PRI".equals(tableFields.getPrimarys())) {
            field.setUsage("primary");
        }
        field.setSourceDataType(tableFields.getType().toUpperCase());
        return field;
    }

    public static List<DmDataModelIndex> tabTransmodelIndex(List<TableIndex> tableIndexs) {
        ArrayList<DmDataModelIndex> modelIndexs = new ArrayList<DmDataModelIndex>();
        if (tableIndexs != null) {
            tableIndexs.forEach(tab -> {
                DmDataModelIndex index = new DmDataModelIndex();
                index.setIndexName(tab.getIndexName().toUpperCase());
                index.setChkUnique(tab.getIsNonUnique() == 0);
                index.setTableSchema(tab.getTableSchema());
                index.setColumnName(tab.getColumnName().toUpperCase());
                index.setIndexType(tab.getIndexType());
                index.setTableName(tab.getTableName().toUpperCase());
                modelIndexs.add(index);
            });
        }
        return modelIndexs;
    }

    public static DmDataModelIndex tabTransmodelIndexOne(TableIndex tableIndex, String indexName) {
        DmDataModelIndex index = new DmDataModelIndex();
        index.setIndexName(indexName.toUpperCase());
        index.setChkUnique(tableIndex.getIsNonUnique() == 0);
        index.setTableSchema(tableIndex.getTableSchema());
        index.setColumnName(tableIndex.getColumnName().toUpperCase());
        index.setIndexType(tableIndex.getIndexType());
        index.setTableName(tableIndex.getTableName().toUpperCase());
        return index;
    }
}

