/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.task.masterslavetask.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DmTaskMsUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";

    private DmTaskMsUtil() {
    }

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> backCtx) throws LcdpException {
        DmTaskMsUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> backCtx) {
        DmTaskMsUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        DmMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        DmMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        DmDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<DmRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        DmDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        if (params.get("logicallyDelete") != null) {
            for (DmRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.init();
            }
        } else {
            for (DmRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = DmTaskMsUtil.getDelStr(relationshipDtoList, masterDto);
        DmTaskMsUtil.renderTransaction(backCtx, params);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (DmRelationshipDTO dmRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            DmDataModelBaseDTO dmDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(dmRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, dmDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, dmDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, dmDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        DmMsDataModelDTO dmMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<DmRelationshipDTO> relationshipDtoList = dmMsDataModelDTO.getRelationshipDtoList();
        DmDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, DmDataModelBaseDTO> dataModelDtoMap = dmMsDataModelDTO.getDataModelDtoMap();
        DmDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        DmTaskMsUtil.renderTransaction(backCtx, controllerParams);
        String masterFillCode = DmTaskMsUtil.renderFillCode(backCtx, mainDataModelDto, dmMsDataModelDTO);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (DmRelationshipDTO dmRelationshipDTO : relationshipDtoList) {
                List<DmRelationshipFieldDTO> dmRelationshipFieldDTOS;
                String slaveTableId = dmRelationshipDTO.getSlaveTableId();
                String relateModelType = dmRelationshipDTO.getRelateModelType();
                DmDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = DmTaskMsUtil.renderFillCode(backCtx, slaveModelDto, dmMsDataModelDTO);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                if (slaveFillCode != null) {
                    dmRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(dmRelationshipFieldDTOS = dmRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
            controllerParams.put("slaveFillCodeList", slaveFillCodeList);
        }
    }

    private static void renderTransaction(DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> backCtx, Map<String, Object> controllerParams) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> backCtx, DmDataModelBaseDTO dataModelBaseDTO, DmMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (DmDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<DmRelationshipDTO> relationshipDtoList, DmDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (DmRelationshipDTO relationtMap : relationshipDtoList) {
            List<DmRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            DmRelationshipFieldDTO dmRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(dmRelationshipFieldDTO.getSlaveFieldCap()).append(",idList));\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(dmRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                DmRelationshipFieldDTO dmRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(dmRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(dmRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(dmRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(DmTaskMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(dmRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(dmRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(DmTaskMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(dmRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static void transferControllerCode(DmDataModelBaseDTO fromDataModelBaseDTO, DmDataModelBaseDTO toDataModelBaseDTO) {
        ControllerGenerateInfo businessController = fromDataModelBaseDTO.getControllerGenerateInfo();
        ControllerGenerateInfo taskController = toDataModelBaseDTO.getControllerGenerateInfo();
        if (HussarUtils.isEmpty((Object)taskController)) {
            taskController = new ControllerGenerateInfo();
            toDataModelBaseDTO.setControllerGenerateInfo(taskController);
        }
        if (HussarUtils.isNotEmpty((Object)businessController)) {
            if (HussarUtils.isNotEmpty(businessController.getImports())) {
                if (HussarUtils.isEmpty(taskController.getImports())) {
                    taskController.setImports(new HashSet<String>());
                }
                taskController.getImports().addAll(businessController.getImports());
            }
            if (HussarUtils.isNotEmpty(businessController.getInversions())) {
                if (HussarUtils.isEmpty(taskController.getInversions())) {
                    taskController.setInversions(new HashSet<String>());
                }
                taskController.getInversions().addAll(businessController.getInversions());
            }
            if (HussarUtils.isNotEmpty(businessController.getInversionsWithName())) {
                if (HussarUtils.isEmpty(taskController.getInversionsWithName())) {
                    taskController.setInversionsWithName(new HashMap<String, String>());
                }
                taskController.getInversionsWithName().putAll(businessController.getInversionsWithName());
            }
            if (HussarUtils.isNotEmpty(businessController.getCodes())) {
                if (HussarUtils.isEmpty(taskController.getCodes())) {
                    taskController.setCodes(new ArrayList<String>());
                }
                taskController.getCodes().addAll(businessController.getCodes());
            }
        }
        if (HussarUtils.isNotEmpty(fromDataModelBaseDTO.getApis())) {
            if (HussarUtils.isEmpty(toDataModelBaseDTO.getApis())) {
                toDataModelBaseDTO.setApis(new ArrayList<String>());
            }
            toDataModelBaseDTO.getApis().addAll(fromDataModelBaseDTO.getApis());
        }
    }
}

