/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.element.task;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmEnclosure;
import com.jxdinfo.hussar.formdesign.dm.function.DmRender;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class DmTaskDataModel
extends DmBaseDataModel {
    public static final String FUNCTION_TYPE = "TASK";
    public static final String TASK_KEY = "task";
    public static final String BUSINESS_ID = "businessId";
    private DmBaseDataModel task;
    private List<DmRelationshipBase> relationships;
    private List<DmDataModelField> flowFields;

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"DM.TASK", DmTaskDataModel.class);
    }

    public DmBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(DmBaseDataModel task) {
        this.task = task;
    }

    public List<DmRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<DmRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<DmDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<DmDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    public DmTaskDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        DmTaskDataModel dmTaskDataModel;
        try {
            dmTaskDataModel = (DmTaskDataModel)JSONObject.parseObject((String)jsonObject.toString(), DmTaskDataModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return dmTaskDataModel;
    }

    @Override
    public DmEnclosure<DmDataModelBase> enclosure() throws LcdpException {
        return DmModelBeanUtil.getEnclosureBean("DM", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public DmRender<DmDataModelBase, DmDataModelBaseDTO> render() throws LcdpException {
        return DmModelBeanUtil.getRenderBean("DM", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<DmDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<DmDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<DmDataModelField>> modelContrastTable(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<DmDataModelField>> contrastVOS = this.task.modelContrastTable(fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable(fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastIndexVO> tableContrastModelIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModelIndex(fieldsContrastParam);
    }

    @Override
    public List<ContrastIndexVO> modelContrastTableIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTableIndex(fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<DmDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId).getDetails().get(0));
        details.add(super.checkTableContrast(modelId).getDetails().get(0));
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "t");
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public void customOption(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx) throws LcdpException {
        DmModelBeanUtil.getCustomOperationBean("DM", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }
}

