/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.provider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelSyncProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class DmModelSyncProvider
implements DataModelSyncProvider<DmDataModelField> {
    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"DMSYNC", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public List<ContrastVO<DmDataModelField>> tableContrastModel(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws LcdpException, IOException {
        DmDataModelBase dmDataModelBase = DmDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)fieldsContrastParam.getModelId()));
        this.setExtFields(fieldsContrastParam, dmDataModelBase);
        this.setSlaveTables(fieldsContrastParam, dmDataModelBase);
        List<ContrastVO<DmDataModelField>> contrastVOS = dmDataModelBase.tableContrastModel(fieldsContrastParam);
        this.setFieldsType(contrastVOS, dmDataModelBase);
        return contrastVOS;
    }

    private void setFieldsType(List<ContrastVO<DmDataModelField>> contrastVOS, DmDataModelBase dmDataModelBase) {
        if (AppContextUtil.isExtension() && !dmDataModelBase.isExtension()) {
            for (ContrastVO<DmDataModelField> contrastVO : contrastVOS) {
                List modifyFields;
                List addFields = contrastVO.getAddFields();
                if (HussarUtils.isNotEmpty((Object)addFields)) {
                    for (DmDataModelField addField : addFields) {
                        addField.setExtension(true);
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)(modifyFields = contrastVO.getModifyFields()))) continue;
                for (DmDataModelField modelField : modifyFields) {
                    modelField.setExtension(true);
                }
            }
        }
    }

    private void setExtFields(FieldsContrastParam<DmDataModelField> fieldsContrastParam, DmDataModelBase dmDataModelBase) throws LcdpException {
        JSONObject dataModelJsonExt;
        Object extFieldsObj;
        if (AppContextUtil.isExtension() && !dmDataModelBase.isExtension() && HussarUtils.isNotEmpty((Object)(extFieldsObj = (dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)dmDataModelBase.getId())).get((Object)"extFields")))) {
            Map extFields = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)extFieldsObj), (TypeReference)new TypeReference<Map<String, List<JSONObject>>>(){}, (Feature[])new Feature[0]);
            fieldsContrastParam.setExtFields(extFields);
        }
    }

    private Map<String, List<JSONObject>> getExtFields(DmDataModelBase dmDataModelBase) throws LcdpException {
        JSONObject dataModelJsonExt;
        Object extFieldsObj;
        if (AppContextUtil.isExtension() && !dmDataModelBase.isExtension() && HussarUtils.isNotEmpty((Object)(extFieldsObj = (dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)dmDataModelBase.getId())).get((Object)"extFields")))) {
            Map extFields = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)extFieldsObj), (TypeReference)new TypeReference<Map<String, List<JSONObject>>>(){}, (Feature[])new Feature[0]);
            return extFields;
        }
        return new HashMap<String, List<JSONObject>>();
    }

    private List<JSONObject> getExtSlaveTables(DmDataModelBase dmDataModelBase) throws LcdpException {
        JSONObject dataModelJsonExt;
        Object extSlaveTablesObj;
        if (AppContextUtil.isExtension() && !dmDataModelBase.isExtension() && HussarUtils.isNotEmpty((Object)(extSlaveTablesObj = (dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)dmDataModelBase.getId())).get((Object)"slaveTables")))) {
            return JSONObject.parseArray((String)JSONObject.toJSONString((Object)extSlaveTablesObj), JSONObject.class);
        }
        return new ArrayList<JSONObject>();
    }

    private Map<String, List<JSONObject>> getExtSlaveTableFields(DmDataModelBase dmDataModelBase) throws LcdpException {
        List<JSONObject> slaveTables = this.getExtSlaveTables(dmDataModelBase);
        HashMap<String, List<JSONObject>> extSlaveTableFields = new HashMap<String, List<JSONObject>>();
        if (HussarUtils.isNotEmpty(slaveTables)) {
            for (JSONObject slaveTable : slaveTables) {
                DmDataModelBase extSlaveTable = DmDataModelUtil.transfer(slaveTable);
                String id = extSlaveTable.getId();
                List fields = JSONArray.parseArray((String)JSONObject.toJSONString(extSlaveTable.getFields()), JSONObject.class);
                extSlaveTableFields.put(id, fields);
            }
            return extSlaveTableFields;
        }
        return new HashMap<String, List<JSONObject>>();
    }

    private void setSlaveTables(FieldsContrastParam<DmDataModelField> fieldsContrastParam, DmDataModelBase dmDataModelBase) throws LcdpException {
        JSONObject dataModelJsonExt;
        Object extSlaveTablesObj;
        if (AppContextUtil.isExtension() && !dmDataModelBase.isExtension() && HussarUtils.isNotEmpty((Object)(extSlaveTablesObj = (dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)dmDataModelBase.getId())).get((Object)"slaveTables")))) {
            List slaveTables = JSONObject.parseArray((String)JSONObject.toJSONString((Object)extSlaveTablesObj), JSONObject.class);
            fieldsContrastParam.setSlaveTables(slaveTables);
        }
    }

    private void setSlaveTablesFields(FieldsContrastParam<DmDataModelField> fieldsContrastParam, DmDataModelBase dmDataModelBase) throws LcdpException {
        List slaveTables;
        if (AppContextUtil.isExtension() && !dmDataModelBase.isExtension() && HussarUtils.isNotEmpty((Object)fieldsContrastParam.getSlaveTables()) && HussarUtils.isNotEmpty((Object)(slaveTables = fieldsContrastParam.getSlaveTables()))) {
            for (JSONObject slaveTable : slaveTables) {
                DmDataModelBase extSlaveTable = DmDataModelUtil.transfer(slaveTable);
                String id = extSlaveTable.getId();
                List fields = JSONArray.parseArray((String)JSONObject.toJSONString(extSlaveTable.getFields()), JSONObject.class);
                if (HussarUtils.isEmpty((Object)fieldsContrastParam.getExtFields())) {
                    fieldsContrastParam.setExtFields(new HashMap());
                }
                fieldsContrastParam.getExtFields().put(id, fields);
            }
        }
    }

    public List<ContrastVO<DmDataModelField>> modelContrastTable(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws LcdpException, IOException {
        DmDataModelBase dmDataModelBase = DmDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)fieldsContrastParam.getModelId()));
        this.setExtFields(fieldsContrastParam, dmDataModelBase);
        this.setSlaveTables(fieldsContrastParam, dmDataModelBase);
        return dmDataModelBase.modelContrastTable(fieldsContrastParam);
    }

    public List<ContrastIndexVO> tableContrastModelIndex(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws LcdpException, IOException {
        DmDataModelBase dmDataModelBase = DmDataModelUtil.transfer(DataModelUtil.getDataModelBase((String)fieldsContrastParam.getModelId()));
        return dmDataModelBase.tableContrastModelIndex(fieldsContrastParam);
    }

    public List<ContrastIndexVO> modelContrastTableIndex(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws LcdpException, IOException {
        DmDataModelBase dmDataModelBase = DmDataModelUtil.transfer(DataModelUtil.getDataModelBase((String)fieldsContrastParam.getModelId()));
        return dmDataModelBase.modelContrastTableIndex(fieldsContrastParam);
    }

    public List<ContrastVO<DmDataModelField>> findTableContrast(DataModelBase dataModelBase) throws LcdpException, IOException {
        DmDataModelBase dmDataModelBase = DmDataModelUtil.transfer(dataModelBase);
        return dmDataModelBase.findTableContrast();
    }

    public List<ContrastVO<DmDataModelField>> findTableContrast(JSONObject jsonObject) throws LcdpException, IOException {
        DmDataModelBase dmDataModelBase = DmDataModelUtil.transfer(String.valueOf(jsonObject.get((Object)"functionType")));
        return dmDataModelBase.findTableContrast();
    }

    public PublishCheckVO checkTableContrast(DataModelBase dataModelBase, String modelId) throws LcdpException, IOException {
        DmDataModelBase dmDataModelBase = DmDataModelUtil.transfer(dataModelBase);
        Map<String, List<JSONObject>> extFields = this.getExtFields(dmDataModelBase);
        List<JSONObject> extSlaveTables = this.getExtSlaveTables(dmDataModelBase);
        return dmDataModelBase.checkTableContrast(modelId, extFields, extSlaveTables);
    }

    public Boolean updateTableByModel(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws Exception {
        DmDataModelBase dmDataModelBase = DmDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)fieldsContrastParam.getModelId()));
        this.setSlaveTables(fieldsContrastParam, dmDataModelBase);
        dmDataModelBase.updateTable(fieldsContrastParam);
        return true;
    }

    public String copyTableByModel(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws Exception {
        DmDataModelBase dmDataModelBase = DmDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)fieldsContrastParam.getModelId()));
        this.setSlaveTables(fieldsContrastParam, dmDataModelBase);
        return dmDataModelBase.copyTableByModel(fieldsContrastParam);
    }
}

