/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.view;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.view.DmViewDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.view.DmViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.querycondition.DmQueryCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.querycondition.DmQueryConditionField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortConditionField;
import com.jxdinfo.hussar.formdesign.dm.function.render.DmViewRender;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.constant.DmConstUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.dm.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMVIEWTableQuery")
public class DmViewTableQueryVisitor
implements DmOperationVisitor<DmViewDataModel, DmViewDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmViewTableQueryVisitor.class);
    public static final String OPERATION_NAME = "DMVIEWTableQuery";

    @Override
    public void visit(DmBackCtx<DmViewDataModel, DmViewDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        DmViewDataModel useDataModelBase = backCtx.getUseDataModelBase();
        DmViewDataModelDTO dataModelViewDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelViewDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelViewDTO);
        controllerParams.put("returnValue", dataModelViewDTO.getEntityName());
        controllerParams.put("url", url);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelViewDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelViewDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        Boolean isPagination = Boolean.valueOf(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", Boolean.valueOf(isPagination.toString()));
        boolean isSortOverall = true;
        boolean isSelectCondition = this.renderSelectAndSort(backCtx, dataModelOperation, modelId, useDataModelBase, dataModelViewDTO, controllerParams, isPagination, isSortOverall);
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, dataModelViewDTO, controllerParams);
        String controllerPath = "template/dm/backcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelViewDTO.getServiceName());
        String servicePath = "template/dm/backcode/tableQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/dm/backcode/tableQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        if (isSelectCondition) {
            backCtx.addServiceImplInversion(modelId, dataModelViewDTO.getMapperName());
            String mapperPath = "template/dm/backcode/tableQuery/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
            String xmlPath = "template/dm/backcode/tableQuery/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        this.renderImport(backCtx, modelId, dataModelViewDTO, isSelectCondition, isPagination, isSortOverall);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", url, "\u67e5\u8be2");
        backCtx.addApi(modelId, DmViewRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(DmBackCtx<DmViewDataModel, DmViewDataModelDTO> backCtx, String modelId, DmViewDataModelDTO dataModelBaseDTO, boolean isSelectCondition, boolean isPagination, boolean isSortOverall) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.exception.HussarException");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            if (isPagination) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            } else {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            }
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isPagination) {
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
    }

    private boolean renderSelectAndSort(DmBackCtx<DmViewDataModel, DmViewDataModelDTO> backCtx, DmDataModelOperation dataModelOperation, String modelId, DmViewDataModel useDataModelBase, DmViewDataModelDTO dataModelViewDTO, Map<String, Object> controllerParams, Boolean isPagination, boolean isSortOverall) throws LcdpException {
        DmSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{sortConditionName}) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(DmSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<DmSortConditionField> sortConditionFields;
            if (!isPagination.booleanValue()) {
                sortConditionFields = sortCondition.getFields();
                for (DmSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll();
                }
            } else {
                sortConditionFields = sortCondition.getFields();
                for (DmSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName();
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            if (isPagination.booleanValue()) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        boolean isSelectCondition = false;
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            DmQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
            ArrayList<String> likeQueryFields = new ArrayList<String>();
            for (DmQueryConditionField queryConditionField : queryCondition.getFields()) {
                String fromModelField = queryConditionField.getFromModelField();
                List<DmDataModelField> fields = useDataModelBase.getFields();
                boolean isStringType = true;
                for (DmDataModelField field : fields) {
                    if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                    isStringType = false;
                    break;
                }
                if (!isStringType) continue;
                String symbol = queryConditionField.getSymbol();
                if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
                likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
            }
            controllerParams.put("likeQueryFields", likeQueryFields);
            if (Optional.ofNullable(queryCondition).map(DmQueryCondition::getFields).isPresent() && !queryCondition.getFields().isEmpty()) {
                DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
                DmQueryDTO queryDTO = DmDataModelUtil.getQueryDto(dataSet, dataModelViewDTO);
                dataModelViewDTO.addQueryDto(queryDTO);
                String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), DmConstUtil.FALSE, ConnectEnum._AND.getType(), null, dataModelViewDTO, null);
                controllerParams.put("QueryObj", queryDTO.getEntityName());
                controllerParams.put("queryObj", queryDTO.getName());
                controllerParams.put("whereSql", finalWhereSql);
                isSelectCondition = true;
                controllerParams.put("isSelectCondition", DmConstUtil.TRUE);
                String importInfo = queryDTO.getImportInfo();
                backCtx.addControllerImport(modelId, importInfo);
                backCtx.addServiceImport(modelId, importInfo);
                backCtx.addServiceImplImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            }
        }
        return isSelectCondition;
    }

    private void renderPageVo(DmBackCtx<DmViewDataModel, DmViewDataModelDTO> backCtx, String modelId, DmViewDataModelDTO dataModelViewDTO, Map<String, Object> controllerParams) {
        DmDataModelUtil.addQueryPageViewVo(dataModelViewDTO);
        String voEntityName = dataModelViewDTO.getEntityName() + DmDataModelUtil.PAGE_VO;
        String voImportPath = dataModelViewDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

