/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.task.basetask;

import com.jxdinfo.hussar.formdesign.back.common.constant.QueryType;
import com.jxdinfo.hussar.formdesign.back.common.util.ExtensionOperationJudge;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.querycondition.DmQueryCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.querycondition.DmQueryConditionField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortConditionField;
import com.jxdinfo.hussar.formdesign.dm.function.render.DmBaseRender;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.constant.DmConstUtil;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.task.basetask.DmTaskTableQuery;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.task.basetask.DmTaskTableQueryFlowTotals;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.dm.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.dm.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMTASKTableQuery")
public class DmTaskTableQueryVisitor
implements DmOperationVisitor<DmTaskDataModel, DmTaskDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmTaskTableQueryVisitor.class);
    public static String TASK_PAGE_VO = "TaskPageVO";
    public static final String OPERATION_NAME = "DMTASKTableQuery";

    @Override
    public void visit(DmBackCtx<DmTaskDataModel, DmTaskDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        DmTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        DmTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String type = ExtensionOperationJudge.type(dataModelOperation.getParams());
        if (HussarUtils.equals((Object)ExtensionOperationJudge.REUSED, (Object)type)) {
            this.addApi(backCtx, dataModelOperation, useDataModelDTO, "${PREFIX.standardName}");
            return;
        }
        if (QueryType.isTask((String)((String)dataModelOperation.getParams().get("queryType")))) {
            String businessId = modelId;
            DmFlowDataModel businessDataModelBase = (DmFlowDataModel)useDataModelDTO.getDataModelBaseMap().get(businessId);
            DmFlowDataModelDTO businessDataModelDTO = (DmFlowDataModelDTO)useDataModelDTO.getDataModelDtoMap().get(businessId);
            DmBackCtx<DmFlowDataModel, DmFlowDataModelDTO> newBackCtx = new DmBackCtx<DmFlowDataModel, DmFlowDataModelDTO>();
            newBackCtx.setUseDataModelBase(businessDataModelBase);
            HashMap<String, DmFlowDataModelDTO> map = new HashMap<String, DmFlowDataModelDTO>();
            map.put(businessId, businessDataModelDTO);
            newBackCtx.setUseDataModelDtoMap(map);
            DmTaskTableQuery.visit(newBackCtx, dataModelOperation);
            return;
        }
        if (QueryType.isFlowTotals((String)((String)dataModelOperation.getParams().get("queryType")))) {
            DmTaskTableQueryFlowTotals.visit(backCtx, dataModelOperation);
        }
        boolean isLogicallyDelete = useDataModelBase.getLogicallyDelete();
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, useDataModelDTO, useDataModelBase);
        String mastId = useDataModelBase.getId();
        DmDataModelFieldDto fieldDto = useDataModelDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto);
            String securityLevelSql = useDataModelBase.getModelAliasName().get(mastId) + "." + fieldDto.getName() + " &lt;= #{securityLevel}";
            controllerParams.put("securityLevelSql", securityLevelSql);
            hasSecurityLevel = true;
        }
        if (isLogicallyDelete) {
            controllerParams.put("deleteFlag", useDataModelDTO.getFieldCapitalName(useDataModelBase.getDeleteFlag().getName()));
        }
        Boolean isPagination = Boolean.valueOf(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), useDataModelDTO);
        boolean isSortOverall = true;
        boolean isSelectCondition = this.renderSelectAndSort(backCtx, dataModelOperation, modelId, useDataModelBase, useDataModelDTO, controllerParams, isPagination, isSortOverall);
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, useDataModelDTO, controllerParams);
        String controllerPath = "template/backcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/dm/taskbackcode/basetaskbackcode/query/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/dm/taskbackcode/basetaskbackcode/query/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        String finalReturn = SqlReturnUtil.renderReturn(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName());
        controllerParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, useDataModelDTO.getMapperName());
        String mapperPath = "template/dm/taskbackcode/basetaskbackcode/query/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String finalRelation = SqlReturnUtil.renderRelation(backCtx.getUseDataModelBase(), useDataModelDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        String xmlPath = "template/dm/taskbackcode/basetaskbackcode/query/xml.ftl";
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, useDataModelDTO, isSelectCondition, isPagination, isLogicallyDelete, isSortOverall, hasSecurityLevel);
        this.addApi(backCtx, dataModelOperation, useDataModelDTO, "${PREFIX.name}");
    }

    private void addApi(DmBackCtx<DmTaskDataModel, DmTaskDataModelDTO> backCtx, DmDataModelOperation dataModelOperation, DmTaskDataModelDTO useDataModelDTO, String prefix) throws LcdpException {
        String modelId = backCtx.getUseDataModelBase().getId();
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", useDataModelDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, DmBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(DmBackCtx<DmTaskDataModel, DmTaskDataModelDTO> backCtx, String modelId, DmBaseDataModelDTO dataModelBaseDTO, boolean isSelectCondition, boolean isPagination, boolean isLogicallyDelete, boolean isSortOverall, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "java.util.List");
            if (isPagination) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            } else {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            }
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        if (isLogicallyDelete) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(DmDataModelOperation dataModelOperation, DmTaskDataModelDTO dataModelBaseDTO, DmBaseDataModel dmBaseDataModel) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName());
        boolean isLogicallyDelete = dmBaseDataModel.getLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        String queryType = (String)dataModelOperation.getParams().get("queryType");
        if (isLogicallyDelete) {
            DmDataModelField logicallyField = dmBaseDataModel.getDeleteFlag();
            controllerParams.put("logicallyFlag", logicallyField.getSourceFieldName());
            String logicallyFieldName = logicallyField.getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("getLogicallyFlag", String.valueOf(chars));
            controllerParams.put("deleteFlagName", logicallyField.getSourceFieldName());
        }
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : "") + QueryType.getLabel((String)queryType));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : "") + QueryType.getLabel((String)queryType));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderSelectAndSort(DmBackCtx<DmTaskDataModel, DmTaskDataModelDTO> backCtx, DmDataModelOperation dataModelOperation, String modelId, DmTaskDataModel useDataModelBase, DmTaskDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams, Boolean isPagination, boolean isSortOverall) throws LcdpException {
        DmSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{sortConditionName}) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(DmSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<DmSortConditionField> sortConditionFields;
            List<DmSortConditionField> fields = sortCondition.getFields();
            block0: for (DmSortConditionField dmSortConditionField : fields) {
                String fromModelFieldIdSort = dmSortConditionField.getFromModelFieldIdSort();
                List<DmDataModelField> fromModelFieldSort = useDataModelBase.getFields();
                for (DmDataModelField dmDataModelField : fromModelFieldSort) {
                    if (!dmDataModelField.getId().equals(fromModelFieldIdSort)) continue;
                    dmSortConditionField.setFromModelFieldSort(dmDataModelField.getName());
                    continue block0;
                }
            }
            if (!isPagination.booleanValue()) {
                sortConditionFields = sortCondition.getFields();
                for (DmSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll();
                }
            } else {
                sortConditionFields = sortCondition.getFields();
                for (DmSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName();
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            if (Boolean.TRUE.equals(isPagination)) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        boolean isSelectCondition = false;
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        DmQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
        if (HussarUtils.isNotEmpty((Object)controllerParams.get("securityLevel"))) {
            boolean bl;
            DmQueryConditionField oredElse;
            boolean bl2 = true;
            if (ToolUtil.isNotEmpty((Object)queryCondition) && ToolUtil.isNotEmpty(queryCondition.getFields()) && ToolUtil.isNotEmpty((Object)(oredElse = (DmQueryConditionField)queryCondition.getFields().stream().filter(item -> "securityLevel".equals(item.getUsageType())).findFirst().orElse(null)))) {
                bl = false;
            }
            if (bl) {
                DmDataModelFieldDto fieldDto = (DmDataModelFieldDto)controllerParams.get("securityLevel");
                DmQueryConditionField field = new DmQueryConditionField();
                field.setConnect("and");
                field.setFromModelField(fieldDto.getId());
                field.setQueryAttrName(fieldDto.getPropertyName());
                field.setFromModelId(useDataModelBase.getId());
                field.setType("row");
                field.setSymbol("<=");
                field.setUsageType("securityLevel");
                queryCondition.getFields().add(field);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DmQueryConditionField queryConditionField : queryCondition.getFields()) {
            String fromModelField = queryConditionField.getFromModelField();
            List<DmDataModelField> fields = useDataModelBase.getFields();
            boolean isStringType = true;
            for (DmDataModelField field : fields) {
                if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                isStringType = false;
                break;
            }
            if (!isStringType) continue;
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            arrayList.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        controllerParams.put("likeQueryFields", arrayList);
        if (!Optional.ofNullable(queryCondition).map(DmQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
        DmDataModelField dmDataModelField = useDataModelBase.getDeleteFlag();
        if (useDataModelBase.getLogicallyDelete()) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, dmDataModelField.getName(), useDataModelBase.getId());
        }
        DmQueryDTO queryDTO = DmDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        if (HussarUtils.isNotEmpty((Object)controllerParams.get("securityLevel"))) {
            DmDataModelFieldDto fieldDto = (DmDataModelFieldDto)controllerParams.get("securityLevel");
            DmQueryFieldDTO field = new DmQueryFieldDTO();
            field.setPropertyName(fieldDto.getPropertyName());
            field.setDbColumnType(fieldDto.getColumnType());
            field.setType(fieldDto.getType());
            field.setComment(fieldDto.getComment());
            queryDTO.getQueryFields().add(field);
        }
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = QueryConditionUtil.renderTaskQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, useDataModelBase.getModelAliasName(), dmDataModelField == null ? "" : dmDataModelField.getSourceFieldName());
        if (useDataModelBase.getLogicallyDelete()) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        controllerParams.put("whereSql", finalWhereSql);
        isSelectCondition = true;
        controllerParams.put("isSelectCondition", DmConstUtil.TRUE);
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return isSelectCondition;
    }

    private void renderPageVo(DmBackCtx<DmTaskDataModel, DmTaskDataModelDTO> backCtx, String modelId, DmBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        DmDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + DmDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }

    private void renderTaskPageVo(DmBackCtx<DmTaskDataModel, DmTaskDataModelDTO> backCtx, String modelId, DmBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        DmQueryDTO queryDTO = new DmQueryDTO();
        queryDTO.setFtlPath("template/dm/taskbackcode/code/taskPage.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + TASK_PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + TASK_PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + TASK_PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

