/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.back.common.util.ExtensionOperationJudge;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortConditionField;
import com.jxdinfo.hussar.formdesign.dm.function.render.DmBaseRender;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.constant.DmConstUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMMASTER_SLAVEConditionFilter")
public class DmMsConditionFilterVisitor
implements DmOperationVisitor<DmMsDataModel, DmMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsConditionFilterVisitor.class);
    public static final String OPERATION_NAME = "DMMASTER_SLAVEConditionFilter";

    @Override
    public void visit(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        DmMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        DmMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String type = ExtensionOperationJudge.type(dataModelOperation.getParams());
        if (HussarUtils.equals((Object)ExtensionOperationJudge.REUSED, (Object)type)) {
            this.addApi(backCtx, dataModelOperation, dataModelBaseDTO, "${PREFIX.standardName}");
            return;
        }
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        String masterId = backCtx.getUseDataModelBase().getMasterTable().getId();
        DmMsDataModelDTO dmMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(masterId);
        DmDataModelFieldDto fieldDto = null;
        fieldDto = dmMsDataModelDTO == null ? (DmDataModelFieldDto)dataModelBaseDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null) : (DmDataModelFieldDto)dmMsDataModelDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto.getPropertyName());
            hasSecurityLevel = true;
        }
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        this.renderFilter(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        boolean isSortCondition = this.renderSort(backCtx, dataModelOperation, modelId, controllerParams, useDataModelBase);
        boolean isSortOverall = true;
        controllerParams.put("isSortOverall", isSortOverall);
        if (isLogicallyDelete) {
            String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + useDataModelBase.getDeleteFlag().getSourceFieldName();
            controllerParams.put("logicallyFlag", logicallyFlag);
        }
        controllerParams.put("deploymentMode", AppContextUtil.isHTSZMode());
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), dataModelBaseDTO);
        String controllerPath = "template/dm/masterslavebackcode/conditionFilter/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/dm/masterslavebackcode/conditionFilter/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/dm/masterslavebackcode/conditionFilter/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String finalReturn = SqlReturnUtil.renderReturn(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName());
        controllerParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/dm/masterslavebackcode/conditionFilter/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/dm/masterslavebackcode/conditionFilter/xml.ftl";
        String finalRelation = SqlReturnUtil.renderRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isPagination, isSortOverall, isSortCondition, hasSecurityLevel);
        this.addApi(backCtx, dataModelOperation, dataModelBaseDTO, "${PREFIX.name}");
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void addApi(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation dataModelOperation, DmMsDataModelDTO dataModelBaseDTO, String prefix) throws LcdpException {
        String modelId = backCtx.getUseDataModelBase().getId();
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix(prefix) + "/" + dataModelOperation.getName(), "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2");
        backCtx.addApi(modelId, DmBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, String modelId, DmMsDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSortOverall, boolean isSortCondition, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
        }
        if (isSortCondition) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "java.util.List");
    }

    private boolean renderFilter(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation dataModelOperation, String modelId, DmMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("showFilter"));
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        controllerParams.put("showFilter", true);
        DmQueryDTO queryDTO = DmDataModelUtil.getFilterDto(dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(queryDTO);
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private boolean renderSort(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation dataModelOperation, String modelId, Map<String, Object> controllerParams, DmMsDataModel useDataModelBase) throws LcdpException {
        DmSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(DmSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<DmSortConditionField> sortConditionFields = sortCondition.getFields();
            for (DmSortConditionField sortConditionField : sortConditionFields) {
                sortConditionField.replaceFieldName(useDataModelBase.getMasterTable(), useDataModelBase.getSlaveTables());
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", DmConstUtil.TRUE);
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            return true;
        }
        return false;
    }

    private Map<String, Object> initParams(DmDataModelOperation dataModelOperation, DmMsDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void renderPageVo(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, String modelId, DmMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        DmDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + DmDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

