/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.element.view;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.CheckTable;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.function.DmEnclosure;
import com.jxdinfo.hussar.formdesign.dm.function.DmRender;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseConnector;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmEditDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.querycondition.DmQueryCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.querycondition.DmQueryObject;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortConditionField;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmViewDataModel
extends DmDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(DmViewDataModel.class);
    public static final String FUNCTION_TYPE = "VIEW";
    private String sourceDataModelName;
    private List<DmQueryCondition> queryConditions;
    private List<DmQueryObject> queryObject;
    private List<DmSortCondition> sortCondition;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"DM.VIEW", DmViewDataModel.class);
    }

    @Override
    public DmViewDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        DmViewDataModel dmViewDataModel;
        try {
            dmViewDataModel = (DmViewDataModel)JSONObject.parseObject((String)jsonObject.toString(), DmViewDataModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return dmViewDataModel;
    }

    @Override
    public DmEnclosure<DmDataModelBase> enclosure() throws LcdpException {
        return DmModelBeanUtil.getEnclosureBean("DM", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public DmRender<DmDataModelBase, DmDataModelBaseDTO> render() throws LcdpException {
        return DmModelBeanUtil.getRenderBean("DM", FUNCTION_TYPE, "RENDER");
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<DmQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<DmQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<DmQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<DmQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<DmSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (DmSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (DmSortConditionField field : condition.getFields()) {
                    try {
                        Map<String, String> fieldMap = DmDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)field.getFromModelIdSort())).getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName));
                        String fieldName = fieldMap.get(field.getFromModelFieldIdSort());
                        if (HussarUtils.equals((Object)fieldName, (Object)field.getFromModelFieldSort())) continue;
                        field.setFromModelFieldSort(fieldName);
                    }
                    catch (LcdpException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<DmSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public DmQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (DmQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return new DmQueryCondition();
    }

    @Override
    public DmSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (DmSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new DmSortCondition();
    }

    public Optional<TableInfo> findTable(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional infoOptional;
        TableInfo table = null;
        boolean findCurrentTable = false;
        List tableCorresponds = fieldsContrastParam.getTableCorresponds();
        if (tableCorresponds != null) {
            for (TableCorrespond tableCorrespond : tableCorresponds) {
                if (!this.getId().equals(tableCorrespond.getModelId())) continue;
                String changeName = tableCorrespond.getTableName().toUpperCase();
                Optional infoOptional2 = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)changeName);
                findCurrentTable = infoOptional2.isPresent();
                if (!findCurrentTable) break;
                table = (TableInfo)infoOptional2.get();
                break;
            }
        }
        if (!findCurrentTable && (findCurrentTable = (infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)this.sourceDataModelName.toUpperCase())).isPresent())) {
            table = (TableInfo)infoOptional.get();
        }
        return Optional.ofNullable(table);
    }

    private List<DmDataModelField> extFields(FieldsContrastParam<DmDataModelField> fieldsContrastParam) {
        List extFieldJsons;
        List<DmDataModelField> extFields = new ArrayList<DmDataModelField>();
        if (HussarUtils.isNotEmpty((Object)fieldsContrastParam.getExtFields()) && HussarUtils.isNotEmpty((Object)(extFieldJsons = (List)fieldsContrastParam.getExtFields().get(this.getId())))) {
            extFields = JSONArray.parseArray((String)JSON.toJSONString((Object)extFieldJsons), DmDataModelField.class);
        }
        return extFields;
    }

    @Override
    public List<ContrastVO<DmDataModelField>> tableContrastModel(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable(fieldsContrastParam);
        ContrastVO<DmDataModelField> contrast = new ContrastVO<DmDataModelField>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = DmDataModelUtil.contrastWithIgnoreCase(table.getFields(), this.getFields(), this.extFields(fieldsContrastParam));
            contrast.setTableFields(DmDataModelUtil.tabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        ArrayList<ContrastVO<DmDataModelField>> contrastVOS = new ArrayList<ContrastVO<DmDataModelField>>();
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<DmDataModelField>> findTableContrast() throws IOException, LcdpException {
        ArrayList<ContrastVO<DmDataModelField>> contrastVOS = new ArrayList<ContrastVO<DmDataModelField>>();
        ContrastVO contrast = new ContrastVO();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)this.sourceDataModelName.toUpperCase());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        contrast.setModelId(this.getId());
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId, Map<String, List<JSONObject>> extFields, List<JSONObject> extSlaveTables) throws IOException, LcdpException {
        PublishCheckVO contrastVOS = new PublishCheckVO();
        contrastVOS.setModelId(modelId);
        ArrayList<CheckTable> contrast = new ArrayList<CheckTable>();
        CheckTable info = new CheckTable();
        long start = System.currentTimeMillis();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)this.sourceDataModelName.toUpperCase());
        if (!infoOptional.isPresent()) {
            info.setState(Integer.valueOf(0));
        } else {
            TableInfo table = (TableInfo)infoOptional.get();
            LOGGER.info("\u53d1\u5e03\u65f6\u6821\u9a8c\u67e5\u8be2\u5355\u8868{}\u8017\u65f6\uff1a{}", (Object)this.sourceDataModelName.toUpperCase(), (Object)ToolUtil.logTime((long)start));
            if (ToolUtil.isNotEmpty((Object)table)) {
                ContrastVO<DmDataModelField> model;
                List<JSONObject> extFieldJsons = extFields.get(this.getId());
                ArrayList<DmDataModelField> fields = new ArrayList();
                if (HussarUtils.isNotEmpty(extFieldJsons)) {
                    fields = JSONArray.parseArray((String)JSON.toJSONString(extFieldJsons), DmDataModelField.class);
                }
                if ((model = DmDataModelUtil.contrastWithView(table.getFields(), this.getFields(), fields)).getAddFields().size() == 0 && model.getDelFields().size() == 0 && model.getModifyFields().size() == 0) {
                    info.setState(Integer.valueOf(2));
                } else {
                    info.setState(Integer.valueOf(1));
                }
            } else {
                info.setState(Integer.valueOf(0));
            }
        }
        info.setModelId(this.getId());
        contrast.add(info);
        contrastVOS.setDetails(contrast);
        return contrastVOS;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws Exception {
        boolean findCurrentTable;
        String dataSourceName = this.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return false;
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasourceLr = sysDataSourceService.getByConnName(dataSourceName);
        datasourceLr.setDbName(dataSourceName);
        TableCorrespond info = new TableCorrespond();
        if (fieldsContrastParam.getTableCorresponds() != null) {
            for (int x = 0; x < fieldsContrastParam.getTableCorresponds().size(); ++x) {
                if (!this.getId().equals(((TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x)).getModelId())) continue;
                info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x);
                break;
            }
        }
        if (!(findCurrentTable = info.getTableName() != null && ToolUtil.isNotEmpty((Object)info.getTableName()) ? DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)info.getTableName()).isPresent() : DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)this.sourceDataModelName.toUpperCase()).isPresent())) {
            this.creatTabs(datasourceLr);
            return true;
        }
        this.editTabs(datasourceLr, (TableCorrespond<DmDataModelField>)info);
        return true;
    }

    public void creatTabs(SysDataSource datasourceLr) {
        MetadataParam metadataParam = new MetadataParam();
        TableInfoDto tableInfoDto = DmBaseConnector.tableInfoInCreate(datasourceLr, this);
        metadataParam.setTableInfo(tableInfoDto);
        metadataParam.setColumnInfo(DmBaseConnector.transferColumn(this.getFields(), ""));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.createTable(metadataParam);
    }

    public void editTabs(SysDataSource datasourceLr, TableCorrespond<DmDataModelField> info) throws Exception {
        MetadataParam paramData = new MetadataParam();
        TableInfoDto tableInfoDto = DmBaseConnector.tableInfoInEdit(datasourceLr, this);
        paramData.setTableInfo(tableInfoDto);
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        List delFields = JSONArray.parseArray((String)info.getDelFields(), DmDataModelField.class);
        for (int y = 0; y < delFields.size(); ++y) {
            ColumnInfoDto del = new ColumnInfoDto();
            del.setColumnName(((DmDataModelField)((Object)delFields.get(y))).getSourceFieldName());
            deletedCols.add(del);
        }
        paramData.setDeletedCols(deletedCols);
        List addFields = JSONArray.parseArray((String)info.getAddFields(), DmDataModelField.class);
        List editFields = JSONArray.parseArray((String)info.getModifyFields(), DmEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)info.getOldTableName().toUpperCase());
        if (!infoOptional.isPresent()) {
            return;
        }
        TableInfo table = (TableInfo)infoOptional.get();
        List<ColumnInfoDto> oldColumn = this.transform(DmDataModelUtil.tabTransmodel(table.getFields()));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.editTable(paramData, oldColumn, info.getOldTableName());
    }

    public List<ColumnInfoDto> transformDto(List<DmDataModelField> getFields, String state) throws Exception {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (int i = 0; i < getFields.size(); ++i) {
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
            columnInfo.setColumnComment(getFields.get(i).getComment());
            columnInfo.setRequired("0");
            if ("primary".equals(getFields.get(i).getUsage())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
            } else {
                columnInfo.setPk("0");
            }
            if (getFields.get(i).getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
            columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getDataDot()));
            columnInfo.setColumnComment(getFields.get(i).getComment());
            columnInfo.setDataType(getFields.get(i).getSourceDataType());
            if (!"all".equals(state)) {
                columnInfo.setOperation(state);
            }
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transformEdit(List<DmEditDataModelField> getFields, String state) throws Exception {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (int i = 0; i < getFields.size(); ++i) {
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(getFields.get(i).getNewField().getSourceFieldName());
            columnInfo.setColumnComment(getFields.get(i).getNewField().getComment());
            columnInfo.setRequired("0");
            if ("primary".equals(getFields.get(i).getNewField().getUsage())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
            } else {
                columnInfo.setPk("0");
            }
            if (getFields.get(i).getNewField().getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataLength(Long.valueOf(getFields.get(i).getNewField().getDataLength()));
            columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getNewField().getDataDot()));
            columnInfo.setDataType(getFields.get(i).getNewField().getSourceDataType());
            columnInfo.setOldColumnName(getFields.get(i).getOldField().getSourceFieldName());
            if (!"all".equals(state)) {
                columnInfo.setOperation(state);
            }
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transform(List<DmDataModelField> getFields) throws Exception {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (int i = 0; i < getFields.size(); ++i) {
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
            columnInfo.setColumnComment(getFields.get(i).getComment());
            columnInfo.setRequired("0");
            if ("primary".equals(getFields.get(i).getUsage())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
            } else {
                columnInfo.setPk("0");
            }
            if (getFields.get(i).getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
            columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getDataDot()));
            columnInfo.setDataType(getFields.get(i).getSourceDataType());
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws Exception {
        String dataSourceName = this.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return "";
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasourceLr = sysDataSourceService.getByConnName(dataSourceName);
        datasourceLr.setDbName(dataSourceName);
        TableCorrespond info = new TableCorrespond();
        if (fieldsContrastParam.getTableCorresponds() != null) {
            for (int x = 0; x < fieldsContrastParam.getTableCorresponds().size(); ++x) {
                if (!this.getId().equals(((TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x)).getModelId())) continue;
                info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x);
                break;
            }
        }
        return this.doCopy(datasourceLr, (TableCorrespond<DmDataModelField>)info);
    }

    public String doCopy(SysDataSource datasourceLr, TableCorrespond<DmDataModelField> info) throws Exception {
        MetadataParam paramData = new MetadataParam();
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        List delFields = JSONArray.parseArray((String)info.getDelFields(), DmDataModelField.class);
        for (int y = 0; y < delFields.size(); ++y) {
            ColumnInfoDto del = new ColumnInfoDto();
            del.setColumnName(((DmDataModelField)((Object)delFields.get(y))).getSourceFieldName());
            deletedCols.add(del);
        }
        paramData.setDeletedCols(deletedCols);
        List addFields = JSONArray.parseArray((String)info.getAddFields(), DmDataModelField.class);
        List editFields = JSONArray.parseArray((String)info.getModifyFields(), DmEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)info.getOldTableName().toUpperCase());
        TableInfo table = infoOptional.orElseGet(TableInfo::new);
        List<Object> oldColumn = new ArrayList();
        TableInfoDto tableInfoDto = DmBaseConnector.tableInfoInCreate(datasourceLr, this);
        paramData.setTableInfo(tableInfoDto);
        if (table.getFields() != null) {
            oldColumn = this.transform(DmDataModelUtil.tabTransmodel(table.getFields()));
            if (StringUtil.isNotEmpty((Object)tableInfoDto.getTableDec()) && tableInfoDto.getTableDec().equals(table.getComment())) {
                tableInfoDto.setTableDec(null);
            }
        } else {
            paramData.setColumnInfo(this.transformDto(this.getFields(), "all"));
        }
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        return ddlService.getDdlSql(paramData, oldColumn, info.getOldTableName());
    }
}

